/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.composer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.framework.ui.FrameworkCompositePathDialog;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComposerPathDialog
extends FrameworkCompositePathDialog {
    static ComposerPathDialog getInstance(@Nullable Component component) {
        FrameworkCompositePathDialog.TextsBuilder builder = new FrameworkCompositePathDialog.TextsBuilder(){
            {
                this.myTitle = FrameworkBundle.message("framework.composer.name.composer", new Object[0]);
                this.myScriptRadioButtonText = FrameworkBundle.message("framework.composer.path.dlg.script.radio.button.composer.phar.or.php.script", new Object[0]);
                this.myScriptPathLabelText = FrameworkBundle.message("framework.composer.path.dialog.path.to.composer.phar", new Object[0]);
                this.myScriptFileDescriptorTitle = FrameworkBundle.message("framework.composer.path.dialog.path.to.composer", new Object[0]);
                this.myScriptFileDescriptorDescription = FrameworkBundle.message("framework.composer.path.dlg.script.descriptor.description.specify.composer.phar.or.script", new Object[0]);
                this.myExecutableRadioButtonText = FrameworkBundle.message("framework.composer.path.dlg.executable.radio.button.composer.executable", new Object[0]);
                this.myExecutablePathLabelText = FrameworkBundle.message("framework.composer.path.dlg.executable.label.path.to.executable", new Object[0]);
                this.myExecutableFileDescriptorTitle = FrameworkBundle.message("framework.composer.path.dialog.path.to.composer", new Object[0]);
                this.myExecutableFileDescriptorDescription = FrameworkBundle.message("framework.composer.path.dlg.executable.descriptor.description.specify.composer.executable", new Object[0]);
            }
        };
        return component == null ? new ComposerPathDialog(builder) : new ComposerPathDialog(component, builder);
    }

    private ComposerPathDialog(FrameworkCompositePathDialog.TextsBuilder builder) {
        super(builder, false);
    }

    private ComposerPathDialog(@NotNull Component component, FrameworkCompositePathDialog.TextsBuilder builder) {
        if (component == null) {
            ComposerPathDialog.$$$reportNull$$$0(0);
        }
        super(component, builder, false);
    }

    @Override
    @Nullable
    protected String getInitialScriptPath() {
        VirtualFile initialPhar = ComposerUtils.findFileInProject((Project)this.myProject, (String)"composer.phar");
        if (initialPhar == null) {
            initialPhar = ComposerUtils.findFileInProject((Project)this.myProject, (String)"composer");
        }
        if (initialPhar != null) {
            return initialPhar.getPath();
        }
        return null;
    }

    @Override
    @Nullable
    protected ValidationInfo createScriptValidationInfo(TextFieldWithBrowseButton phpCodePathField) {
        return ComposerPathDialog.createValidationInfo((JComponent)phpCodePathField, this.getScriptPath(), FrameworkBundle.message("framework.composer.path.dlg.path.is.not.provided", new Object[0]), FrameworkBundle.message("framework.composer.path.dlg.file.0.does.not.exist", phpCodePathField.getText()));
    }

    @Override
    @Nullable
    protected String getScriptPath(String input) {
        if (StringUtil.isEmpty((String)input)) {
            return "";
        }
        File providedFile = new File(input);
        if (providedFile.exists()) {
            return FileUtil.toSystemDependentName((String)providedFile.getPath());
        }
        return null;
    }

    @Override
    @Nullable
    protected String getInitialExecutablePath() {
        return null;
    }

    @Override
    @Nullable
    protected ValidationInfo createExecutableValidationInfo(TextFieldWithBrowseButton executablePathField) {
        return ComposerPathDialog.createValidationInfo((JComponent)executablePathField, this.getExecutablePath(), FrameworkBundle.message("framework.composer.path.dlg.path.is.not.provided", new Object[0]), FrameworkBundle.message("framework.composer.path.dlg.file.does.not.exist", new Object[0]));
    }

    @Override
    @Nullable
    protected String getExecutablePath(String providedPath) {
        return ComposerPathDialog.getExistingFile(providedPath);
    }

    @Override
    protected String getDimensionServiceKey() {
        return "ComposerCompositePathDialog";
    }

    @Override
    @NonNls
    @Nullable
    protected String getHelpId() {
        return "settings.composer";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/php/framework/generators/composer/ComposerPathDialog", "<init>"));
    }
}

