/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.twig.TwigFileViewProvider;
import com.jetbrains.twig.formatter.TwigFormatterOptions;
import org.jetbrains.annotations.NotNull;

public class TwigTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            TwigTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TwigTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TwigTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            TwigTypedHandler.$$$reportNull$$$0(3);
        }
        if (!(file.getViewProvider() instanceof TwigFileViewProvider)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (c != '{' && c != '%' && c != '#') {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        char charBefore = TwigTypedHandler.getCharAt(editor.getDocument(), offset - 1);
        char charAfter = TwigTypedHandler.getCharAt(editor.getDocument(), offset);
        if (charBefore == '{') {
            StringBuilder buf = new StringBuilder();
            String space = TwigTypedHandler.isWhitespaceRequired(project, c) ? " " : "";
            buf.append(c).append(space);
            if (TwigTypedHandler.isClosingSequenceNeeded(editor, offset, c)) {
                buf.append(space).append(c == '{' ? (char)'}' : (char)c);
                if (charAfter != '}') {
                    buf.append('}');
                }
            }
            TwigTypedHandler.typeInStringAndMoveCaret(editor, buf.toString(), 1 + space.length());
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(editor.getDocument());
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            TwigTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    private static boolean isClosingSequenceNeeded(Editor editor, int afterOffset, char openingChar) {
        char closingChar = openingChar == '{' ? (char)'}' : (char)openingChar;
        CharSequence docCharSequence = editor.getDocument().getCharsSequence();
        for (int offset = afterOffset; offset < docCharSequence.length(); ++offset) {
            char nextChar;
            char currChar = docCharSequence.charAt(offset);
            char c = nextChar = offset + 1 < docCharSequence.length() ? docCharSequence.charAt(offset + 1) : (char)'\u0000';
            if (currChar == '{' && nextChar == openingChar) {
                return true;
            }
            if (currChar != closingChar || nextChar != '}') continue;
            return false;
        }
        return true;
    }

    private static char getCharAt(Document document, int offset) {
        if (offset >= document.getTextLength() || offset < 0) {
            return '\u0000';
        }
        return document.getCharsSequence().charAt(offset);
    }

    private static void typeInStringAndMoveCaret(Editor editor, String str, int caretShift) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)str, (boolean)true, (int)caretShift);
    }

    private static boolean isWhitespaceRequired(Project project, char c) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        TwigFormatterOptions options = (TwigFormatterOptions)settings.getCustomSettings(TwigFormatterOptions.class);
        if (options == null) {
            return false;
        }
        switch (c) {
            case '%': {
                return options.SPACES_INSIDE_DELIMITERS;
            }
            case '{': {
                return options.SPACES_INSIDE_VARIABLE_DELIMITERS;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/TwigTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/TwigTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

