/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.model.DataType;
import com.intellij.sql.psi.SqlPrimitiveType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlType {
    public static final SqlPrimitiveType UNKNOWN = new SqlPrimitiveType(DataType.UNKNOWN, Category.UNKNOWN){};

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract Category getCategory();

    @NotNull
    public abstract DataType getDataType();

    public String toString() {
        return this.getDisplayName();
    }

    public static enum Category {
        UNKNOWN,
        DEFAULT,
        INTEGER,
        REAL,
        STRING,
        BOOLEAN,
        DATE_TIME,
        DATE,
        TIME,
        TIMESTAMP,
        INTERVAL,
        BYTES,
        REFERENCE,
        ARRAY,
        COLLECTION,
        TABLE,
        RECORD,
        SETOF;


        public boolean is(@Nullable SqlType type) {
            return type != null && type.getCategory() == this;
        }

        public static Category findByJdbcType(int jdbcType) {
            switch (jdbcType) {
                case -7: 
                case -6: 
                case -5: 
                case 1: 
                case 4: 
                case 5: {
                    return INTEGER;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    return REAL;
                }
                case -1: 
                case 12: 
                case 2005: 
                case 2011: {
                    return STRING;
                }
                case 91: {
                    return DATE;
                }
                case 92: {
                    return TIME;
                }
                case 93: {
                    return TIMESTAMP;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2000: 
                case 2004: {
                    return BYTES;
                }
                case 2003: {
                    return ARRAY;
                }
                case 16: {
                    return BOOLEAN;
                }
            }
            return UNKNOWN;
        }
    }
}

