/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.remote.AuthType;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import java.io.File;
import java.util.Properties;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.jetbrains.annotations.NotNull;

public class PatchedSftpClientFactory {
    private PatchedSftpClientFactory() {
    }

    @NotNull
    public static SessionConfig configConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        SessionConfig sessionConfig;
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        File knownHostsFile = builder.getKnownHosts(fileSystemOptions);
        IdentityInfo[] identities = builder.getIdentityInfo(fileSystemOptions);
        IdentityRepositoryFactory repositoryFactory = builder.getIdentityRepositoryFactory(fileSystemOptions);
        try {
            String proxyHost;
            String compression;
            String preferredAuthentications;
            SessionConfig sessionConfig2 = SessionConfig.Factory.createSessionConfig(new String(username), hostname, port);
            sessionConfig2.setKnownHostsFile(knownHostsFile);
            sessionConfig2.setIdentities(SftpUtil.unwrap(identities));
            sessionConfig2.setIdentityRepositoryFactory(SftpUtil.unwrap(repositoryFactory));
            if (password != null) {
                sessionConfig2.setPassword(new String(password));
            }
            if (builder.getAuthType(fileSystemOptions) == AuthType.OPEN_SSH) {
                sessionConfig2.setOpenSSHConfig(OpenSSHConfigService.getInstance().getConfig());
            }
            Integer timeout = builder.getTimeout(fileSystemOptions);
            sessionConfig2.setTimeout(timeout);
            UserInfo userInfo = builder.getUserInfo(fileSystemOptions);
            sessionConfig2.setUserInfo(userInfo);
            Properties config = new Properties();
            String strictHostKeyChecking = builder.getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                config.setProperty("StrictHostKeyChecking", strictHostKeyChecking);
            }
            if ((preferredAuthentications = builder.getPreferredAuthentications(fileSystemOptions)) != null) {
                config.setProperty("PreferredAuthentications", preferredAuthentications);
            }
            if ((compression = builder.getCompression(fileSystemOptions)) != null) {
                config.setProperty("compression.s2c", compression);
                config.setProperty("compression.c2s", compression);
            }
            if ((proxyHost = builder.getProxyHost(fileSystemOptions)) != null) {
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = builder.getProxyType(fileSystemOptions);
                ProxyHTTP proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals((Object)proxyType)) {
                    proxy = SftpClientFactory.createProxyHTTP((String)proxyHost, (int)proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals((Object)proxyType)) {
                    proxy = SftpClientFactory.createProxySOCKS5((String)proxyHost, (int)proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_STREAM.equals((Object)proxyType)) {
                    proxy = SftpClientFactory.createStreamProxy((String)proxyHost, (int)proxyPort, (FileSystemOptions)fileSystemOptions, (SftpFileSystemConfigBuilder)builder);
                }
                if (proxy != null) {
                    sessionConfig2.setProxy((Proxy)proxy);
                }
            }
            if (config.size() > 0) {
                sessionConfig2.setConfig(config);
            }
            SocketFactory socketFactory = builder.getSocketFactory(fileSystemOptions);
            sessionConfig2.setSocketFactory(socketFactory);
            Integer keepAliveTimeout = builder.getKeepAliveTimeout(fileSystemOptions);
            sessionConfig2.setServerAliveInterval(keepAliveTimeout);
            Integer keepAliveCountMax = builder.getKeepAliveMaxCount(fileSystemOptions);
            sessionConfig2.setServerAliveCountMax(keepAliveCountMax);
            sessionConfig2.setDaemonThread(true);
            sessionConfig = sessionConfig2;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Throwable)exc, new Object[]{hostname});
        }
        if (sessionConfig == null) {
            PatchedSftpClientFactory.$$$reportNull$$$0(0);
        }
        return sessionConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/connections/PatchedSftpClientFactory", "configConnection"));
    }
}

