/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingOutputConsole
extends AdditionalTabComponent
implements DataProvider {
    public static final String TAB_TITLE = "XSLT Output";
    private final ConsoleView myConsole;
    private final JComponent myConsoleComponent;

    public HighlightingOutputConsole(Project project, @Nullable FileType fileType) {
        super((LayoutManager)new BorderLayout());
        this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        this.myConsoleComponent = this.myConsole.getComponent();
        this.add(this.myConsoleComponent, "Center");
        EditorEx editorEx = this.getEditor();
        assert (editorEx != null);
        if (fileType != null) {
            EditorHighlighterProvider provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType);
            EditorHighlighter highlighter = provider.getEditorHighlighter(project, fileType, null, editorEx.getColorsScheme());
            editorEx.setHighlighter(highlighter);
        }
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        return null;
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return null;
    }

    public boolean isContentBuiltIn() {
        return true;
    }

    @Nullable
    private EditorEx getEditor() {
        return (EditorEx)((DataProvider)this.myConsole).getData(LangDataKeys.EDITOR.getName());
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myConsoleComponent;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            HighlightingOutputConsole.$$$reportNull$$$0(0);
        }
        if (LangDataKeys.EDITOR.is(dataId)) {
            return this.getEditor();
        }
        return null;
    }

    void selectOutputTab() {
        Container parent = this.getParent();
        if (parent instanceof JTabbedPane) {
            ((JTabbedPane)parent).setSelectedComponent((Component)((Object)this));
        }
    }

    @NotNull
    public String getTabTitle() {
        if (TAB_TITLE == null) {
            HighlightingOutputConsole.$$$reportNull$$$0(1);
        }
        return TAB_TITLE;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myConsole);
    }

    public ConsoleView getConsole() {
        return this.myConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/run/HighlightingOutputConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/run/HighlightingOutputConsole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

