/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQuotedStringToTemplateStringIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        if (element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) {
            return JSQuotedStringToTemplateStringIntention.tryGetSingleLiteralExpression(element) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSLiteralExpression jsLiteralExpression;
        if (project == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(3);
        }
        if ((jsLiteralExpression = JSQuotedStringToTemplateStringIntention.tryGetSingleLiteralExpression(element)) != null) {
            JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate(jsLiteralExpression);
        }
    }

    @Nullable
    private static JSLiteralExpression tryGetSingleLiteralExpression(@NotNull PsiElement element) {
        if (element == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(4);
        }
        JSLiteralExpression literal = null;
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            literal = (JSLiteralExpression)element;
        }
        if (element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL && element.getParent() instanceof JSLiteralExpression) {
            literal = (JSLiteralExpression)element.getParent();
        }
        if (literal != null && !(literal.getParent() instanceof JSBinaryExpression)) {
            return literal;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.replace.string.with.es6.template", (Object[])new Object[0]);
        if (string == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.replace.string.with.es6.template.family", (Object[])new Object[0]);
        if (string == null) {
            JSQuotedStringToTemplateStringIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryGetSingleLiteralExpression";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

