/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ES6FunctionParser<T extends JavaScriptParser>
extends FunctionParser<T> {
    public static final Key<Boolean> HAD_ASYNC_MODIFIER_KEY = Key.create((String)"js.asyncModifier");
    private static final JSModifiersStructure ARROW_FUNCTION_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD);

    public ES6FunctionParser(T parser) {
        super(parser);
    }

    @Override
    public boolean parseFunctionNoMarker(FunctionParser.Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            ES6FunctionParser.$$$reportNull$$$0(0);
        }
        Boolean isAsync = (Boolean)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        Boolean wasAsync = (Boolean)this.builder.getUserData(ASYNC_METHOD_KEY);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)isAsync);
        boolean result2 = super.parseFunctionNoMarker(context, functionMarker);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)wasAsync);
        return result2;
    }

    @Override
    public boolean hasSupportDecorators() {
        return true;
    }

    @Override
    public boolean isFunctionDeclarationStart() {
        IElementType tokenType = this.builder.getTokenType();
        return tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
    }

    @Override
    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            return false;
        }
        PsiBuilder.Marker modifierList = this.builder.mark();
        boolean hadAttributes = this.tryParseES7Decorators();
        if (hadAttributes && ((StatementParser)this.myJavaScriptParser.getStatementParser()).isExportDefault()) {
            modifierList.done(this.getAttributeListElementType());
            return true;
        }
        boolean hadExport = false;
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            hadExport = true;
            this.builder.advanceLexer();
        }
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.TRUE);
        }
        if (!hadExport && JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        modifierList.done(this.getAttributeListElementType());
        return true;
    }

    @Override
    public boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        if (arrowFunction == null) {
            ES6FunctionParser.$$$reportNull$$$0(1);
        }
        Boolean wasAsync = (Boolean)this.builder.getUserData(ASYNC_METHOD_KEY);
        Boolean wasGenerator = this.isGeneratorContext();
        this.parseArrowFunctionAttributeList();
        Boolean isAsync = (Boolean)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)isAsync);
        boolean result2 = super.parseArrowFunctionWithoutModifiers(arrowFunction);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)wasAsync);
        this.setIsGenerator(wasGenerator);
        return result2;
    }

    @Override
    protected boolean isValidFirstParameterStart(IElementType next) {
        IElementType nextLookAhead;
        return super.isValidFirstParameterStart(next) && (next != JSTokenTypes.ASYNC_KEYWORD || (nextLookAhead = this.builder.lookAhead(2)) != JSTokenTypes.LPAR && nextLookAhead != JSTokenTypes.MULT);
    }

    protected void parseArrowFunctionAttributeList() {
        this.myJavaScriptParser.parseModifiers(ARROW_FUNCTION_MODIFIERS, false, builder -> this.isAcceptableLambdaTokenAfterAsync(builder.getTokenType()));
    }

    protected boolean isAcceptableLambdaTokenAfterAsync(IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR || this.myJavaScriptParser.isIdentifierName(tokenType);
    }

    @Override
    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        Boolean isAsync = (Boolean)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        Boolean wasAsync = (Boolean)this.builder.getUserData(FunctionParser.ASYNC_METHOD_KEY);
        this.builder.putUserData(FunctionParser.ASYNC_METHOD_KEY, (Object)isAsync);
        boolean lexerAdvanced = super.parseParameterListAndBody(marker, elementType);
        this.builder.putUserData(FunctionParser.ASYNC_METHOD_KEY, (Object)wasAsync);
        return lexerAdvanced;
    }

    @Override
    protected boolean hasParameterInitializers() {
        return true;
    }

    @Override
    public boolean allowLastCommaInParameterAndArgumentList() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/parsing/ES6FunctionParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

