/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeFilePathReferenceProvider
extends StaticPathReferenceProvider {
    private Function<PsiFile, Collection<PsiFileSystemItem>> myDefaultPathEvaluator;
    private boolean myOnlyFolders;

    public ComposeFilePathReferenceProvider() {
        this(null);
    }

    public ComposeFilePathReferenceProvider(@Nullable FileType[] suitableFileTypes) {
        super(suitableFileTypes);
        this.setEndingSlashNotAllowed(false);
        this.setRelativePathsAllowed(true);
    }

    public ComposeFilePathReferenceProvider withOnlyFolders(boolean onlyFolders) {
        this.myOnlyFolders = onlyFolders;
        return this;
    }

    public ComposeFilePathReferenceProvider withDefaultPathEvaluator(@NotNull DefaultPathEvaluator defaultPathEvaluator) {
        if (defaultPathEvaluator == null) {
            ComposeFilePathReferenceProvider.$$$reportNull$$$0(0);
        }
        this.myDefaultPathEvaluator = defaultPathEvaluator;
        return this;
    }

    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, final boolean soft) {
        if (psiElement == null) {
            ComposeFilePathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (references == null) {
            ComposeFilePathReferenceProvider.$$$reportNull$$$0(2);
        }
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, false, null){

            protected boolean isUrlEncoded() {
                return false;
            }

            protected boolean isSoft() {
                return soft;
            }

            public boolean couldBeConvertedTo(boolean relative) {
                return false;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return ComposeFilePathReferenceProvider.this.myOnlyFolders ? DIRECTORY_FILTER : Conditions.alwaysTrue();
            }
        };
        if (this.myDefaultPathEvaluator != null) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, this.myDefaultPathEvaluator);
        }
        Collections.addAll(references, set.getAllReferences());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPathEvaluator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeFilePathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withDefaultPathEvaluator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface DefaultPathEvaluator
    extends Function<PsiFile, Collection<PsiFileSystemItem>> {
    }
}

