/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbRefactoringHelper {
    public static final TableDialogSettings.Settings DB_SETTINGS = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.EXEC_IN_DB, TableDialogSettings.Settings.CodeType.ALTER_CODE);
    public static final TableDialogSettings.Settings SQL_SETTINGS = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.REPLACE_DDL, TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE);
    private static final Set<ObjectKind> ourEditable = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.FOREIGN_KEY, ObjectKind.KEY});

    public static boolean isForceCreate(@NotNull DasObject object, @NotNull DatabaseEditorContext context) {
        if (object == null) {
            DbRefactoringHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DbRefactoringHelper.$$$reportNull$$$0(1);
        }
        return ObjectLocation.getSql(object, context) != null;
    }

    @Nullable
    public static DatabaseEditorContext createContext(@NotNull DasObject obj, @Nullable PsiElement place, boolean light) {
        DbElement db;
        SqlElement element2;
        if (obj == null) {
            DbRefactoringHelper.$$$reportNull$$$0(2);
        }
        SqlFile file = null;
        if (place != null && place.getContainingFile() instanceof SqlFile) {
            file = (SqlFile)place.getContainingFile();
        }
        if (file == null && (element2 = ObjectLocation.getSql(obj, (DbDataSource)null)) != null) {
            file = (SqlFile)element2.getContainingFile();
        }
        if ((db = ObjectLocation.getDb(obj)) != null) {
            return new DatabaseEditorContext(db, file == null ? null : file.getViewProvider().getVirtualFile());
        }
        if (file != null) {
            return DatabaseEditorContext.forFile(file, light);
        }
        return null;
    }

    @NotNull
    public static AbstractDbRefactoringDialog.ResultProcessor getResultProcessor(@NotNull BasicElement obj, @NotNull AbstractDbRefactoringDialog<?> dialog, @Nullable PsiElement place) {
        SqlElement element2;
        if (obj == null) {
            DbRefactoringHelper.$$$reportNull$$$0(3);
        }
        if (dialog == null) {
            DbRefactoringHelper.$$$reportNull$$$0(4);
        }
        if ((element2 = ObjectLocation.getSql((DasObject)obj, dialog.getContext())) != null) {
            GenericEditingResultProcessor genericEditingResultProcessor = new GenericEditingResultProcessor(dialog, SQL_SETTINGS, DbRefactoringHelper.getPlace(place));
            if (genericEditingResultProcessor == null) {
                DbRefactoringHelper.$$$reportNull$$$0(5);
            }
            return genericEditingResultProcessor;
        }
        GenericEditingResultProcessor genericEditingResultProcessor = new GenericEditingResultProcessor(dialog, DB_SETTINGS, DbRefactoringHelper.getPlace(place));
        if (genericEditingResultProcessor == null) {
            DbRefactoringHelper.$$$reportNull$$$0(6);
        }
        return genericEditingResultProcessor;
    }

    @Nullable
    public static RangeMarker getPlace(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile file = element2.getContainingFile();
        if (file == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)element2.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        int offset = element2.getTextRange().getStartOffset();
        return document.createRangeMarker(offset, offset);
    }

    public static boolean isTableOrEditableTableChild(@NotNull DasObject o, @NotNull DatabaseEditorContext context) {
        if (o == null) {
            DbRefactoringHelper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DbRefactoringHelper.$$$reportNull$$$0(8);
        }
        DasObject p2 = o.getDasParent();
        return DbRefactoringHelper.isEditable(o, context) && ourEditable.contains(o.getKind()) && (o instanceof DasTable || o instanceof DasTableChild && p2 != null && DbRefactoringHelper.isTableOrEditableTableChild(p2, context));
    }

    public static boolean isEditable(@NotNull DasObject o, @NotNull DatabaseEditorContext context) {
        DasObject object;
        if (o == null) {
            DbRefactoringHelper.$$$reportNull$$$0(9);
        }
        if (context == null) {
            DbRefactoringHelper.$$$reportNull$$$0(10);
        }
        return (object = (DasObject)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(o), DasObject.class)) != null && context.getDialect().getSchemaEditor().canExport(object);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbRefactoringHelper";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbRefactoringHelper";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isForceCreate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResultProcessor";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTableOrEditableTableChild";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ObjectLocation {
        DATABASE("Database"),
        CODE("Code");

        private final String myTitle;

        private ObjectLocation(String title) {
            if (title == null) {
                ObjectLocation.$$$reportNull$$$0(0);
            }
            this.myTitle = title;
        }

        @Nullable
        public static ObjectLocation of(@Nullable DasObject obj, @Nullable DbDataSource dataSource) {
            if (ObjectLocation.getSql(obj, dataSource) != null) {
                return CODE;
            }
            if (ObjectLocation.getDb(obj) != null) {
                return DATABASE;
            }
            return null;
        }

        @Nullable
        public static SqlElement getSql(@Nullable DasObject obj, @Nullable DbDataSource dataSource) {
            if (obj instanceof DbElement) {
                return DbSqlUtil.getSqlElement((DbElement)obj);
            }
            if (obj instanceof BasicElement) {
                return DbSqlUtil.getSqlElement(dataSource, obj);
            }
            if (obj instanceof SqlElement) {
                return (SqlElement)obj;
            }
            return null;
        }

        @Nullable
        public static SqlElement getSql(@Nullable DasObject obj, @NotNull DatabaseEditorContext context) {
            if (context == null) {
                ObjectLocation.$$$reportNull$$$0(1);
            }
            return GenericEditingResultProcessor.getSqlElement(obj, context);
        }

        @Nullable
        public static DbElement getDb(@Nullable DasObject obj) {
            return (DbElement)ObjectUtils.tryCast((Object)obj, DbElement.class);
        }

        @NotNull
        public String toString() {
            String string = this.myTitle;
            if (string == null) {
                ObjectLocation.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DbRefactoringHelper$ObjectLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DbRefactoringHelper$ObjectLocation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSql";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

