/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeModel
implements DasModel {
    public static final DeModel STUB = new DeModel(null, null);
    private final DasModel myModel;
    private final SchemaExportHelper myHelper;
    private final Set<DeObject> myRoots = ContainerUtil.newLinkedHashSet();

    public DeModel(@Nullable DasModel model, @Nullable SchemaExportHelper helper) {
        this.myModel = model;
        this.myHelper = helper;
    }

    @NotNull
    public MetaModel getMetaModel() {
        MetaModel metaModel = this.myModel == null ? MetaModel.EMPTY : this.myModel.getMetaModel();
        if (metaModel == null) {
            DeModel.$$$reportNull$$$0(0);
        }
        return metaModel;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.myRoots);
        if (jBIterable == null) {
            DeModel.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        throw new AssertionError((Object)"todo");
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            DeModel.$$$reportNull$$$0(2);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        if (this.myModel == null || this.myModel == DasUtil.emptyModel() || this.myHelper == null) {
            JBIterable jBIterable = this.traverser().filter(DasForeignKey.class).filter(key2 -> key2.getRefTable() == table);
            if (jBIterable == null) {
                DeModel.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        DeTable deTable = (DeTable)ObjectUtils.tryCast((Object)table, DeTable.class);
        if (deTable == null || deTable.getEditedObject() == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DeModel.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.myModel.getExportedKeys((DasTable)deTable.getEditedObject()).filter(constraint -> this.myHelper.canExport((DasObject)constraint)).transform(constraint -> {
            this.myHelper.export((DasObject)constraint.getTable(), true);
            return (DasConstraint)this.myHelper.export((DasObject)constraint, true);
        });
        if (jBIterable == null) {
            DeModel.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            DeModel.$$$reportNull$$$0(6);
        }
        Casing casing = this.myModel == null ? DasUtil.CASING_EXACT : this.myModel.getCasing(kind, context);
        if (casing == null) {
            DeModel.$$$reportNull$$$0(7);
        }
        return casing;
    }

    @NotNull
    public DeModel addRoot(@NotNull DeObject obj) {
        if (obj == null) {
            DeModel.$$$reportNull$$$0(8);
        }
        this.myRoots.add(obj);
        DeModel deModel = this;
        if (deModel == null) {
            DeModel.$$$reportNull$$$0(9);
        }
        return deModel;
    }

    public void removeRoot(@NotNull DeObject obj) {
        if (obj == null) {
            DeModel.$$$reportNull$$$0(10);
        }
        this.myRoots.remove(obj);
    }

    public DasModel getModel() {
        return this.myModel;
    }

    public SchemaExportHelper getExportHelper() {
        return this.myHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

