/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServersConfigurable;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.run.PhpCommandLineSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRunUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.run.PhpRunUtil");

    private PhpRunUtil() {
    }

    public static boolean isGeneratedName(@NotNull LocatableConfiguration configuration) {
        if (configuration == null) {
            PhpRunUtil.$$$reportNull$$$0(0);
        }
        return Comparing.equal((String)configuration.getName(), (String)configuration.suggestedName());
    }

    @NotNull
    public static PhpServer checkServerConfigurationByServerName(@NotNull Project project, @Nullable String serverName) throws RuntimeConfigurationException {
        if (project == null) {
            PhpRunUtil.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("RunConfigurationEditor.error.server.is.not.selected", new Object[0]));
        }
        PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName);
        if (server == null) {
            Runnable quickfix = () -> {
                if (project == null) {
                    PhpRunUtil.$$$reportNull$$$0(11);
                }
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PhpServersConfigurable(project));
            };
            throw new RuntimeConfigurationError(PhpBundle.message("RunConfigurationEditor.error.server.is.not.exist", serverName), quickfix);
        }
        server.checkConfiguration(project);
        PhpServer phpServer = server;
        if (phpServer == null) {
            PhpRunUtil.$$$reportNull$$$0(2);
        }
        return phpServer;
    }

    public static void checkCommandLineSettings(@NotNull Project project, @NotNull PhpCommandLineSettings commandLineSettings) throws RuntimeConfigurationError {
        String workingDirectory;
        if (project == null) {
            PhpRunUtil.$$$reportNull$$$0(3);
        }
        if (commandLineSettings == null) {
            PhpRunUtil.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(workingDirectory = commandLineSettings.getWorkingDirectory())) && !PhpRunUtil.isValidDirectoryPath(workingDirectory)) {
            throw new RuntimeConfigurationError(PhpBundle.message("working.directory.invalid", workingDirectory));
        }
        String error = PhpCommandSettingsBuilder.validate(project);
        if (StringUtil.isNotEmpty((String)error)) {
            LOG.debug(error);
            String message = error + " " + PhpBundle.message("validation.press.fix.to.edit.project.configuration", new Object[0]);
            throw new RuntimeConfigurationError(message, PhpProjectConfigurable.createFix(project));
        }
    }

    public static void attachProcessOutputDebugDumper(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            PhpRunUtil.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled()) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Output: " + event.getText().trim());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/run/PhpRunUtil$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    public static PsiFile findPsiFile(@NotNull Project project, @Nullable String path, boolean refresh) {
        VirtualFile file;
        if (project == null) {
            PhpRunUtil.$$$reportNull$$$0(6);
        }
        if ((file = PhpRunUtil.findFile(path, refresh)) != null) {
            return PsiManager.getInstance((Project)project).findFile(file);
        }
        return null;
    }

    @Nullable
    public static PsiFile findPsiFile(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            PhpRunUtil.$$$reportNull$$$0(7);
        }
        return PhpRunUtil.findPsiFile(project, path, false);
    }

    @Nullable
    public static VirtualFile findFile(@Nullable String path, boolean refresh) {
        VirtualFile file;
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        VirtualFile virtualFile = file = refresh ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null || file.isDirectory()) {
            return null;
        }
        return file;
    }

    @Nullable
    public static VirtualFile findFile(@Nullable String path) {
        return PhpRunUtil.findFile(path, false);
    }

    public static VirtualFile findFileOrDirectory(@Nullable String path, boolean refresh) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        return refresh ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : LocalFileSystem.getInstance().findFileByPath(path);
    }

    public static boolean isValidFilePath(@Nullable String path, boolean refresh) {
        return path != null && PhpRunUtil.findFile(path, refresh) != null;
    }

    public static boolean isValidFilePath(@Nullable String path) {
        return PhpRunUtil.isValidFilePath(path, false);
    }

    public static boolean isValidFileOrDirectoryPath(@Nullable String path) {
        return path != null && PhpRunUtil.findFileOrDirectory(path, false) != null;
    }

    @Nullable
    public static VirtualFile findDirectory(@Nullable String path) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        return dir;
    }

    public static boolean isValidDirectoryPath(@Nullable String path) {
        return path != null && PhpRunUtil.findDirectory(path) != null;
    }

    public static boolean isFilePathEquals(@Nullable String filePath1, @Nullable String filePath2) {
        if (filePath1 == null || filePath2 == null) {
            return false;
        }
        return FileUtil.pathsEqual((String)PhpRunUtil.normalizePath(filePath1), (String)PhpRunUtil.normalizePath(filePath2));
    }

    private static String normalizePath(@NotNull String filePath) {
        if (filePath == null) {
            PhpRunUtil.$$$reportNull$$$0(8);
        }
        return StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)VirtualFileManager.extractPath((String)filePath)), (String)"/");
    }

    public static boolean isPhpScratch(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PhpRunUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PhpRunUtil.$$$reportNull$$$0(10);
        }
        return ScratchUtil.isScratch((VirtualFile)file) && LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) == PhpLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/PhpRunUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/PhpRunUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkServerConfigurationByServerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkServerConfigurationByServerName";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkCommandLineSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachProcessOutputDebugDumper";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPsiFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPhpScratch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkServerConfigurationByServerName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

