/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddPropertyQuickFix
extends PhpQuickFixBase {
    @NotNull
    public String getName() {
        if ("Add @property" == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(0);
        }
        return "Add @property";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference reference;
        if (project == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(3);
        }
        if ((reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), MemberReference.class, (boolean)false)) == null) {
            return;
        }
        PhpClass klass = PhpAddPropertyQuickFix.resolveClass(reference, true);
        PhpAddPropertyQuickFix.doFix(project, reference, klass);
    }

    public static void doFix(Project project, @NotNull MemberReference reference, PhpClass klass) {
        if (reference == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(4);
        }
        if (klass != null) {
            PhpDocComment comment = klass.getDocComment();
            PsiElement inserted = null;
            PsiElement toReformat = null;
            if (comment == null) {
                comment = PhpPsiElementFactory.createFromText(klass.getProject(), PhpDocComment.class, "/**\n* @property " + PhpAddPropertyQuickFix.getRefType(project, reference) + " " + reference.getName() + "\n*/ class c { }");
                if (comment != null) {
                    toReformat = inserted = klass.addBefore((PsiElement)comment, klass.getFirstChild());
                }
            } else {
                List propTags = comment.getPropertyTags();
                PhpDocTag property = PhpPsiElementFactory.createFromText(klass.getProject(), PhpDocTag.class, "/**\n*@property " + PhpAddPropertyQuickFix.getRefType(project, reference) + " " + reference.getName() + "\n*/ class c { }");
                assert (property != null);
                PsiElement asterisk = property.getPrevSibling();
                assert (asterisk != null);
                if (propTags.size() == 0) {
                    PsiElement anchor = PhpAddPropertyQuickFix.findFirstDocTag(comment);
                    if (anchor != null) {
                        if ((anchor = anchor.getPrevSibling()) instanceof PsiWhiteSpace) {
                            anchor = anchor.getPrevSibling();
                        }
                    } else {
                        anchor = comment.getLastChild();
                    }
                    inserted = comment.addBefore((PsiElement)property, anchor);
                    comment.addBefore(asterisk, inserted);
                } else {
                    PsiElement lastTag = (PsiElement)propTags.get(propTags.size() - 1);
                    PsiElement newAsterisk = comment.addAfter(asterisk, lastTag);
                    inserted = comment.addAfter((PsiElement)property, newAsterisk);
                }
                toReformat = comment;
            }
            if (inserted != null) {
                PhpCodeUtil.openRelatedFile(project, inserted);
                PhpAddPropertyQuickFix.reformat(toReformat);
            }
        }
    }

    @NotNull
    private static String getRefType(@NotNull Project project, @NotNull MemberReference ref) {
        if (project == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(6);
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)ref);
        String string = PhpDocUtil.getTypePresentation(project, ref.getType(), scope);
        if (string == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static PsiElement findFirstDocTag(PhpDocComment comment) {
        PsiElement child = comment.getFirstChild();
        if (child == null) {
            return null;
        }
        for (ASTNode childNode = child.getNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (childNode.getElementType() != PhpDocElementTypes.phpDocTag) continue;
            return childNode.getPsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddPropertyQuickFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddPropertyQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRefType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

