/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.PhpClassAliasDocSource;
import com.jetbrains.php.lang.documentation.PhpClassDocSource;
import com.jetbrains.php.lang.documentation.PhpClassMemberDocSource;
import com.jetbrains.php.lang.documentation.PhpClassRefDocSource;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.PhpDocMethodSource;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpFileDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.PhpNamespaceDocSource;
import com.jetbrains.php.lang.documentation.PhpParameterDocSource;
import com.jetbrains.php.lang.documentation.PhpPropertyDocSource;
import com.jetbrains.php.lang.documentation.PhpVarDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLinkTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocumentationProvider
extends DocumentationProviderEx {
    private static final Logger LOG = Logger.getInstance(PhpDocumentationProvider.class);

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        PhpDocSource source = PhpDocumentationProvider.getDocSourceFor(element, originalElement);
        if (source == null) {
            return null;
        }
        StringBuilder infoBuf = new StringBuilder();
        infoBuf.append(source.getTitle());
        String returnType = source.getReturnType();
        if (returnType != null && returnType.length() > 0) {
            infoBuf.append(" : ").append(returnType);
        }
        return infoBuf.toString();
    }

    @Nullable
    private static String getText(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(1);
        }
        StringBuilder buffer = new StringBuilder();
        PhpReference ref = (PhpReference)PhpPsiUtil.getParentByCondition(originalElement, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        try {
            String sourceLoc;
            PsiFile psiFile;
            String packageName;
            String content;
            PhpDocSource source = PhpDocumentationProvider.getDocSourceFor(element, originalElement);
            if (source == null) {
                return null;
            }
            buffer.append("<div class='definition'><pre>").append("<b>").append(source.getTitle()).append("</b>");
            String returnType = source.getReturnType();
            if (returnType != null && returnType.length() > 0) {
                buffer.append(" ").append(returnType);
            } else if (ref != null) {
                buffer.append(" <i>").append(ref.getType().globalLocationAware(originalElement)).append("</i>");
            }
            buffer.append("</pre></div>");
            String description = source.getDescription();
            if (StringUtil.isNotEmpty((String)description)) {
                buffer.append("<div class='content'>").append(description).append("</div>");
            }
            buffer.append("<table class='sections'>");
            if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode() && ref != null) {
                PhpDocumentationProvider.addSection(buffer, "Signature:", ref.getSignature());
            }
            if (source.isDeprecated()) {
                content = source.getDeprecationInfo();
                if (StringUtil.isEmpty((String)content)) {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Deprecated</b></u>");
                } else {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Deprecated</b></u>:", content);
                }
            }
            if (source.isInternal()) {
                content = source.getInternalInfo();
                if (StringUtil.isEmpty((String)content)) {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Internal</b></u>");
                } else {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Internal</b></u>:", content);
                }
            }
            PhpDocumentationProvider.addSection(buffer, "Parameters:", source.getParameters());
            PhpDocumentationProvider.addSection(buffer, "Returns:", source.getReturnDescription());
            PhpDocumentationProvider.addSection(buffer, "Throws:", source.getThrows());
            PhpDocumentationProvider.addSection(buffer, "Declared&nbsp;in:", source.getDeclaredIn());
            String namespace = source.getNamespace();
            if (namespace != null && namespace.length() > 0 && !namespace.equals("\\")) {
                PhpDocumentationProvider.addSection(buffer, "Namespace:", namespace);
            }
            if ((packageName = source.getPackage()) != null) {
                String subpackage = source.getSubpackage();
                PhpDocumentationProvider.addSection(buffer, "Package:", source.getPackage() + (subpackage == null ? "" : "/" + subpackage));
            }
            PhpDocumentationProvider.addSection(buffer, "Version:", source.getVersion());
            PhpDocumentationProvider.addSection(buffer, "Uses:", source.getUses());
            PhpDocumentationProvider.addSection(buffer, "Since:", source.getSince());
            PhpDocumentationProvider.addSection(buffer, "Links:", source.getLinks());
            PhpDocumentationProvider.addSection(buffer, "See also:", source.getSeeItems());
            if (element instanceof NavigationItem && (psiFile = element.getContainingFile()) != null && !".../".equals(sourceLoc = PhpPresentationUtil.getPresentablePathForFile(psiFile.getVirtualFile(), element.getProject()))) {
                PhpDocumentationProvider.addSection(buffer, "Source:", "<span path=\"\">" + sourceLoc + "</span>");
            }
            buffer.append("</table>");
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(element.getText(), e);
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Nullable
    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PhpPsiElement) || !element.isValid()) {
            return null;
        }
        return PhpDocumentationProvider.getText(element, originalElement == null ? element : originalElement);
    }

    public List<String> getUrlFor(PsiElement element, @Nullable PsiElement originalElement) {
        ArrayList<String> urls = new ArrayList<String>();
        PhpDocumentationProvider.addDocUrls(element, urls);
        if (urls.isEmpty()) {
            String name;
            String string = element instanceof PhpNamedElement ? ((PhpNamedElement)element).getName() : (name = element instanceof PhpReference ? ((PhpReference)element).getName() : null);
            if (name != null) {
                urls.add("http://www.php.net/manual-lookup.php?pattern=" + name + "&amp;lang=en");
            }
        }
        return urls;
    }

    public static void addDocUrls(PsiElement element, ArrayList<? super String> urls) {
        PhpDocLinkTag[] tags;
        PhpDocComment comment = (PhpDocComment)ObjectUtils.doIfCast((Object)element, PhpNamedElement.class, PhpNamedElement::getDocComment);
        if (comment != null && (tags = comment.getLinkTags()) != null) {
            for (PhpDocLinkTag linkTag : tags) {
                String url = linkTag.getURL();
                if (url == null) continue;
                urls.add(url);
            }
        }
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return PhpDocLinkResolver.resolve(link, context).stream().map(PhpDocLinkResolver.Result::getElement).findAny().orElse(null);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        PsiElement resolve;
        PhpReference ref;
        if (editor == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(4);
        }
        if ((ref = (PhpReference)PhpPsiUtil.getParentByCondition(contextElement, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && (resolve = ref.resolve()) != null) {
            return resolve;
        }
        return super.getCustomDocumentationElement(editor, file, contextElement);
    }

    @Nullable
    private static PhpDocSource getDocSourceFor(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof PhpFile) {
            return new PhpFileDocSource((PhpFile)element);
        }
        if (element instanceof PhpNamespace) {
            return new PhpNamespaceDocSource((PhpNamespace)element);
        }
        if (element instanceof Parameter) {
            return new PhpParameterDocSource((Parameter)element);
        }
        if (element instanceof PhpDocProperty) {
            return new PhpPropertyDocSource((PhpDocProperty)element);
        }
        if (element instanceof PhpDocMethod) {
            return new PhpDocMethodSource((PhpDocMethod)element);
        }
        if (element instanceof PhpClassMember) {
            return new PhpClassMemberDocSource((PhpClassMember)element);
        }
        if (element instanceof Function) {
            return new PhpFunctionDocSource((Function)element);
        }
        if (element instanceof PhpClassAlias) {
            return new PhpClassAliasDocSource((PhpClassAlias)element);
        }
        if (element instanceof PhpClass) {
            return new PhpClassDocSource((PhpClass)element);
        }
        if (element instanceof ClassReference) {
            return new PhpClassRefDocSource((ClassReference)element);
        }
        if (element instanceof PhpNamedElement) {
            Variable var = PhpVarDocSource.getVariable(originalElement);
            if (var != null) {
                return new PhpVarDocSource((PhpNamedElement)element, var);
            }
            return new PhpNamedElementDocSource((PhpNamedElement)element);
        }
        if (element instanceof PhpPsiElement) {
            return new PhpDefaultDocSource((PhpPsiElement)element);
        }
        return null;
    }

    private static void addSection(@NotNull StringBuilder buffer, @NotNull String name, @Nullable String content) {
        if (buffer == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (StringUtil.isNotEmpty((String)content)) {
            buffer.append("<tr><td valign='top' class='section'><p>");
            buffer.append(name);
            buffer.append("</td><td valign='top'>");
            buffer.append(content);
            buffer.append("</td>");
        }
    }

    private static void addSection(@NotNull StringBuilder buffer, @NotNull String name) {
        if (buffer == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (name == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(10);
        }
        buffer.append("<tr><td valign='top' class='section'><p>");
        buffer.append(name);
        buffer.append("</td><td valign='top'>");
        buffer.append("</td>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateDoc";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomDocumentationElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocSourceFor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addSection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

