/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.internal;

import com.intellij.internal.psiView.PsiViewerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpControlFlowViewerDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PhpControlFlowViewerDialog.class);
    private static final int DIVIDER_LOCATION = 650;
    private JPanel myMainPanel;
    private JPanel myTextPanel;
    private JEditorPane myControlFlowPanel;
    private JSplitPane myTextDivider;
    private final Project myProject;
    private final EditorEx myEditor;

    protected PhpControlFlowViewerDialog(@Nullable Project project, @Nullable Editor selectedEditor) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setOKButtonText("&Build Control Flow");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle(selectedFile == null ? "PHP Control Flow Viewer" : "PHP Control Flow Viewer: " + selectedFile.getName());
        if (selectedEditor != null) {
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
        } else {
            PsiViewerSettings settings = PsiViewerSettings.getSettings();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)settings.text));
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
            this.myEditor.getSelectionModel().setSelection(0, document.getTextLength());
        }
        this.myEditor.getSettings().setLineMarkerAreaShown(false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true));
                this.myEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }, ModalityState.stateForComponent((Component)this.myMainPanel));
        }
    }

    protected void init() {
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        this.getPeer().getWindow().setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getInitialComponent(@NotNull Window window) {
                if (window == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpControlFlowViewerDialog.this.myEditor.getComponent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/jetbrains/php/internal/PhpControlFlowViewerDialog$1", "getInitialComponent"));
            }
        });
        this.myControlFlowPanel.setEditable(false);
        this.updateEditor();
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), this.myProject);
        if (size == null) {
            DimensionService.getInstance().setSize(this.getDimensionServiceKey(), (Dimension)JBUI.size((int)800, (int)600));
        }
        this.myTextDivider.setDividerLocation(650);
        super.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = PhpControlFlowViewerDialog.class.getCanonicalName();
        if (string == null) {
            PhpControlFlowViewerDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void updateEditor() {
        PhpFileType fileType = PhpFileType.INSTANCE;
        String fileName = "Dummy.php";
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.php", (FileType)fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)lightFile);
        try {
            this.myEditor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    protected void doOKAction() {
        this.myEditor.getSelectionModel().removeSelection();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)this.myEditor.getDocument());
        if (!(file instanceof PhpFile)) {
            return;
        }
        final StringBuilder actualResultBuilder = new StringBuilder();
        file.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFile(PhpFile PhpFile2) {
                this.visitPhpElement((PhpPsiElement)PhpFile2);
            }

            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpScopeHolder) {
                    PhpControlFlow controlFlow = new PhpControlFlowBuilder((PhpScopeHolder)element).build();
                    actualResultBuilder.append(controlFlow);
                    actualResultBuilder.append("---------\n");
                }
                super.visitPhpElement(element);
            }
        });
        this.myControlFlowPanel.setText(actualResultBuilder.toString().trim());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    public void dispose() {
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/internal/PhpControlFlowViewerDialog", "getDimensionServiceKey"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTextDivider = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setDividerSize(2);
        jPanel2.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane);
        this.myTextPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jSplitPane.setRightComponent((Component)jBScrollPane2);
        this.myControlFlowPanel = jEditorPane = new JEditorPane();
        jBScrollPane2.setViewportView(jEditorPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

