/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.dataFlow.type;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTypeConditionDFAnalyzer<E>
extends PhpConditionDFAnalyzer<E> {
    private static final Map<String, PhpType> myPrimitiveTypeCheckerFunctions = new HashMap();

    @NotNull
    public static PhpType add(PhpType type, @Nullable PsiElement other, boolean filterPrimitives) {
        if (other instanceof PhpTypedElement) {
            PhpType otherType = ((PhpTypedElement)other).getType();
            type.add(filterPrimitives ? otherType.filterPrimitives() : otherType);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @Override
    @NotNull
    public E performDFA(@Nullable PsiElement condition, boolean result) {
        PsiElement parameter;
        E eval;
        PsiElement[] parameters;
        PhpType phpType;
        FunctionReference functionReference;
        String functionName;
        if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType type = binaryExpression.getOperationType();
            if (type == PhpTokenTypes.kwINSTANCEOF || type == PhpTokenTypes.opIDENTICAL) {
                boolean filterPrimitives;
                PsiElement leftOperand;
                E eval2;
                PsiElement rightOperand;
                if (result && (rightOperand = binaryExpression.getRightOperand()) instanceof PhpTypedElement && (eval2 = this.tryEvaluate(leftOperand = binaryExpression.getLeftOperand(), rightOperand, filterPrimitives = type == PhpTokenTypes.kwINSTANCEOF)) != null) {
                    E e = eval2;
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return e;
                }
            } else if (PhpTokenTypes.tsAND_OPS.contains(type) || PhpTokenTypes.tsOR_OPS.contains(type)) {
                E left = this.performDFA(binaryExpression.getLeftOperand(), result);
                E right = this.performDFA(binaryExpression.getRightOperand(), result);
                E e = this.and(left, right);
                if (e == null) {
                    PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(2);
                }
                return e;
            }
        } else if (!(condition instanceof MethodReference) && condition instanceof FunctionReference && StringUtil.isNotEmpty((String)(functionName = (functionReference = (FunctionReference)condition).getName())) && (phpType = myPrimitiveTypeCheckerFunctions.get(functionName.toLowerCase())) != null && result && (parameters = functionReference.getParameters()).length > 0 && (eval = this.tryEvaluate(parameter = parameters[0], phpType)) != null) {
            E e = eval;
            if (e == null) {
                PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(3);
            }
            return e;
        }
        Object e = super.performDFA(condition, result);
        if (e == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(4);
        }
        return e;
    }

    @Nullable
    public abstract E tryEvaluate(@Nullable PsiElement var1, @NotNull PsiElement var2, boolean var3);

    @Nullable
    public abstract E tryEvaluate(@Nullable PsiElement var1, @NotNull PhpType var2);

    static {
        myPrimitiveTypeCheckerFunctions.put("is_array", PhpType.ARRAY);
        myPrimitiveTypeCheckerFunctions.put("is_bool", PhpType.BOOLEAN);
        myPrimitiveTypeCheckerFunctions.put("is_callable", PhpType.CALLABLE);
        myPrimitiveTypeCheckerFunctions.put("is_double", PhpType.FLOAT);
        myPrimitiveTypeCheckerFunctions.put("is_float", PhpType.FLOAT);
        myPrimitiveTypeCheckerFunctions.put("is_int", PhpType.INT);
        myPrimitiveTypeCheckerFunctions.put("is_integer", PhpType.INT);
        myPrimitiveTypeCheckerFunctions.put("is_long", PhpType.INT);
        myPrimitiveTypeCheckerFunctions.put("is_numeric", PhpType.NUMERIC);
        myPrimitiveTypeCheckerFunctions.put("is_real", PhpType.FLOAT);
        myPrimitiveTypeCheckerFunctions.put("is_resource", PhpType.RESOURCE);
        myPrimitiveTypeCheckerFunctions.put("is_scalar", PhpType.SCALAR);
        myPrimitiveTypeCheckerFunctions.put("is_string", PhpType.STRING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

