/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.ControlFlowException;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpControlFlowUtil {
    private static final AppendPredecessorsStrategy ALL_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber) -> {
        List predecessors = (List)instruction.getPredecessors();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            pool.add(predecessor);
        }
    };
    private static final AppendPredecessorsStrategy IGNORE_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber) -> {
        List predecessors = (List)instruction.getPredecessors();
        int num = instruction.num();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            if (num <= predecessor.num()) continue;
            pool.add(predecessor);
        }
    };
    private static final AppendPredecessorsStrategy IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber) -> {
        List predecessors = (List)instruction.getPredecessors();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            if (initialNumber <= predecessor.num()) continue;
            pool.add(predecessor);
        }
    };

    private PhpControlFlowUtil() {
    }

    public static void processSuccessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(1);
        }
        BitSet visited = new BitSet();
        ArrayDeque<PhpInstruction> processorPool = new ArrayDeque<PhpInstruction>();
        if (visitSelf) {
            processorPool.add(instruction);
        } else {
            instruction.appendSuccessors(processorPool);
        }
        int c = 0;
        while (processorPool.size() > 0) {
            PhpInstruction curInstruction = (PhpInstruction)processorPool.getFirst();
            if (!visited.get(curInstruction.num())) {
                visited.set(curInstruction.num());
                if (curInstruction.process(processor)) {
                    curInstruction.appendSuccessors(processorPool);
                }
            }
            processorPool.removeFirst();
            ProgressManager.checkCanceled();
            if (c++ <= 20000) continue;
            throw new ControlFlowException("Control flow (Successors) is too big. Initial instruction=" + instruction + " Last instruction=" + curInstruction);
        }
    }

    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(3);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, ALL_APPEND_PREDECESSOR_STRATEGY, processor);
    }

    public static void processPredecessorsIgnoreBackEdges(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(5);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, IGNORE_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY, processor);
    }

    public static void processPredecessorsIgnoreInitialBackEdges(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(7);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY, processor);
    }

    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull AppendPredecessorsStrategy appendPredecessorsStrategy, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(8);
        }
        if (appendPredecessorsStrategy == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(10);
        }
        int initialNumber = instruction.num();
        BitSet visited = new BitSet(initialNumber);
        ArrayDeque<PhpInstruction> processorPool = new ArrayDeque<PhpInstruction>(50);
        if (visitSelf) {
            processorPool.add(instruction);
        } else {
            appendPredecessorsStrategy.appendPredecessors(instruction, processorPool, initialNumber);
        }
        int c = 0;
        while (processorPool.size() > 0) {
            PhpInstruction curInstruction = (PhpInstruction)processorPool.getFirst();
            if (!visited.get(curInstruction.num())) {
                visited.set(curInstruction.num());
                if (curInstruction.process(processor)) {
                    appendPredecessorsStrategy.appendPredecessors(curInstruction, processorPool, initialNumber);
                }
            }
            processorPool.removeFirst();
            ProgressManager.checkCanceled();
            if (c++ <= 20000) continue;
            throw new ControlFlowException("Control flow (Predecessors) is too big. Initial instruction=" + instruction + " Last instruction=" + curInstruction);
        }
    }

    public static int processFlow(@NotNull PhpControlFlow controlFlow, @NotNull PhpInstructionProcessor processor) {
        int i;
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(12);
        }
        PhpInstruction[] instructions = controlFlow.getInstructions();
        for (i = 0; i < instructions.length && instructions[i].process(processor); ++i) {
        }
        return i;
    }

    @Nullable
    public static <T extends PhpAccessInstruction> T getAccessInstruction(@NotNull PhpPsiElement anchor, @NotNull Class<T> instructionClass) {
        if (anchor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(13);
        }
        if (instructionClass == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(14);
        }
        return PhpControlFlowUtil.getAccessInstructionInScopeHolder(PhpPsiUtil.getScopeHolder((PsiElement)anchor), anchor, instructionClass);
    }

    @Nullable
    public static <T extends PhpAccessInstruction> T getAccessInstructionInScopeHolder(@Nullable PhpScopeHolder scopeHolder, @NotNull PhpPsiElement anchor, @NotNull Class<T> instructionClass) {
        if (anchor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(15);
        }
        if (instructionClass == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (scopeHolder == null) {
            return null;
        }
        PhpControlFlow flow = scopeHolder.getControlFlow();
        return (T)flow.getInstruction(anchor, instructionClass);
    }

    @Nullable
    public static PhpCallInstruction getCallInstruction(@NotNull FunctionReference functionReference) {
        PhpInstruction[] instructions;
        PhpScopeHolder scopeHolder;
        if (functionReference == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(17);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)functionReference)) == null) {
            return null;
        }
        for (PhpInstruction instruction : instructions = scopeHolder.getControlFlow().getInstructions()) {
            if (!(instruction instanceof PhpCallInstruction) || functionReference != ((PhpCallInstruction)instruction).getFunctionReference()) continue;
            return (PhpCallInstruction)instruction;
        }
        return null;
    }

    @Nullable
    public static PhpStatementInstruction getStatementInstruction(@NotNull PhpControlFlow controlFlow, final @NotNull Statement statement) {
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(18);
        }
        if (statement == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(19);
        }
        PhpInstruction[] instructions = controlFlow.getInstructions();
        int i = PhpControlFlowUtil.processFlow(controlFlow, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                return instruction.getStatement() != statement;
            }
        });
        return i == 0 || i == instructions.length ? null : (PhpStatementInstruction)instructions[i];
    }

    public static void processPreviousVariableAccesses(@NotNull PhpAccessVariableInstruction point, boolean processSelf, @NotNull PhpInstructionProcessor processor) {
        if (point == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(21);
        }
        PhpControlFlowUtil.processPredecessors((PhpInstruction)point, processSelf, new MyVariableInstructionProcessor(point.getVariableName(), processor));
    }

    @NotNull
    public static PhpAccessVariableInstruction[] getFollowingVariableAccessInstructions(@NotNull PhpInstruction point, final @NotNull CharSequence variableName, final boolean successorsOnly) {
        if (point == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(22);
        }
        if (variableName == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(23);
        }
        final ArrayList followingAccesses = new ArrayList();
        PhpControlFlowUtil.processSuccessors(point, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    followingAccesses.add(instruction);
                    return !successorsOnly;
                }
                return true;
            }
        });
        if (followingAccesses.size() == 0) {
            if (PhpAccessVariableInstruction.EMPTY_ARRAY == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(24);
            }
            return PhpAccessVariableInstruction.EMPTY_ARRAY;
        }
        PhpAccessVariableInstruction[] phpAccessVariableInstructionArray = followingAccesses.toArray(PhpAccessVariableInstruction.EMPTY_ARRAY);
        if (phpAccessVariableInstructionArray == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(25);
        }
        return phpAccessVariableInstructionArray;
    }

    public static boolean isPredecessor(@NotNull PhpInstruction instruction, final @NotNull PhpInstruction candidate) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(26);
        }
        if (candidate == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(27);
        }
        final Ref isReachedRef = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction curInstruction) {
                if (curInstruction == candidate) {
                    isReachedRef.set((Object)true);
                }
                return (Boolean)isReachedRef.get() == false;
            }
        });
        return (Boolean)isReachedRef.get();
    }

    public static boolean isReferenced(@NotNull PhpScopeHolder scopeHolder, @NotNull PhpAccessVariableInstruction accessInstruction) {
        PhpPsiElement anchor;
        if (scopeHolder == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(28);
        }
        if (accessInstruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(29);
        }
        if ((anchor = accessInstruction.getAnchor()) instanceof Variable) {
            Variable accessedVariable = (Variable)anchor;
            if (!accessedVariable.canReadName()) {
                return false;
            }
            final String accessedVariableName = accessedVariable.getName();
            if (scopeHolder instanceof Function) {
                PsiElement resolvedElement;
                Variable[] variables;
                PhpUseList useList;
                Function function = (Function)scopeHolder;
                if (function.isClosure() && (useList = (PhpUseList)PsiTreeUtil.findChildOfType((PsiElement)function, PhpUseList.class)) != null && (variables = (Variable[])PsiTreeUtil.getChildrenOfType((PsiElement)useList, Variable.class)) != null) {
                    for (Variable variable : variables) {
                        if (!PhpLangUtil.equalsVariableNames(variable.getName(), accessedVariableName) || !PhpWorkaroundUtil.isReadReference((PsiElement)variable)) continue;
                        return true;
                    }
                }
                if ((resolvedElement = (PsiElement)accessedVariable.resolveLocal().stream().findFirst().orElse(null)) instanceof Parameter) {
                    return ((Parameter)resolvedElement).isPassByRef();
                }
            }
            final Ref isReferenced = new Ref((Object)false);
            PhpControlFlowUtil.processPredecessors((PhpInstruction)accessInstruction, true, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(@NotNull PhpAccessVariableInstruction instruction) {
                    if (instruction == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (PhpLangUtil.equalsVariableNames(accessedVariableName, instruction.getVariableName()) && instruction.getAccess().isWriteRef()) {
                        isReferenced.set((Object)true);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$4", "processAccessVariableInstruction"));
                }
            });
            return (Boolean)isReferenced.get();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendPredecessorsStrategy";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFollowingVariableAccessInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processSuccessors";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessorsIgnoreBackEdges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessorsIgnoreInitialBackEdges";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processFlow";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAccessInstruction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAccessInstructionInScopeHolder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCallInstruction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStatementInstruction";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processPreviousVariableAccesses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingVariableAccessInstructions";
                break;
            }
            case 24: 
            case 25: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isPredecessor";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVariableInstructionProcessor
    extends PhpInstructionProcessor {
        private final PhpInstructionProcessor myProcessor;
        private final CharSequence myVariableName;

        MyVariableInstructionProcessor(@NotNull CharSequence variableName, PhpInstructionProcessor processor) {
            if (variableName == null) {
                MyVariableInstructionProcessor.$$$reportNull$$$0(0);
            }
            this.myVariableName = variableName;
            this.myProcessor = processor;
        }

        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
            if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName())) {
                return this.myProcessor.processAccessVariableInstruction(instruction);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$MyVariableInstructionProcessor", "<init>"));
        }
    }

    @FunctionalInterface
    private static interface AppendPredecessorsStrategy {
        public void appendPredecessors(@NotNull PhpInstruction var1, @NotNull Collection<PhpInstruction> var2, int var3);
    }
}

