/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.util.IOUtils;

public class HistoryReader
extends Reader {
    private final List<HistoryEntry> entries;
    private Reader input;

    HistoryReader(History history) {
        this.entries = history.getHistoryEntries();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.input == null) {
            this.input = this.createInternalReader();
        }
        return this.input.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.input);
    }

    private Reader createInternalReader() {
        StringBuilder str = new StringBuilder();
        for (HistoryEntry entry : this.entries) {
            str.append(entry.getLine());
        }
        return new StringReader(str.toString());
    }
}

