/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.web.Util;

public abstract class JFlexXref {
    public Writer out;
    public String urlPrefix = RuntimeEnvironment.getInstance().getUrlPrefix();
    public Annotation annotation;
    public Project project;
    protected Definitions defs;
    private final int yyeof;
    protected String userPageLink;
    protected String userPageSuffix;
    protected Stack<Integer> stack = new Stack();
    protected Stack<String> stackPopString = new Stack();
    private static final Style[] DEFINITION_STYLES = new Style[]{new Style("macro", "xm", "Macro"), new Style("argument", "xa", null), new Style("local", "xl", null), new Style("variable", "xv", "Variable"), new Style("class", "xc", "Class"), new Style("package", "xp", "Package"), new Style("interface", "xi", "Interface"), new Style("namespace", "xn", "Namespace"), new Style("enumerator", "xer", null), new Style("enum", "xe", "Enum"), new Style("struct", "xs", "Struct"), new Style("typedefs", "xts", null), new Style("typedef", "xt", "Typedef"), new Style("union", "xu", null), new Style("field", "xfld", null), new Style("member", "xmb", null), new Style("function", "xf", "Function"), new Style("method", "xmt", "Method"), new Style("subroutine", "xsr", "Subroutine")};

    protected JFlexXref() {
        try {
            Field f = this.getClass().getField("YYEOF");
            this.yyeof = f.getInt(null);
            this.userPageLink = RuntimeEnvironment.getInstance().getUserPage();
            if (this.userPageLink != null && this.userPageLink.length() == 0) {
                this.userPageLink = null;
            }
            this.userPageSuffix = RuntimeEnvironment.getInstance().getUserPageSuffix();
            if (this.userPageSuffix != null && this.userPageSuffix.length() == 0) {
                this.userPageSuffix = null;
            }
        }
        catch (Exception e) {
            AssertionError ae = new AssertionError((Object)"Couldn't initialize yyeof");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public void reInit(char[] contents, int length) {
        this.reInit(new CharArrayReader(contents, 0, length));
    }

    public final void reInit(Reader reader) {
        this.yyreset(reader);
        this.annotation = null;
    }

    public void setDefs(Definitions defs) {
        this.defs = defs;
    }

    protected void appendProject() throws IOException {
        if (this.project != null) {
            this.out.write("&amp;project=");
            this.out.write(this.project.getDescription());
        }
    }

    protected String getProjectPostfix(boolean encoded) {
        String amp = encoded ? "&amp;" : "&";
        return this.project == null ? "" : amp + "project=" + this.project.getDescription();
    }

    public abstract int yylex() throws IOException;

    public abstract void yyreset(Reader var1);

    protected abstract int getLineNumber();

    protected abstract void setLineNumber(int var1);

    public abstract void yybegin(int var1);

    public abstract int yystate();

    public void write(Writer out) throws IOException {
        this.out = out;
        this.writeSymbolTable();
        this.setLineNumber(0);
        this.startNewLine();
        while (this.yylex() != this.yyeof) {
        }
    }

    private void writeSymbolTable() throws IOException {
        if (this.defs == null) {
            return;
        }
        Comparator<Definitions.Tag> cmp = new Comparator<Definitions.Tag>(){

            @Override
            public int compare(Definitions.Tag tag1, Definitions.Tag tag2) {
                int ret = tag1.symbol.compareTo(tag2.symbol);
                if (ret == 0) {
                    ret = tag1.line - tag2.line;
                }
                return ret;
            }
        };
        HashMap<String, TreeSet<Definitions.Tag>> symbols = new HashMap<String, TreeSet<Definitions.Tag>>();
        for (Definitions.Tag tag : this.defs.getTags()) {
            Style style = this.getStyle(tag.type);
            if (style == null || style.title == null) continue;
            TreeSet<Definitions.Tag> tags = (TreeSet<Definitions.Tag>)symbols.get(style.name);
            if (tags == null) {
                tags = new TreeSet<Definitions.Tag>(cmp);
                symbols.put(style.name, tags);
            }
            tags.add(tag);
        }
        this.out.append("<script type=\"text/javascript\">/* <![CDATA[ */\n");
        this.out.append("function get_sym_list(){return [");
        boolean first = true;
        for (Style style : DEFINITION_STYLES) {
            SortedSet tags = (SortedSet)symbols.get(style.name);
            if (tags == null) continue;
            if (!first) {
                this.out.append(',');
            }
            this.out.append("[\"");
            this.out.append(style.title);
            this.out.append("\",\"");
            this.out.append(style.ssClass);
            this.out.append("\",[");
            boolean firstTag = true;
            for (Definitions.Tag tag : tags) {
                if (!firstTag) {
                    this.out.append(',');
                }
                this.out.append('[');
                this.out.append(Util.jsStringLiteral(tag.symbol));
                this.out.append(',');
                this.out.append(Integer.toString(tag.line));
                this.out.append(']');
                firstTag = false;
            }
            this.out.append("]]");
            first = false;
        }
        this.out.append("];} /* ]]> */</script>");
    }

    private Style getStyle(String type) {
        for (Style style : DEFINITION_STYLES) {
            if (!type.startsWith(style.name)) continue;
            return style;
        }
        return null;
    }

    protected void startNewLine() throws IOException {
        int line = this.getLineNumber() + 1;
        this.setLineNumber(line);
        Util.readableLine(line, this.out, this.annotation, this.userPageLink, this.userPageSuffix, this.getProjectPostfix(false));
    }

    protected void writeSymbol(String symbol, Set<String> keywords, int line) throws IOException {
        this.writeSymbol(symbol, keywords, line, true);
    }

    protected void writeSymbol(String symbol, Set<String> keywords, int line, boolean caseSensitive) throws IOException {
        String[] strs = new String[]{""};
        if (keywords != null && keywords.contains(caseSensitive ? symbol : symbol.toLowerCase())) {
            this.out.append("<b>").append(symbol).append("</b>");
        } else if (this.defs != null && this.defs.hasDefinitionAt(symbol, line, strs)) {
            String type = strs[0];
            String style_class = "d";
            Style style = this.getStyle(type);
            if (style != null) {
                style_class = style.ssClass;
            }
            this.out.append("<a class=\"");
            this.out.append(style_class);
            this.out.append("\" name=\"");
            this.out.append(symbol);
            this.out.append("\"/>");
            this.out.append("<a href=\"");
            this.out.append(this.urlPrefix);
            this.out.append("refs=");
            this.out.append(symbol);
            this.appendProject();
            this.out.append("\" class=\"");
            this.out.append(style_class);
            this.out.append("\">");
            this.out.append(symbol);
            this.out.append("</a>");
        } else if (this.defs != null && this.defs.occurrences(symbol) == 1) {
            String style_class = "d";
            this.out.append("<a class=\"");
            this.out.append(style_class);
            this.out.append("\" href=\"#");
            this.out.append(symbol);
            this.out.append("\">");
            this.out.append(symbol);
            this.out.append("</a>");
        } else {
            this.out.append("<a href=\"");
            this.out.append(this.urlPrefix);
            this.out.append("defs=");
            this.out.append(symbol);
            this.appendProject();
            this.out.append("\">");
            this.out.append(symbol);
            this.out.append("</a>");
        }
    }

    protected void writeUnicodeChar(char c) throws IOException {
        if (!Character.isISOControl(c)) {
            this.out.append("&#").append(Integer.toString(c)).append(';');
        }
    }

    protected void writeEMailAddress(String address) throws IOException {
        if (RuntimeEnvironment.getInstance().isObfuscatingEMailAddresses()) {
            this.out.write(address.replace("@", " (at) "));
        } else {
            this.out.write(address);
        }
    }

    public void yypush(int newState, String popString) {
        this.stack.push(this.yystate());
        this.stackPopString.push(popString);
        this.yybegin(newState);
    }

    public void yypop() throws IOException {
        this.yybegin(this.stack.pop());
        String popString = this.stackPopString.pop();
        if (popString != null) {
            this.out.write(popString);
        }
    }

    private static class Style {
        final String name;
        final String ssClass;
        final String title;

        Style(String name, String ssClass, String title) {
            this.name = name;
            this.ssClass = ssClass;
            this.title = title;
        }
    }
}

