/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GroupMetadataManager$ {
    public static GroupMetadataManager$ MODULE$;
    private final short CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    private final short CURRENT_GROUP_KEY_SCHEMA_VERSION;
    private final Schema OFFSET_COMMIT_KEY_SCHEMA;
    private final BoundField OFFSET_KEY_GROUP_FIELD;
    private final BoundField OFFSET_KEY_TOPIC_FIELD;
    private final BoundField OFFSET_KEY_PARTITION_FIELD;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V0;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V0;
    private final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V1;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V1;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private final Schema GROUP_METADATA_KEY_SCHEMA;
    private final BoundField GROUP_KEY_GROUP_FIELD;
    private final String MEMBER_ID_KEY;
    private final String CLIENT_ID_KEY;
    private final String CLIENT_HOST_KEY;
    private final String REBALANCE_TIMEOUT_KEY;
    private final String SESSION_TIMEOUT_KEY;
    private final String SUBSCRIPTION_KEY;
    private final String ASSIGNMENT_KEY;
    private final Schema MEMBER_METADATA_V0;
    private final Schema MEMBER_METADATA_V1;
    private final String PROTOCOL_TYPE_KEY;
    private final String GENERATION_KEY;
    private final String PROTOCOL_KEY;
    private final String LEADER_KEY;
    private final String MEMBERS_KEY;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V0;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V1;
    private final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS;
    private final Map<Object, Schema> OFFSET_VALUE_SCHEMAS;
    private final short CURRENT_OFFSET_VALUE_SCHEMA_VERSION;
    private final Map<Object, Schema> GROUP_VALUE_SCHEMAS;
    private final short kafka$coordinator$group$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION;
    private final Schema CURRENT_OFFSET_KEY_SCHEMA;
    private final Schema CURRENT_GROUP_KEY_SCHEMA;
    private final Schema CURRENT_OFFSET_VALUE_SCHEMA;
    private final Schema CURRENT_GROUP_VALUE_SCHEMA;

    static {
        new GroupMetadataManager$();
    }

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return this.CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return this.OFFSET_COMMIT_KEY_SCHEMA;
    }

    private BoundField OFFSET_KEY_GROUP_FIELD() {
        return this.OFFSET_KEY_GROUP_FIELD;
    }

    private BoundField OFFSET_KEY_TOPIC_FIELD() {
        return this.OFFSET_KEY_TOPIC_FIELD;
    }

    private BoundField OFFSET_KEY_PARTITION_FIELD() {
        return this.OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V0() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V0() {
        return this.OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return this.OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V1() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V1() {
        return this.OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return this.GROUP_METADATA_KEY_SCHEMA;
    }

    private BoundField GROUP_KEY_GROUP_FIELD() {
        return this.GROUP_KEY_GROUP_FIELD;
    }

    private String MEMBER_ID_KEY() {
        return this.MEMBER_ID_KEY;
    }

    private String CLIENT_ID_KEY() {
        return this.CLIENT_ID_KEY;
    }

    private String CLIENT_HOST_KEY() {
        return this.CLIENT_HOST_KEY;
    }

    private String REBALANCE_TIMEOUT_KEY() {
        return this.REBALANCE_TIMEOUT_KEY;
    }

    private String SESSION_TIMEOUT_KEY() {
        return this.SESSION_TIMEOUT_KEY;
    }

    private String SUBSCRIPTION_KEY() {
        return this.SUBSCRIPTION_KEY;
    }

    private String ASSIGNMENT_KEY() {
        return this.ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return this.MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return this.MEMBER_METADATA_V1;
    }

    private String PROTOCOL_TYPE_KEY() {
        return this.PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return this.GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return this.PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return this.LEADER_KEY;
    }

    private String MEMBERS_KEY() {
        return this.MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return this.MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return this.OFFSET_VALUE_SCHEMAS;
    }

    private short CURRENT_OFFSET_VALUE_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return this.GROUP_VALUE_SCHEMAS;
    }

    public short kafka$coordinator$group$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION() {
        return this.kafka$coordinator$group$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return this.CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return this.CURRENT_GROUP_KEY_SCHEMA;
    }

    private Schema CURRENT_OFFSET_VALUE_SCHEMA() {
        return this.CURRENT_OFFSET_VALUE_SCHEMA;
    }

    private Schema CURRENT_GROUP_VALUE_SCHEMA() {
        return this.CURRENT_GROUP_VALUE_SCHEMA;
    }

    private Schema schemaForKey(int version) {
        Schema schema;
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException("Unknown offset schema version " + version);
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    private Schema schemaForOffset(int version) {
        Schema schema;
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException("Unknown offset schema version " + version);
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    private Schema schemaForGroup(int version) {
        Schema schema;
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException("Unknown group metadata version " + version);
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    public byte[] offsetCommitKey(String group, TopicPartition topicPartition, short versionId) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topicPartition.topic());
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public short offsetCommitKey$default$3() {
        return 0;
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata) {
        Struct value = new Struct(this.CURRENT_OFFSET_VALUE_SCHEMA());
        value.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
        value.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
        value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
        value.set(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.expireTimestamp()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION());
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, short version) {
        Struct value = version == 0 ? new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0()) : new Struct(this.CURRENT_GROUP_VALUE_SCHEMA());
        value.set(this.PROTOCOL_TYPE_KEY(), groupMetadata.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        value.set(this.GENERATION_KEY(), (Object)BoxesRunTime.boxToInteger((int)groupMetadata.generationId()));
        value.set(this.PROTOCOL_KEY(), (Object)groupMetadata.protocolOrNull());
        value.set(this.LEADER_KEY(), (Object)groupMetadata.leaderOrNull());
        List memberArray = (List)groupMetadata.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)memberMetadata -> {
            Struct memberStruct = value.instance(MODULE$.MEMBERS_KEY());
            memberStruct.set(MODULE$.MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
            memberStruct.set(MODULE$.CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
            memberStruct.set(MODULE$.CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
            memberStruct.set(MODULE$.SESSION_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.sessionTimeoutMs()));
            Object object = version > 0 ? memberStruct.set(MODULE$.REBALANCE_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.rebalanceTimeoutMs())) : BoxedUnit.UNIT;
            String protocol = groupMetadata.protocolOrNull();
            if (protocol == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
            }
            byte[] metadata = memberMetadata.metadata(protocol);
            memberStruct.set(MODULE$.SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
            byte[] memberAssignment = (byte[])assignment.apply((Object)memberMetadata.memberId());
            Predef$.MODULE$.assert(memberAssignment != null);
            memberStruct.set(MODULE$.ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
            return memberStruct;
        }, List$.MODULE$.canBuildFrom());
        value.set(this.MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(version);
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public short groupMetadataValue$default$3() {
        return 0;
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        Product product;
        short version = buffer.getShort();
        Schema keySchema = this.schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version <= this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
            String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
            int partition = BoxesRunTime.unboxToInt((Object)key.get(this.OFFSET_KEY_PARTITION_FIELD()));
            product = new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
        } else if (version == this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
            product = new GroupMetadataKey(version, group);
        } else {
            throw new IllegalStateException("Unknown version " + version + " for group metadata message");
        }
        return product;
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        OffsetAndMetadata offsetAndMetadata;
        if (buffer == null) {
            offsetAndMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaForOffset(version);
            Struct value = valueSchema.read(buffer);
            if (version == 0) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
                long timestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
            } else if (version == 1) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
                long expireTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
            } else {
                throw new IllegalStateException("Unknown offset message version");
            }
        }
        return offsetAndMetadata;
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer) {
        GroupMetadata groupMetadata;
        if (buffer == null) {
            groupMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaForGroup(version);
            Struct value = valueSchema.read(buffer);
            if (version == 0 || version == 1) {
                int generationId = BoxesRunTime.unboxToInt((Object)value.get(this.GENERATION_KEY()));
                String protocolType = (String)value.get(this.PROTOCOL_TYPE_KEY());
                String protocol = (String)value.get(this.PROTOCOL_KEY());
                String leaderId = (String)value.get(this.LEADER_KEY());
                Object[] memberMetadataArray = value.getArray(this.MEMBERS_KEY());
                Product initialState = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(memberMetadataArray)).isEmpty() ? Empty$.MODULE$ : Stable$.MODULE$;
                MemberMetadata[] members = (MemberMetadata[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(memberMetadataArray)).map((Function1 & Serializable & scala.Serializable)memberMetadataObj -> {
                    Struct memberMetadata = (Struct)memberMetadataObj;
                    String memberId = (String)memberMetadata.get(MODULE$.MEMBER_ID_KEY());
                    String clientId = (String)memberMetadata.get(MODULE$.CLIENT_ID_KEY());
                    String clientHost = (String)memberMetadata.get(MODULE$.CLIENT_HOST_KEY());
                    int sessionTimeout = BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.SESSION_TIMEOUT_KEY()));
                    int rebalanceTimeout = version == 0 ? sessionTimeout : BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.REBALANCE_TIMEOUT_KEY()));
                    byte[] subscription = Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.SUBSCRIPTION_KEY())));
                    MemberMetadata member = new MemberMetadata(memberId, groupId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType, (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)protocol, (Object)subscription)})));
                    member.assignment_$eq(Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.ASSIGNMENT_KEY()))));
                    return member;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MemberMetadata.class)));
                groupMetadata = GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)initialState, generationId, protocolType, protocol, leaderId, (Iterable<MemberMetadata>)Predef$.MODULE$.wrapRefArray((Object[])members));
            } else {
                throw new IllegalStateException("Unknown group metadata message version");
            }
        }
        return groupMetadata;
    }

    private GroupMetadataManager$() {
        MODULE$ = this;
        this.CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
        this.CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
        this.OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", Type.STRING), new Field("topic", Type.STRING), new Field("partition", Type.INT32)});
        this.OFFSET_KEY_GROUP_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("group");
        this.OFFSET_KEY_TOPIC_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
        this.OFFSET_KEY_PARTITION_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        this.OFFSET_VALUE_TIMESTAMP_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", Type.INT64), new Field("expire_timestamp", Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        this.GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", Type.STRING)});
        this.GROUP_KEY_GROUP_FIELD = this.GROUP_METADATA_KEY_SCHEMA().get("group");
        this.MEMBER_ID_KEY = "member_id";
        this.CLIENT_ID_KEY = "client_id";
        this.CLIENT_HOST_KEY = "client_host";
        this.REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
        this.SESSION_TIMEOUT_KEY = "session_timeout";
        this.SUBSCRIPTION_KEY = "subscription";
        this.ASSIGNMENT_KEY = "assignment";
        this.MEMBER_METADATA_V0 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), Type.STRING), new Field(this.CLIENT_ID_KEY(), Type.STRING), new Field(this.CLIENT_HOST_KEY(), Type.STRING), new Field(this.SESSION_TIMEOUT_KEY(), Type.INT32), new Field(this.SUBSCRIPTION_KEY(), Type.BYTES), new Field(this.ASSIGNMENT_KEY(), Type.BYTES)});
        this.MEMBER_METADATA_V1 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), Type.STRING), new Field(this.CLIENT_ID_KEY(), Type.STRING), new Field(this.CLIENT_HOST_KEY(), Type.STRING), new Field(this.REBALANCE_TIMEOUT_KEY(), Type.INT32), new Field(this.SESSION_TIMEOUT_KEY(), Type.INT32), new Field(this.SUBSCRIPTION_KEY(), Type.BYTES), new Field(this.ASSIGNMENT_KEY(), Type.BYTES)});
        this.PROTOCOL_TYPE_KEY = "protocol_type";
        this.GENERATION_KEY = "generation";
        this.PROTOCOL_KEY = "protocol";
        this.LEADER_KEY = "leader";
        this.MEMBERS_KEY = "members";
        this.GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(this.GENERATION_KEY(), Type.INT32), new Field(this.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), Type.NULLABLE_STRING), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V0()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(this.GENERATION_KEY(), Type.INT32), new Field(this.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), Type.NULLABLE_STRING), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V1()))});
        this.MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.GROUP_METADATA_KEY_SCHEMA())}));
        this.OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V1())}));
        this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION = (short)1;
        this.GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V1())}));
        this.kafka$coordinator$group$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION = (short)1;
        this.CURRENT_OFFSET_KEY_SCHEMA = this.schemaForKey(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        this.CURRENT_GROUP_KEY_SCHEMA = this.schemaForKey(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        this.CURRENT_OFFSET_VALUE_SCHEMA = this.schemaForOffset(this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION());
        this.CURRENT_GROUP_VALUE_SCHEMA = this.schemaForGroup(this.kafka$coordinator$group$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION());
    }
}

