/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public abstract class EmbeddedExtensionProvider<PE extends ExtensionElement>
extends ExtensionElementProvider<PE> {
    @Override
    public final PE parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        XmlPullParser.Event event;
        String namespace = parser2.getNamespace();
        String name = parser2.getName();
        int attributeCount = parser2.getAttributeCount();
        HashMap<String, String> attMap = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attMap.put(parser2.getAttributeName(i), parser2.getAttributeValue(i));
        }
        ArrayList<ExtensionElement> extensions = new ArrayList<ExtensionElement>();
        do {
            if ((event = parser2.next()) != XmlPullParser.Event.START_ELEMENT) continue;
            PacketParserUtils.addExtensionElement(extensions, parser2, xmlEnvironment);
        } while (event != XmlPullParser.Event.END_ELEMENT || parser2.getDepth() != initialDepth);
        return this.createReturnExtension(name, namespace, attMap, extensions);
    }

    protected abstract PE createReturnExtension(String var1, String var2, Map<String, String> var3, List<? extends ExtensionElement> var4);
}

