/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import free.jin.I18n;
import free.jin.scripter.Script;
import free.jin.scripter.Scripter;
import free.util.AWTUtilities;
import free.util.NamedObject;
import free.util.TableLayout;
import free.util.Utilities;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJComboBox;
import free.workarounds.FixedJTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.EmptyBorder;

abstract class ScriptDialog
extends JDialog {
    private static final String SELECT_EVENT_TYPE = "selectEventType";
    protected final Scripter scripter;
    protected final Script templateScript;
    private Script script = null;

    public ScriptDialog(Component component, String string, Scripter scripter, Script script) {
        super(AWTUtilities.frameForComponent((Component)component), string, true);
        if (scripter == null) {
            throw new IllegalArgumentException("The specified scripter is null");
        }
        this.templateScript = script;
        this.scripter = scripter;
        SwingUtils.registerEscapeCloser((RootPaneContainer)this);
    }

    protected abstract Container createScriptTypeSpecificUI();

    protected abstract Script createScriptOnOk(String var1, String var2, String[] var3);

    protected final void createUI() {
        Object object;
        I18n i18n = this.scripter.getI18n();
        I18n i18n2 = I18n.get((Class)ScriptDialog.class);
        String string = this.templateScript == null ? "" : this.templateScript.getName();
        String string2 = this.templateScript == null ? SELECT_EVENT_TYPE : this.templateScript.getEventType();
        String[] stringArray = this.templateScript == null ? new String[]{} : this.templateScript.getEventSubtypes();
        String[] stringArray2 = this.scripter.getSupportedEventTypes();
        Object[] objectArray = new NamedObject[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            objectArray[i] = new NamedObject((Object)stringArray2[i], i18n.getString("eventTypeNames." + stringArray2[i]));
        }
        FixedJTextField fixedJTextField = new FixedJTextField(string);
        FixedJComboBox fixedJComboBox = new FixedJComboBox(objectArray);
        fixedJComboBox.setEditable(false);
        fixedJComboBox.addItem(new NamedObject((Object)SELECT_EVENT_TYPE, i18n2.getString("selectEventTypeString")));
        for (int i = 0; i < fixedJComboBox.getItemCount(); ++i) {
            object = (NamedObject)fixedJComboBox.getItemAt(i);
            if (!object.getTarget().equals(string2)) continue;
            fixedJComboBox.setSelectedIndex(i);
            break;
        }
        JPanel jPanel = new JPanel((LayoutManager)new TableLayout(2));
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(new EmptyBorder(2, 2, 2, 2));
        ((Container)object).add((Component)jPanel, "North");
        JScrollPane jScrollPane = new JScrollPane((Component)object);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(300, 115));
        if (this.templateScript != null) {
            this.updateSubtypesPanel(jPanel, string2, stringArray);
        }
        fixedJComboBox.addActionListener(new ActionListener((JComboBox)fixedJComboBox, jPanel){
            private final /* synthetic */ JComboBox val$eventTypeChoice;
            private final /* synthetic */ JPanel val$subtypesPanel;
            {
                this.val$eventTypeChoice = jComboBox;
                this.val$subtypesPanel = jPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NamedObject namedObject = (NamedObject)this.val$eventTypeChoice.getSelectedItem();
                String string = (String)namedObject.getTarget();
                String[] stringArray = ScriptDialog.this.templateScript == null ? new String[]{} : ScriptDialog.this.templateScript.getEventSubtypes();
                ScriptDialog.this.updateSubtypesPanel(this.val$subtypesPanel, string, stringArray);
            }
        });
        JLabel jLabel = i18n2.createLabel("scriptNameLabel");
        JLabel jLabel2 = i18n2.createLabel("eventTypeLabel");
        JLabel jLabel3 = i18n2.createLabel("eventSubtypesLabel");
        jLabel.setLabelFor((Component)fixedJTextField);
        jLabel2.setLabelFor((Component)fixedJComboBox);
        jLabel3.setLabelFor(jPanel);
        jLabel3.setAlignmentY(0.0f);
        JButton jButton = i18n2.createButton("eventTypeHelpButton");
        JButton jButton2 = i18n2.createButton("eventSubtypesHelpButton");
        jButton.setDefaultCapable(false);
        jButton2.setDefaultCapable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                I18n i18n = I18n.get((Class)(class$free$jin$scripter$ScriptDialog == null ? (class$free$jin$scripter$ScriptDialog = ScriptDialog.class$("free.jin.scripter.ScriptDialog")) : class$free$jin$scripter$ScriptDialog));
                i18n.showPlainTextDialog("eventTypeHelpDialog", (Component)ScriptDialog.this);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                I18n i18n = I18n.get((Class)(class$free$jin$scripter$ScriptDialog == null ? (class$free$jin$scripter$ScriptDialog = ScriptDialog.class$("free.jin.scripter.ScriptDialog")) : class$free$jin$scripter$ScriptDialog));
                i18n.showPlainTextDialog("eventSubtypesHelpDialog", (Component)ScriptDialog.this);
            }
        });
        JPanel jPanel2 = new JPanel((LayoutManager)new TableLayout(3, 7, 5));
        jPanel2.add(jLabel);
        jPanel2.add((Component)fixedJTextField);
        jPanel2.add(Box.createVerticalStrut(jButton.getPreferredSize().height));
        jPanel2.add(jLabel2);
        jPanel2.add((Component)fixedJComboBox);
        jPanel2.add(jButton);
        jPanel2.add(jLabel3);
        jPanel2.add(jScrollPane);
        jPanel2.add(jButton2);
        Container container = this.createScriptTypeSpecificUI();
        JPanel jPanel3 = new JPanel(null);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new EmptyBorder(10, 10, 5, 10));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalStrut(10));
        jPanel3.add(container);
        JButton jButton3 = i18n2.createButton("scriptDialogOkButton");
        JButton jButton4 = i18n2.createButton("scriptDialogCancelButton");
        jButton3.addActionListener(new ActionListener((JTextField)fixedJTextField, (JComboBox)fixedJComboBox, jPanel){
            private final /* synthetic */ JTextField val$scriptNameField;
            private final /* synthetic */ JComboBox val$eventTypeChoice;
            private final /* synthetic */ JPanel val$subtypesPanel;
            {
                this.val$scriptNameField = jTextField;
                this.val$eventTypeChoice = jComboBox;
                this.val$subtypesPanel = jPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.val$scriptNameField.getText();
                NamedObject namedObject = (NamedObject)this.val$eventTypeChoice.getSelectedItem();
                String string2 = (String)namedObject.getTarget();
                Vector<String> vector = new Vector<String>();
                Component[] componentArray = this.val$subtypesPanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    JCheckBox jCheckBox;
                    Component component = componentArray[i];
                    if (!(component instanceof JCheckBox) || !(jCheckBox = (JCheckBox)component).isSelected()) continue;
                    vector.addElement(jCheckBox.getActionCommand());
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                if (string == null || string.length() == 0) {
                    I18n.get((Class)(class$free$jin$scripter$ScriptDialog == null ? (class$free$jin$scripter$ScriptDialog = ScriptDialog.class$("free.jin.scripter.ScriptDialog")) : class$free$jin$scripter$ScriptDialog)).error("missingScriptNameDialog", (Component)ScriptDialog.this);
                    return;
                }
                if (ScriptDialog.SELECT_EVENT_TYPE.equals(string2)) {
                    I18n.get((Class)(class$free$jin$scripter$ScriptDialog == null ? (class$free$jin$scripter$ScriptDialog = ScriptDialog.class$("free.jin.scripter.ScriptDialog")) : class$free$jin$scripter$ScriptDialog)).error("missingEventTypeDialog", (Component)ScriptDialog.this);
                    return;
                }
                if (objectArray.length == 0 && ScriptDialog.this.scripter.getEventSubtypes(string2) != null) {
                    I18n.get((Class)(class$free$jin$scripter$ScriptDialog == null ? (class$free$jin$scripter$ScriptDialog = ScriptDialog.class$("free.jin.scripter.ScriptDialog")) : class$free$jin$scripter$ScriptDialog)).error("missingEventSubtypeDialog", (Component)ScriptDialog.this);
                    return;
                }
                ScriptDialog.this.script = ScriptDialog.this.createScriptOnOk(string, string2, (String[])objectArray);
                if (ScriptDialog.this.script != null) {
                    ScriptDialog.this.dispose();
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptDialog.this.script = null;
                ScriptDialog.this.dispose();
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 10));
        jPanel5.add((Component)jPanel3, "Center");
        jPanel5.add((Component)jPanel4, "South");
        this.setContentPane(jPanel5);
        this.getRootPane().setDefaultButton(jButton3);
    }

    private void updateSubtypesPanel(JPanel jPanel, String string, String[] stringArray) {
        String[] stringArray2;
        jPanel.removeAll();
        if (!SELECT_EVENT_TYPE.equals(string) && (stringArray2 = this.scripter.getEventSubtypes(string)) != null) {
            I18n i18n = this.scripter.getI18n();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string2 = stringArray2[i];
                JCheckBox jCheckBox = new JCheckBox(i18n.getString("eventSubtypeNames." + string + "." + string2));
                jCheckBox.setActionCommand(string2);
                jCheckBox.setSelected(Utilities.contains((Object[])stringArray, (Object)string2));
                jPanel.add(jCheckBox);
            }
        }
        jPanel.revalidate();
    }

    public Script askForScript() {
        this.setVisible(true);
        return this.script;
    }
}

