/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.util;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.TaskPools;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\r\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001cH\u0002R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/jicofo/util/RateLimitedStat;", "", "changeInterval", "Ljava/time/Duration;", "onChanged", "Lkotlin/Function1;", "", "", "initialValue", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function1;ILjava/time/Clock;)V", "_value", "lastChanged", "Ljava/time/Instant;", "lock", "updateTask", "Ljava/util/concurrent/Future;", "newValue", "value", "getValue", "()I", "setValue", "(I)V", "adjustValue", "delta", "reportChanged", "stop", "", "()Ljava/lang/Boolean;", "valueUpdated", "jicofo"})
@SourceDebugExtension(value={"SMAP\nRateLimitedStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RateLimitedStat.kt\norg/jitsi/jicofo/util/RateLimitedStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class RateLimitedStat {
    @NotNull
    private final Duration changeInterval;
    @NotNull
    private final Function1<Integer, Unit> onChanged;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Object lock;
    private int _value;
    @Nullable
    private Instant lastChanged;
    @Nullable
    private Future<?> updateTask;

    @JvmOverloads
    public RateLimitedStat(@NotNull Duration changeInterval, @NotNull Function1<? super Integer, Unit> onChanged, int initialValue, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)changeInterval, (String)"changeInterval");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.changeInterval = changeInterval;
        this.onChanged = onChanged;
        this.clock = clock;
        this.lock = new Object();
        this._value = initialValue;
    }

    public /* synthetic */ RateLimitedStat(Duration duration, Function1 function1, int n, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(duration, (Function1<? super Integer, Unit>)function1, n, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getValue() {
        int n;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            n = this._value;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(int newValue) {
        boolean report = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this._value = newValue;
            report = this.valueUpdated();
            Unit unit = Unit.INSTANCE;
        }
        if (report) {
            this.reportChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void adjustValue(int delta) {
        boolean report = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this._value += delta;
            report = this.valueUpdated();
            Unit unit = Unit.INSTANCE;
        }
        if (report) {
            this.reportChanged();
        }
    }

    private final boolean valueUpdated() {
        Instant now = Instant.now();
        if (this.updateTask != null) {
            return false;
        }
        Instant instant = this.lastChanged;
        if (instant != null) {
            Instant it = instant;
            boolean bl = false;
            if (Duration.between(it, now).compareTo(this.changeInterval) < 0) {
                Instant notificationTime = it.plus(this.changeInterval);
                Duration delay = Duration.between(now, notificationTime);
                this.updateTask = TaskPools.Companion.getScheduledPool().schedule(() -> RateLimitedStat.valueUpdated$lambda$4$lambda$3(this), delay.toMillis(), TimeUnit.MILLISECONDS);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reportChanged() {
        int value = 0;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            value = this._value;
            this.lastChanged = this.clock.instant();
            this.updateTask = null;
            Unit unit = Unit.INSTANCE;
        }
        this.onChanged.invoke((Object)value);
    }

    @Nullable
    public final Boolean stop() {
        Future<?> future = this.updateTask;
        return future != null ? Boolean.valueOf(future.cancel(false)) : null;
    }

    @JvmOverloads
    public RateLimitedStat(@NotNull Duration changeInterval, @NotNull Function1<? super Integer, Unit> onChanged, int initialValue) {
        Intrinsics.checkNotNullParameter((Object)changeInterval, (String)"changeInterval");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        this(changeInterval, onChanged, initialValue, null, 8, null);
    }

    @JvmOverloads
    public RateLimitedStat(@NotNull Duration changeInterval, @NotNull Function1<? super Integer, Unit> onChanged) {
        Intrinsics.checkNotNullParameter((Object)changeInterval, (String)"changeInterval");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        this(changeInterval, onChanged, 0, null, 12, null);
    }

    private static final void valueUpdated$lambda$4$lambda$3(RateLimitedStat this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.reportChanged();
    }
}

