/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar.quickfix;

import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.EventTrackingIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.choice.ChoiceTitleIntentionAction;
import com.intellij.codeInsight.intention.choice.ChoiceVariantIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.ide.fus.AcceptanceRateTracker;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieCustomFixWrapper;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.text.StringOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000212B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0007J2\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f0\u0005H\u0007J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0013\u0010#\u001a\u00070\r\u00a2\u0006\u0002\b$2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u001e\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u000200\u00a8\u00063"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix;", "", "<init>", "()V", "getReplacementFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "problem", "Lcom/intellij/grazie/text/TextProblem;", "underlineRanges", "Lcom/intellij/psi/SmartPsiFileRange;", "toFileReplacements", "Lkotlin/Pair;", "", "replacementRange", "Lcom/intellij/openapi/util/TextRange;", "suggestion", "", "text", "Lcom/intellij/grazie/text/TextContent;", "removalWouldGlueUnrelatedTokens", "", "removedRange", "isWordMiddle", "index", "", "applyReplacements", "", "document", "Lcom/intellij/openapi/editor/Document;", "replacements", "makeNonEmpty", "range", "file", "Lcom/intellij/psi/PsiFile;", "familyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "commonPrefixLength", "s1", "s2", "commonSuffixLength", "charsMatch", "c1", "", "c2", "removeHighlightersWithExactRange", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/util/Segment;", "ReplaceTypoTitleAction", "ChangeToVariantAction", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieReplaceTypoQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieReplaceTypoQuickFix.kt\ncom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1332#2,2:264\n1334#2:276\n1374#3:266\n1460#3,5:267\n1563#3:272\n1634#3,3:273\n1563#3:277\n1634#3,3:278\n1869#3,2:281\n*S KotlinDebug\n*F\n+ 1 GrazieReplaceTypoQuickFix.kt\ncom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix\n*L\n155#1:264,2\n155#1:276\n157#1:266\n157#1:267,5\n159#1:272\n159#1:273,3\n192#1:277\n192#1:278,3\n207#1:281,2\n*E\n"})
public final class GrazieReplaceTypoQuickFix {
    @NotNull
    public static final GrazieReplaceTypoQuickFix INSTANCE = new GrazieReplaceTypoQuickFix();

    private GrazieReplaceTypoQuickFix() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<LocalQuickFix> getReplacementFixes(@NotNull TextProblem problem, @NotNull List<? extends SmartPsiFileRange> underlineRanges) {
        Sequence suggestions;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter(underlineRanges, (String)"underlineRanges");
        PsiFile psiFile = problem.getText().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)file.getProject());
        String familyName = INSTANCE.familyName(problem);
        Object[] objectArray = new LocalQuickFix[1];
        String string = problem.getShortMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortMessage(...)");
        objectArray[0] = new ReplaceTypoTitleAction(familyName, string);
        ArrayList result = CollectionsKt.arrayListOf((Object[])objectArray);
        List<TextProblem.Suggestion> list = problem.getSuggestions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
        Sequence $this$forEachIndexed$iv = suggestions = SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)list), (int)15);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            void suggestion;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TextProblem.Suggestion suggestion2 = (TextProblem.Suggestion)item$iv;
            int index = n;
            boolean bl = false;
            List<StringOperation> changes = suggestion.getChanges();
            Intrinsics.checkNotNull(changes);
            Iterable $this$flatMap$iv = changes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo22 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                StringOperation it = (StringOperation)element$iv$iv;
                boolean bl2 = false;
                TextRange textRange = it.getRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRange(...)");
                CharSequence charSequence = it.getReplacement();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getReplacement(...)");
                TextContent textContent = problem.getText();
                Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
                Iterable list$iv$iv = GrazieReplaceTypoQuickFix.toFileReplacements(textRange, charSequence, textContent);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List replacements = (List)destination$iv$iv;
            String presentable = suggestion.getPresentableText();
            Iterable $this$map$iv = changes;
            boolean $i$f$map = false;
            Iterable $i$f$flatMapTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StringOperation stringOperation = (StringOperation)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                TextRange textRange = problem.getText().textRangeToFile(it.getRange());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRangeToFile(...)");
                collection.add(spm.createSmartPsiFileRangePointer(file, INSTANCE.makeNonEmpty(textRange, file)));
            }
            List toHighlight = (List)destination$iv$iv2;
            AcceptanceRateTracker tracker = new AcceptanceRateTracker(problem);
            int n2 = problem.getSuggestions().size();
            Intrinsics.checkNotNull((Object)presentable);
            result.add(new ChangeToVariantAction(index, n2, familyName, presentable, replacements, underlineRanges, toHighlight, suggestion.getBatchId(), tracker));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final List<Pair<SmartPsiFileRange, String>> toFileReplacements(@NotNull TextRange replacementRange, @NotNull CharSequence suggestion, @NotNull TextContent text) {
        void $this$mapTo$iv$iv;
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)replacementRange, (String)"replacementRange");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = replacementRange.subSequence((CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        CharSequence replacedText = charSequence;
        int commonPrefix = INSTANCE.commonPrefixLength(suggestion, replacedText);
        int commonSuffix = Math.min(INSTANCE.commonSuffixLength(suggestion, replacedText), Math.min(suggestion.length(), replacementRange.getLength()) - commonPrefix);
        TextRange localRange = new TextRange(replacementRange.getStartOffset() + commonPrefix, replacementRange.getEndOffset() - commonSuffix);
        String replacement = null;
        replacement = ((Object)suggestion.subSequence(commonPrefix, suggestion.length() - commonSuffix)).toString();
        PsiFile psiFile = text.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)file.getProject());
        List<TextRange> shreds = text.intersection(text.textRangeToFile(localRange));
        if (shreds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (((CharSequence)replacement).length() == 0 && INSTANCE.removalWouldGlueUnrelatedTokens(localRange, text)) {
            replacement = " ";
        }
        if (INSTANCE.isWordMiddle(text, localRange.getEndOffset())) {
            Intrinsics.checkNotNull(shreds);
            textRange = (TextRange)CollectionsKt.last(shreds);
        } else {
            Intrinsics.checkNotNull(shreds);
            textRange = (TextRange)CollectionsKt.first(shreds);
        }
        TextRange best = textRange;
        Iterable $this$map$iv = shreds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange2 = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)spm.createSmartPsiFileRangePointer(file, (TextRange)it), (Object)(it == best ? replacement : "")));
        }
        return (List)destination$iv$iv;
    }

    private final boolean removalWouldGlueUnrelatedTokens(TextRange removedRange, TextContent text) {
        int prevFileIndex = text.textOffsetToFile(0) - 1;
        return removedRange.getEndOffset() < text.length() && Character.isLetterOrDigit(text.charAt(removedRange.getEndOffset())) && prevFileIndex > 0 && Character.isLetterOrDigit(text.getContainingFile().getViewProvider().getContents().charAt(prevFileIndex));
    }

    private final boolean isWordMiddle(CharSequence text, int index) {
        return index > 0 && index < text.length() && Character.isLetter(text.charAt(index)) && Character.isLetter(text.charAt(index - 1));
    }

    @JvmStatic
    @VisibleForTesting
    public static final void applyReplacements(@NotNull Document document, @NotNull List<? extends Pair<? extends SmartPsiFileRange, String>> replacements) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Iterable $this$forEach$iv = replacements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Segment segment = ((SmartPsiFileRange)it.getFirst()).getRange();
            Intrinsics.checkNotNull((Object)segment);
            int n = segment.getStartOffset();
            Segment segment2 = ((SmartPsiFileRange)it.getFirst()).getRange();
            Intrinsics.checkNotNull((Object)segment2);
            document.replaceString(n, segment2.getEndOffset(), (CharSequence)it.getSecond());
        }
    }

    private final TextRange makeNonEmpty(TextRange range, PsiFile file) {
        int end;
        int start = range.getStartOffset();
        if (start == (end = range.getEndOffset())) {
            if (end < file.getTextLength()) {
                ++end;
            } else if (start > 0) {
                --start;
            }
        }
        return new TextRange(start, end);
    }

    @NotNull
    public final String familyName(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)problem.getShortMessage(), (String)"getShortMessage(...)");
        return GrazieBundle.message("grazie.grammar.quickfix.replace.typo.text", objectArray);
    }

    private final int commonPrefixLength(CharSequence s1, CharSequence s2) {
        int i;
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && this.charsMatch(s1.charAt(i), s2.charAt(i)); ++i) {
        }
        return i;
    }

    private final int commonSuffixLength(CharSequence s1, CharSequence s2) {
        int i;
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && this.charsMatch(s1.charAt(s1.length() - i - 1), s2.charAt(s2.length() - i - 1)); ++i) {
        }
        return i;
    }

    private final boolean charsMatch(char c1, char c2) {
        return c1 == c2 || c1 == ' ' && c2 == '\n';
    }

    public final void removeHighlightersWithExactRange(@NotNull Document document, @NotNull Project project, @NotNull Segment range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)false);
        if (markupModel == null) {
            return;
        }
        MarkupModel model = markupModel;
        for (RangeHighlighter rangeHighlighter : model.getAllHighlighters()) {
            Intrinsics.checkNotNull((Object)rangeHighlighter);
            RangeHighlighter highlighter = rangeHighlighter;
            if (!TextRange.areSegmentsEqual((Segment)range, (Segment)((Segment)highlighter))) continue;
            model.removeHighlighter(highlighter);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001:Bs\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u0012\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e0\r\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\r\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\r\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\nH\u0016J\"\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020+H\u0016J\"\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u00101\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u00020+H\u0004J\b\u00103\u001a\u00020\u001bH\u0016J\u0011\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u001dH\u0096\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u0002070\r2\u0006\u0010(\u001a\u00020)2\u0006\u00108\u001a\u00020+H\u0016J \u00109\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/codeInsight/daemon/impl/actions/IntentionActionWithFixAllOption;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/codeInsight/intention/EventTrackingIntentionAction;", "index", "", "total", "family", "", "suggestion", "replacements", "", "Lkotlin/Pair;", "Lcom/intellij/psi/SmartPsiFileRange;", "underlineRanges", "toHighlight", "batchId", "tracker", "Lcom/intellij/grazie/ide/fus/AcceptanceRateTracker;", "<init>", "(IILjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Lcom/intellij/grazie/ide/fus/AcceptanceRateTracker;)V", "getIndex", "()I", "getName", "isShowSubmenu", "", "getOptions", "Lcom/intellij/codeInsight/intention/IntentionAction;", "belongsToMyFamily", "action", "getFixAllText", "getCombiningPolicy", "Lcom/intellij/codeInsight/intention/IntentionActionWithOptions$CombiningPolicy;", "getTooltipText", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "applyFix", "", "performFix", "file", "startInWriteAction", "compareTo", "other", "getRangesToHighlight", "Lcom/intellij/codeInsight/intention/CustomizableIntentionAction$RangeToHighlight;", "_file", "suggestionShown", "ForPreview", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieReplaceTypoQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieReplaceTypoQuickFix.kt\ncom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ChangeToVariantAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1740#2,3:264\n1869#2:267\n1870#2:269\n1617#2,9:270\n1869#2:279\n1870#2:281\n1626#2:282\n1#3:268\n1#3:280\n*S KotlinDebug\n*F\n+ 1 GrazieReplaceTypoQuickFix.kt\ncom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ChangeToVariantAction\n*L\n91#1:264,3\n104#1:267\n104#1:269\n118#1:270,9\n118#1:279\n118#1:281\n118#1:282\n118#1:280\n*E\n"})
    private static class ChangeToVariantAction
    extends ChoiceVariantIntentionAction
    implements HighPriorityAction,
    IntentionActionWithFixAllOption,
    DumbAware,
    EventTrackingIntentionAction {
        private final int index;
        private final int total;
        @NotNull
        private final String family;
        @NotNull
        private final String suggestion;
        @NotNull
        private final List<Pair<SmartPsiFileRange, String>> replacements;
        @NotNull
        private final List<SmartPsiFileRange> underlineRanges;
        @NotNull
        private final List<SmartPsiFileRange> toHighlight;
        @Nullable
        private final String batchId;
        @NotNull
        private final AcceptanceRateTracker tracker;

        public ChangeToVariantAction(int index, int total, @IntentionFamilyName @NotNull String family, @NlsSafe @NotNull String suggestion, @NotNull List<? extends Pair<? extends SmartPsiFileRange, String>> replacements, @NotNull List<? extends SmartPsiFileRange> underlineRanges, @NotNull List<? extends SmartPsiFileRange> toHighlight, @Nullable String batchId, @NotNull AcceptanceRateTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
            Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
            Intrinsics.checkNotNullParameter(underlineRanges, (String)"underlineRanges");
            Intrinsics.checkNotNullParameter(toHighlight, (String)"toHighlight");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            this.index = index;
            this.total = total;
            this.family = family;
            this.suggestion = suggestion;
            this.replacements = replacements;
            this.underlineRanges = underlineRanges;
            this.toHighlight = toHighlight;
            this.batchId = batchId;
            this.tracker = tracker;
        }

        public int getIndex() {
            return this.index;
        }

        @NotNull
        public String getName() {
            if (((CharSequence)this.suggestion).length() == 0) {
                return SwingKTKt.msg("grazie.grammar.quickfix.remove.typo.tooltip", new String[0]);
            }
            if (CharsKt.isWhitespace((char)this.suggestion.charAt(0)) || CharsKt.isWhitespace((char)StringsKt.last((CharSequence)this.suggestion))) {
                return "'" + this.suggestion + "'";
            }
            return this.suggestion;
        }

        public boolean isShowSubmenu() {
            return this.batchId != null;
        }

        @NotNull
        public List<IntentionAction> getOptions() {
            List list;
            if (this.batchId == null) {
                list = CollectionsKt.emptyList();
            } else {
                List list2 = super.getOptions();
                list = list2;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOptions(...)");
            }
            return list;
        }

        public boolean belongsToMyFamily(@NotNull IntentionActionWithFixAllOption action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            return action2 instanceof ChangeToVariantAction && Intrinsics.areEqual((Object)((ChangeToVariantAction)action2).batchId, (Object)this.batchId);
        }

        @NotNull
        public String getFixAllText() {
            return GrazieBundle.message("grazie.grammar.quickfix.apply.batch.text", new Object[0]);
        }

        @NotNull
        public IntentionActionWithOptions.CombiningPolicy getCombiningPolicy() {
            return IntentionActionWithOptions.CombiningPolicy.IntentionOptionsOnly;
        }

        @NotNull
        public String getTooltipText() {
            String string;
            if (((CharSequence)this.suggestion).length() > 0) {
                String[] stringArray = new String[]{this.suggestion};
                string = SwingKTKt.msg("grazie.grammar.quickfix.replace.typo.tooltip", stringArray);
            } else {
                string = SwingKTKt.msg("grazie.grammar.quickfix.remove.typo.tooltip", new String[0]);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return this.family;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile psiFile) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Iterable $this$all$iv = this.replacements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (((SmartPsiFileRange)it.getFirst()).getRange() != null) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return (FileModifier)new ForPreview(this.getIndex(), this.total, this.family, this.suggestion, this.replacements, this.underlineRanges, this.toHighlight, this.batchId, this.tracker);
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            GrazieFUSCounter.INSTANCE.suggestionAccepted(project, this.tracker, this.getIndex(), this.total);
            this.performFix(project, psiFile);
        }

        protected final void performFix(@NotNull Project project, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            Document document2 = document;
            Iterable $this$forEach$iv = this.underlineRanges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Segment it;
                SmartPsiFileRange underline = (SmartPsiFileRange)element$iv;
                boolean bl = false;
                if (underline.getRange() == null) continue;
                boolean bl2 = false;
                INSTANCE.removeHighlightersWithExactRange(document2, project, it);
            }
            GrazieReplaceTypoQuickFix.applyReplacements(document2, this.replacements);
        }

        public boolean startInWriteAction() {
            return true;
        }

        public int compareTo(@NotNull IntentionAction other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (other instanceof GrazieCustomFixWrapper) {
                return -1;
            }
            return super.compareTo(other);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(@NotNull Editor editor, @NotNull PsiFile _file) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)_file, (String)"_file");
            Iterable $this$mapNotNull$iv = this.toHighlight;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CustomizableIntentionAction.RangeToHighlight it$iv$iv;
                Segment range;
                PsiFile file;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SmartPsiFileRange it = (SmartPsiFileRange)element$iv$iv;
                boolean bl2 = false;
                if ((it.getRange() == null ? null : (it.getContainingFile() == null ? null : new CustomizableIntentionAction.RangeToHighlight((PsiElement)file, TextRange.create((Segment)range), EditorColors.SEARCH_RESULT_ATTRIBUTES))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public void suggestionShown(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (this.tracker.markShown()) {
                GrazieFUSCounter.INSTANCE.suggestionShown(project, this.tracker);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002Bs\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b0\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\n\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ChangeToVariantAction$ForPreview;", "Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "index", "", "total", "family", "", "suggestion", "replacements", "", "Lkotlin/Pair;", "Lcom/intellij/psi/SmartPsiFileRange;", "underlineRanges", "toHighlight", "batchId", "tracker", "Lcom/intellij/grazie/ide/fus/AcceptanceRateTracker;", "<init>", "(IILjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Lcom/intellij/grazie/ide/fus/AcceptanceRateTracker;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.grazie.core"})
        private static final class ForPreview
        extends ChangeToVariantAction
        implements IntentionPreviewInfo {
            public ForPreview(int index, int total, @IntentionFamilyName @NotNull String family, @NlsSafe @NotNull String suggestion, @NotNull List<? extends Pair<? extends SmartPsiFileRange, String>> replacements, @NotNull List<? extends SmartPsiFileRange> underlineRanges, @NotNull List<? extends SmartPsiFileRange> toHighlight, @Nullable String batchId, @NotNull AcceptanceRateTracker tracker) {
                Intrinsics.checkNotNullParameter((Object)family, (String)"family");
                Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
                Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
                Intrinsics.checkNotNullParameter(underlineRanges, (String)"underlineRanges");
                Intrinsics.checkNotNullParameter(toHighlight, (String)"toHighlight");
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                super(index, total, family, suggestion, replacements, underlineRanges, toHighlight, batchId, tracker);
            }

            @Override
            public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                this.performFix(project, psiFile);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ReplaceTypoTitleAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/openapi/project/DumbAware;", "family", "", "title", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "compareTo", "", "other", "Lcom/intellij/codeInsight/intention/IntentionAction;", "intellij.grazie.core"})
    private static final class ReplaceTypoTitleAction
    extends ChoiceTitleIntentionAction
    implements HighPriorityAction,
    DumbAware {
        public ReplaceTypoTitleAction(@IntentionFamilyName @NotNull String family, @IntentionName @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            super(family, title);
        }

        public int compareTo(@NotNull IntentionAction other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (other instanceof GrazieCustomFixWrapper) {
                return -1;
            }
            return super.compareTo(other);
        }
    }
}

