/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J-\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkAnnotationClassMember", "member", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "isAllowedClassKind", "", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedArray", "type", "checkCyclesInParameters", "annotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "CycleChecker", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,247:1\n63#2:248\n*S KotlinDebug\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker\n*L\n45#1:248\n*E\n"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE = new FirAnnotationClassDeclarationChecker();

    private FirAnnotationClassDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), null, 8, null);
        }
        if (declaration.getSuperTypeRefs().size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), null, 8, null);
        }
        DeclarationUtilsKt.processAllDeclarations$default(declaration, context2.getSession(), null, arg_0 -> FirAnnotationClassDeclarationChecker.check$lambda$0(context2, reporter, arg_0), 2, null);
        FirSession session = context2.getSession();
        if (FirRetentionAnnotationHelpersKt.getRetention(declaration, session) != AnnotationRetention.SOURCE && FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration, session).contains((Object)KotlinTarget.EXPRESSION)) {
            FirElement firElement;
            FirAnnotation firAnnotation = FirRetentionAnnotationHelpersKt.getRetentionAnnotation(declaration, session);
            if (firAnnotation != null) {
                firElement = firAnnotation;
            } else {
                FirAnnotation firAnnotation2 = FirAnnotationHelpersKt.getTargetAnnotation(declaration, session);
                firElement = firAnnotation2 != null ? (FirElement)firAnnotation2 : (FirElement)declaration;
            }
            FirElement target = firElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)target.getSource(), FirErrors.INSTANCE.getRESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION_ERROR(), null, 8, null);
        }
        this.checkCyclesInParameters(context2, reporter, declaration.getSymbol());
    }

    private final void checkAnnotationClassMember(CheckerContext context2, DiagnosticReporter reporter, FirBasedSymbol<?> member) {
        block13: {
            block14: {
                block12: {
                    if (!(member instanceof FirConstructorSymbol) || !((FirConstructorSymbol)member).isPrimary()) break block12;
                    for (FirValueParameterSymbol parameter : ((FirConstructorSymbol)member).getValueParameterSymbols()) {
                        KtSourceElement source;
                        if (parameter.getSource() == null) continue;
                        if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), null, 8, null);
                        } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), null, 8, null);
                        }
                        if (parameter.getHasDefaultValue() && !FirConstChecksKt.canBeEvaluatedAtCompileTime(parameter.getResolvedDefaultValue(), context2.getSession(), true, true)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter.getDefaultValueSource(), FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), null, 8, null);
                        }
                        FirResolvedTypeRef typeRef = parameter.getResolvedReturnTypeRef();
                        ConeKotlinType coneType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, typeRef.getConeType());
                        ClassId classId = ConeTypeUtilsKt.getClassId(coneType);
                        if (coneType instanceof ConeErrorType) continue;
                        if (ConeTypeUtilsKt.isMarkedNullable(coneType)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), null, 8, null);
                            continue;
                        }
                        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(coneType) || ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(coneType) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().values(), classId)) continue;
                        if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getArray())) {
                            if (!this.isAllowedArray(coneType, context2.getSession())) {
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), null, 8, null);
                                continue;
                            }
                            if (parameter.isVararg()) continue;
                            ConeTypeProjection coneTypeProjection = ArraysKt.firstOrNull(coneType.getTypeArguments());
                            if ((coneTypeProjection != null ? ConeTypeProjectionKt.getVariance(coneTypeProjection) : null) == Variance.INVARIANT) continue;
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getPROJECTION_IN_TYPE_OF_ANNOTATION_MEMBER(), null, 8, null);
                            continue;
                        }
                        if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), null, 8, null);
                    }
                    break block13;
                }
                if (member instanceof FirRegularClassSymbol) break block13;
                if (!(member instanceof FirPropertySymbol)) break block14;
                KtSourceElement ktSourceElement = ((FirPropertySymbol)member).getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.VALUE_PARAMETER)) break block13;
            }
            if (!(member instanceof FirNamedFunctionSymbol) || !((FirNamedFunctionSymbol)member).isSynthetic()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), null, 8, null);
            }
        }
    }

    private final boolean isAllowedClassKind(ConeKotlinType cone, FirSession session) {
        ClassKind classKind;
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(cone, session);
        if (firRegularClassSymbol == null || (classKind = firRegularClassSymbol.getClassKind()) == null) {
            return false;
        }
        ClassKind typeRefClassKind = classKind;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(ConeKotlinType type, FirSession session) {
        ConeTypeProjection[] typeArguments = type.getTypeArguments();
        if (typeArguments.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments[0];
        ConeKotlinTypeProjection coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
        if (coneKotlinTypeProjection == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null || (coneKotlinTypeProjection = TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)coneKotlinTypeProjection, session, null, 2, null)) == null) {
            return false;
        }
        ConeKotlinTypeProjection arrayType = coneKotlinTypeProjection;
        if (ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)arrayType);
        if (Intrinsics.areEqual(arrayTypeClassId, StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual(arrayTypeClassId, StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)arrayType, session);
    }

    private final void checkCyclesInParameters(CheckerContext context2, DiagnosticReporter reporter, FirRegularClassSymbol annotation) {
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(annotation, context2.getSession());
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol primaryConstructor = firConstructorSymbol;
        CycleChecker checker = new CycleChecker(annotation, context2.getSession());
        for (FirValueParameterSymbol valueParameter2 : primaryConstructor.getValueParameterSymbols()) {
            if (!checker.parameterHasCycle(annotation, valueParameter2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getCYCLE_IN_ANNOTATION_PARAMETER(), null, 8, null);
        }
    }

    private static final Unit check$lambda$0(CheckerContext $context, DiagnosticReporter $reporter, FirBasedSymbol member) {
        Intrinsics.checkNotNullParameter(member, "member");
        INSTANCE.checkAnnotationClassMember($context, $reporter, member);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker;", "", "targetAnnotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getTargetAnnotation", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitedAnnotations", "", "annotationsWithCycle", "annotationHasCycle", "", "annotation", "parameterHasCycle", "ownedAnnotation", "parameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "typeHasCycle", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirAnnotationClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,247:1\n1#2:248\n250#3:249\n241#3,11:250\n*S KotlinDebug\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker\n*L\n240#1:249\n240#1:250,11\n*E\n"})
    private static final class CycleChecker {
        @NotNull
        private final FirRegularClassSymbol targetAnnotation;
        @NotNull
        private final FirSession session;
        @NotNull
        private final Set<FirRegularClassSymbol> visitedAnnotations;
        @NotNull
        private final Set<FirRegularClassSymbol> annotationsWithCycle;

        public CycleChecker(@NotNull FirRegularClassSymbol targetAnnotation, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter(targetAnnotation, "targetAnnotation");
            Intrinsics.checkNotNullParameter(session, "session");
            this.targetAnnotation = targetAnnotation;
            this.session = session;
            FirRegularClassSymbol[] firRegularClassSymbolArray = new FirRegularClassSymbol[]{this.targetAnnotation};
            this.visitedAnnotations = SetsKt.mutableSetOf(firRegularClassSymbolArray);
            firRegularClassSymbolArray = new FirRegularClassSymbol[]{this.targetAnnotation};
            this.annotationsWithCycle = SetsKt.mutableSetOf(firRegularClassSymbolArray);
        }

        @NotNull
        public final FirRegularClassSymbol getTargetAnnotation() {
            return this.targetAnnotation;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        public final boolean annotationHasCycle(@NotNull FirRegularClassSymbol annotation) {
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(annotation, this.session);
            if (firConstructorSymbol == null) {
                return false;
            }
            FirConstructorSymbol primaryConstructor = firConstructorSymbol;
            for (FirValueParameterSymbol valueParameter2 : primaryConstructor.getValueParameterSymbols()) {
                if (!this.parameterHasCycle(annotation, valueParameter2)) continue;
                return true;
            }
            return false;
        }

        public final boolean parameterHasCycle(@NotNull FirRegularClassSymbol ownedAnnotation, @NotNull FirValueParameterSymbol parameter) {
            boolean bl;
            Intrinsics.checkNotNullParameter(ownedAnnotation, "ownedAnnotation");
            Intrinsics.checkNotNullParameter(parameter, "parameter");
            ConeKotlinType returnType = TypeExpansionUtilsKt.fullyExpandedType$default(parameter.getResolvedReturnTypeRef().getConeType(), this.session, null, 2, null);
            if (parameter.isVararg() || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray(returnType)) {
                bl = false;
            } else if (!(returnType.getTypeArguments().length == 0)) {
                if (Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(returnType), StandardClassIds.INSTANCE.getKClass())) {
                    return false;
                }
                for (ConeTypeProjection argument : returnType.getTypeArguments()) {
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(argument);
                    if (coneKotlinType == null || !this.typeHasCycle(ownedAnnotation, coneKotlinType)) continue;
                    return true;
                }
                bl = false;
            } else {
                bl = this.typeHasCycle(ownedAnnotation, returnType);
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean typeHasCycle(@NotNull FirRegularClassSymbol ownedAnnotation, @NotNull ConeKotlinType type) {
            boolean bl;
            FirRegularClassSymbol firRegularClassSymbol;
            Intrinsics.checkNotNullParameter(ownedAnnotation, "ownedAnnotation");
            Intrinsics.checkNotNullParameter(type, "type");
            FirRegularClassSymbol firRegularClassSymbol2 = ToSymbolUtilsKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type, this.session, null, 2, null), this.session);
            if (firRegularClassSymbol2 == null) return false;
            FirRegularClassSymbol it = firRegularClassSymbol = firRegularClassSymbol2;
            boolean bl2 = false;
            if (it.getClassKind() != ClassKind.ANNOTATION_CLASS) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            FirRegularClassSymbol firRegularClassSymbol3 = firRegularClassSymbol;
            FirRegularClassSymbol firRegularClassSymbol4 = firRegularClassSymbol3;
            if (firRegularClassSymbol4 == null) return false;
            FirRegularClassSymbol referencedAnnotation = firRegularClassSymbol4;
            if (!this.visitedAnnotations.add(referencedAnnotation)) {
                boolean bl4;
                boolean it2 = bl4 = this.annotationsWithCycle.contains(referencedAnnotation);
                boolean bl5 = false;
                if (!it2) return bl4;
                ((Collection)this.annotationsWithCycle).add(ownedAnnotation);
                return bl4;
            }
            if (Intrinsics.areEqual(referencedAnnotation, this.targetAnnotation)) {
                ((Collection)this.annotationsWithCycle).add(ownedAnnotation);
                return true;
            }
            FirBasedSymbol $this$isJavaOrEnhancement$iv = referencedAnnotation;
            boolean $i$f$isJavaOrEnhancement = false;
            FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
            boolean $i$f$isJavaOrEnhancement2 = false;
            if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java) return false;
            if (Intrinsics.areEqual($this$isJavaOrEnhancement$iv$iv, FirDeclarationOrigin.Enhancement.INSTANCE)) {
                return false;
            }
            boolean bl6 = false;
            if (bl6) return false;
            Object e2 = $this$isJavaOrEnhancement$iv.getFir();
            Object object = e2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)e2 : null;
            if (object != null && (object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object)) != null && (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) != null) {
                if (DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return false;
            }
            boolean bl7 = false;
            if (!bl7) return this.annotationHasCycle(referencedAnnotation);
            return false;
        }
    }
}

