/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.extensions.KotlinJvmDebuggerFacade;
import org.jetbrains.plugins.gradle.service.execution.GradleGroovyUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinCoroutineDebugGradleTaskManagerExtension;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "<init>", "()V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "Companion", "kotlin.gradle.gradle-java"})
public final class KotlinCoroutineDebugGradleTaskManagerExtension
implements GradleTaskManagerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String MIN_SUPPORTED_GRADLE_VERSION = "4.6";
    @NotNull
    private static final String KOTLIN_COROUTINE_DEBUG_SCRIPT_NAME = "ijKotlinCoroutineJvmDebugInit";

    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        try {
            KotlinJvmDebuggerFacade kotlinJvmDebuggerFacade = KotlinJvmDebuggerFacade.Companion.getInstance();
            boolean bl = kotlinJvmDebuggerFacade != null ? kotlinJvmDebuggerFacade.isCoroutineAgentAllowedInDebug() : false;
            if (bl && gradleVersion != null && GradleVersionUtil.isGradleAtLeast((GradleVersion)gradleVersion, (String)MIN_SUPPORTED_GRADLE_VERSION)) {
                String[] stringArray = new String[2];
                stringArray[0] = GradleInitScriptUtil.loadToolingExtensionProvidingInitScript((Set)GradleInitScriptUtil.GRADLE_TOOLING_EXTENSION_CLASSES);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEBUG_PROPERTY_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral((String)"kotlinx.coroutines.debug")), TuplesKt.to((Object)"DEBUG_PROPERTY_VALUE_OFF", (Object)GradleGroovyUtil.toGroovyStringLiteral((String)"off"))};
                stringArray[1] = GradleInitScriptUtil.loadInitScript(this.getClass(), (String)"/org/jetbrains/kotlin/idea/gradle/debugging/KotlinCoroutineJvmDebugInit.gradle", (Map)MapsKt.mapOf((Pair[])pairArray));
                String initScript = GradleInitScriptUtil.joinInitScripts((String[])stringArray);
                settings2.addInitScript(KOTLIN_COROUTINE_DEBUG_SCRIPT_NAME, initScript);
            }
        }
        catch (Exception e) {
            LOG.error("Gradle: not possible to attach a coroutine debugger agent.", (Throwable)e);
        }
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinCoroutineDebugGradleTaskManagerExtension$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MIN_SUPPORTED_GRADLE_VERSION", "", "KOTLIN_COROUTINE_DEBUG_SCRIPT_NAME", "kotlin.gradle.gradle-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

