/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.statistics;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.ProfilerTabComponentNameWithId;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/statistics/FusAwareMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "componentId", "Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseReleased", "logPopupInvoked", "intellij.profiler.common"})
public final class FusAwareMouseAdapter
extends MouseAdapter {
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerTabComponentNameWithId componentId;

    public FusAwareMouseAdapter(@NotNull Project project, @NotNull ProfilerTabComponentNameWithId componentId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        this.project = project;
        this.componentId = componentId;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logPopupInvoked(e);
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logPopupInvoked(e);
    }

    private final void logPopupInvoked(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_CONTEXT_MENU, this.componentId, null, 8, null);
    }
}

