/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingThrowExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingThrowExpressionFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_THROW_STATEMENT)) {
            ASTNode expression = BasicJavaAstTreeUtil.getExpression(astNode);
            if (expression != null) {
                int expressionLine = MissingThrowExpressionFixer.startLine(editor, expression);
                if (MissingThrowExpressionFixer.startLine(editor, astNode) == expressionLine) {
                    return;
                }
                if (editor.getDocument().getLineNumber(editor.getCaretModel().getOffset()) == expressionLine) {
                    return;
                }
            }
            int startOffset = astNode.getTextRange().getStartOffset();
            if (expression != null) {
                editor.getDocument().insertString(startOffset + "throw".length(), (CharSequence)";");
            }
            processor.registerUnresolvedError(startOffset + "throw".length());
        }
    }

    private static int startLine(Editor editor, @NotNull ASTNode psiElement) {
        if (psiElement == null) {
            MissingThrowExpressionFixer.$$$reportNull$$$0(1);
        }
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MissingThrowExpressionFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

