/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.MavenLog;

public final class JarUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadProperties(@NotNull Path file2, @NotNull String entryName) {
        if (file2 == null) {
            JarUtils.$$$reportNull$$$0(0);
        }
        if (entryName == null) {
            JarUtils.$$$reportNull$$$0(1);
        }
        if (!Files.isReadable(file2)) return null;
        try (JBZipFile zipFile = new JBZipFile(file2.toFile(), true);){
            JBZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) return null;
            Properties properties = new Properties();
            properties.load(entry.getInputStream());
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            MavenLog.LOG.debug((Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJarAttribute(Path file2, String entryName, Attributes.Name attribute) {
        if (!Files.isReadable(file2)) return null;
        try (JBZipFile zipFile = new JBZipFile(file2.toFile(), true);){
            JBZipEntry entry;
            Iterator iterator = zipFile.getEntries().iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!"META-INF/MANIFEST.MF".equals((entry = (JBZipEntry)iterator.next()).getName()));
            Manifest manifest = new Manifest(entry.getInputStream());
            Attributes attributes = entryName != null ? manifest.getAttributes(entryName) : manifest.getMainAttributes();
            String string = attributes.getValue(attribute);
            return string;
        }
        catch (IOException e) {
            MavenLog.LOG.debug((Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "entryName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/utils/JarUtils";
        objectArray[2] = "loadProperties";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

