/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.debugger.PyDebugValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueCustomizer;", "", "<init>", "()V", "customize", "", "value", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getTextForValue", "", "PANDAS_DATA_FRAME_CLASS_FQN", "PANDAS_SERIES_CLASS_FQN", "NUMPY_TABLE_CLASS_FQN", "PYTHON_LIST_CLASS_FQN", "intellij.jupyter.py"})
public final class JupyterInlineValueCustomizer {
    @NotNull
    public static final JupyterInlineValueCustomizer INSTANCE = new JupyterInlineValueCustomizer();
    @NotNull
    private static final String PANDAS_DATA_FRAME_CLASS_FQN = "pandas.core.frame.DataFrame";
    @NotNull
    private static final String PANDAS_SERIES_CLASS_FQN = "pandas.core.series.Series";
    @NotNull
    private static final String NUMPY_TABLE_CLASS_FQN = "numpy.ndarray";
    @NotNull
    private static final String PYTHON_LIST_CLASS_FQN = "builtins.list";

    private JupyterInlineValueCustomizer() {
    }

    public final void customize(@NotNull PyDebugValue value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List list = value.getValueNodes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueNodes(...)");
            Object object = CollectionsKt.first((List)list);
            XValueNodeImpl xValueNodeImpl = object instanceof XValueNodeImpl ? (XValueNodeImpl)object : null;
            if (xValueNodeImpl == null) {
                return;
            }
            XValueNodeImpl valueNode = xValueNodeImpl;
            String string = this.getTextForValue(value);
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            valueNode.setPresentation(valueNode.getIcon(), null, it, value.isContainer());
        }
    }

    @Nullable
    public final String getTextForValue(@NotNull PyDebugValue value) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value.getQualifiedType();
            if (string == null) break block20;
            int n = -1;
            switch (string.hashCode()) {
                case -2089015000: {
                    if (string.equals(PANDAS_DATA_FRAME_CLASS_FQN)) {
                        n = 1;
                    }
                    break;
                }
                case -304952300: {
                    if (string.equals(PANDAS_SERIES_CLASS_FQN)) {
                        n = 2;
                    }
                    break;
                }
                case 1877739396: {
                    if (string.equals(NUMPY_TABLE_CLASS_FQN)) {
                        n = 3;
                    }
                    break;
                }
                case 1063616284: {
                    if (string.equals(PYTHON_LIST_CLASS_FQN)) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return "pandas DataFrame " + value.getShape();
                }
                case 2: {
                    return "pandas Series " + value.getShape();
                }
                case 3: {
                    return "ndarray " + value.getShape();
                }
                case 4: {
                    return "list (" + value.getShape() + ")";
                }
            }
        }
        String string = value.getQualifiedType();
        if (string == null) {
            return null;
        }
        String qualifiedType = string;
        if (StringsKt.startsWith$default((String)qualifiedType, (String)"polars", (boolean)false, (int)2, null)) {
            if (StringsKt.endsWith$default((String)qualifiedType, (String)"DataFrame", (boolean)false, (int)2, null)) {
                return "polars DataFrame " + value.getShape();
            }
            if (StringsKt.endsWith$default((String)qualifiedType, (String)"Series", (boolean)false, (int)2, null)) {
                return "polars Series " + value.getShape();
            }
        }
        return null;
    }
}

