/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole;

import com.intellij.execution.filters.Filter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookFileRenameListener;
import com.intellij.jupyter.core.editor.NotebookFileRenamedEvent;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterRestartKernelListener;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStopped;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerToolWindowKt;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleHistoryEditorProvider;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.run.PythonTracebackFilter;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 52\u00020\u0001:\u000245B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u0014J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0001J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J \u0010-\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0012\u00100\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u00101\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u0007H\u0002J\b\u00103\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u00066"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "isToolWindowListenersInit", "", "lastNotebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getLastNotebookVirtualFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "setLastNotebookVirtualFile", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "consoles", "", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "consoleEditors", "Lcom/intellij/openapi/editor/Editor;", "getConsoleEditors", "()Ljava/util/Map;", "consoleFileToRealVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "realVirtualFiles", "getRealVirtualFiles", "getConsoleView", "notebookFile", "showConsoleViewContent", "", "project", "Lcom/intellij/openapi/project/Project;", "showAndFocusConsoleView", "consoleView", "removeConsoleViewContent", "requestFocus", "showToolwindowIfInactive", "getRealVirtualFileByConsoleFile", "virtualFile", "createConsoleHistoryEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "disposable", "listenForFileRenameChanges", "handleConsoleRename", "event", "Lcom/intellij/jupyter/core/editor/NotebookFileRenamedEvent;", "addToolWindowListeners", "createContent", "createConsoleView", "title", "", "removeConsoleView", "addServerStateListener", "file", "dispose", "JupyterConsoleContentManagerListener", "Companion", "intellij.jupyter.py"})
public final class JupyterConsoleService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isToolWindowListenersInit;
    @Nullable
    private BackedNotebookVirtualFile lastNotebookVirtualFile;
    @NotNull
    private final Map<BackedNotebookVirtualFile, JupyterConsoleView> consoles = new HashMap();
    @NotNull
    private final Map<BackedNotebookVirtualFile, Editor> consoleEditors = new HashMap();
    @NotNull
    private final Map<VirtualFile, BackedNotebookVirtualFile> consoleFileToRealVirtualFile = new HashMap();
    @NotNull
    private final Map<BackedNotebookVirtualFile, BackedNotebookVirtualFile> realVirtualFiles = new HashMap();
    @NotNull
    private static final String TEMP_FILE_NAME_PREFIX = "jupyterConsole";
    @NotNull
    private static final String TEMP_FILE_NAME_EXTENSION = ".ipynb";

    public JupyterConsoleService() {
        this.listenForFileRenameChanges();
    }

    @Nullable
    public final BackedNotebookVirtualFile getLastNotebookVirtualFile() {
        return this.lastNotebookVirtualFile;
    }

    public final void setLastNotebookVirtualFile(@Nullable BackedNotebookVirtualFile backedNotebookVirtualFile) {
        this.lastNotebookVirtualFile = backedNotebookVirtualFile;
    }

    @NotNull
    public final Map<BackedNotebookVirtualFile, Editor> getConsoleEditors() {
        return this.consoleEditors;
    }

    @NotNull
    public final Map<BackedNotebookVirtualFile, BackedNotebookVirtualFile> getRealVirtualFiles() {
        return this.realVirtualFiles;
    }

    @Nullable
    public final JupyterConsoleView getConsoleView(@Nullable BackedNotebookVirtualFile notebookFile) {
        return this.consoles.get(notebookFile);
    }

    public final void showConsoleViewContent(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Object object = JupyterFileExtensionsKt.getRelativePathFromProjectRoot((VirtualFile)notebookFile.getFile(), (Project)project);
        if (object == null || (object = object.toString()) == null) {
            String string = notebookFile.getFile().getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        Object relativePath = object;
        JupyterConsoleView jupyterConsoleView = this.consoles.get(notebookFile);
        if (jupyterConsoleView == null) {
            jupyterConsoleView = this.createConsoleView(project, (String)relativePath, notebookFile);
        }
        JupyterConsoleView consoleView = jupyterConsoleView;
        this.consoleFileToRealVirtualFile.put(consoleView.getVirtualFile(), notebookFile);
        this.createContent(project, consoleView);
        this.requestFocus(consoleView);
    }

    public final void showAndFocusConsoleView(@NotNull Project project, @NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        toolWindow.show(() -> JupyterConsoleService.showAndFocusConsoleView$lambda$0(consoleView, toolWindow, this));
    }

    public final void removeConsoleViewContent(@NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        Project project = consoleView.getProject();
        this.removeConsoleView(consoleView);
        ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        toolWindow.getContentManager().removeContent(consoleView.getContent(), true);
    }

    public final void requestFocus(@NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        IdeFocusManager.getGlobalInstance().requestFocus((Component)consoleView.getConsoleEditor().getContentComponent(), true);
    }

    public final void showToolwindowIfInactive(@NotNull Project project) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow it = toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        boolean bl = false;
        if (!it.isActive()) {
            it.show();
        }
    }

    @Nullable
    public final BackedNotebookVirtualFile getRealVirtualFileByConsoleFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.consoleFileToRealVirtualFile.get(virtualFile);
    }

    @NotNull
    public final TextEditor createConsoleHistoryEditor(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempFile(TEMP_FILE_NAME_PREFIX, TEMP_FILE_NAME_EXTENSION, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path tempFile = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(tempFile);
        if (virtualFile == null) {
            throw new IllegalStateException(("Can't find temp file " + tempFile).toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        JupyterNotebookBase emptyNotebook = JupyterFileUtils.createEmptyNotebook$default((JupyterFileUtils)JupyterFileUtils.INSTANCE, null, (int)1, null);
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.createWithNotebook(virtualFile2, (JupyterNotebook)emptyNotebook, disposable);
        NonProjectFileWritingAccessProvider.allowWriting((Iterable)CollectionsKt.listOf((Object)backedNotebookVirtualFile.getOriginFile()));
        this.realVirtualFiles.put(backedNotebookVirtualFile, notebookFile);
        backedNotebookVirtualFile.getFile().putUserData(JupyterConsoleUtil.INSTANCE.getJUPYTER_CONSOLE_KEY(), (Object)true);
        TextEditor editor = (TextEditor)new JupyterConsoleHistoryEditorProvider().createJupyterFileEditor(project, backedNotebookVirtualFile);
        backedNotebookVirtualFile.getFile().putUserData(JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY(), new WeakReference<Editor>(editor.getEditor()));
        this.consoleEditors.put(backedNotebookVirtualFile, editor.getEditor());
        return editor;
    }

    private final void removeConsoleViewContent(BackedNotebookVirtualFile notebookFile) {
        JupyterConsoleView consoleView = this.consoles.get(notebookFile);
        if (consoleView != null) {
            this.removeConsoleViewContent(consoleView);
        }
    }

    private final void listenForFileRenameChanges() {
        MessageBusConnection messageBusConnection;
        MessageBusConnection it = messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        boolean bl = false;
        it.subscribe(NotebookFileRenameListener.Companion.getNOTEBOOK_FILE_RENAMED_TOPIC(), (Object)new NotebookFileRenameListener(this){
            final /* synthetic */ JupyterConsoleService this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileRenamed(NotebookFileRenamedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JupyterConsoleService.access$handleConsoleRename(this.this$0, event);
            }
        });
        MessageBusConnection connection2 = messageBusConnection;
        Disposer.register((Disposable)this, (Disposable)((Disposable)connection2));
    }

    private final void handleConsoleRename(NotebookFileRenamedEvent event) {
        block1: {
            String string = event.getNewRelativePath();
            if (string == null) {
                string = event.getNewName();
            }
            String displayPath = string;
            JupyterConsoleView jupyterConsoleView = this.getConsoleView(event.getNotebookVirtualFile());
            if (jupyterConsoleView == null) break block1;
            jupyterConsoleView.renameConsoleTab(displayPath);
        }
    }

    private final void addToolWindowListeners(Project project) {
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        busConnection.subscribe(topic, (Object)new FileEditorManagerListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterConsoleService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void selectionChanged(FileEditorManagerEvent e) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FileEditor fileEditor = e.getNewEditor();
                    JupyterFileEditor jupyterFileEditor = fileEditor instanceof JupyterFileEditor ? (JupyterFileEditor)fileEditor : null;
                    if (jupyterFileEditor == null) {
                        return;
                    }
                    JupyterFileEditor editor = jupyterFileEditor;
                    BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(editor.getFile());
                    if (backedNotebookVirtualFile == null) {
                        return;
                    }
                    BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
                    ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.$project);
                    if (!JupyterConsoleService.access$getConsoles$p(this.this$0).containsKey(virtualFile)) break block3;
                    JupyterConsoleView view = (JupyterConsoleView)((Object)JupyterConsoleService.access$getConsoles$p(this.this$0).get(virtualFile));
                    JupyterConsoleView jupyterConsoleView = view;
                    if (jupyterConsoleView != null && (jupyterConsoleView = jupyterConsoleView.getContent()) != null) {
                        JupyterConsoleView it = jupyterConsoleView;
                        boolean bl = false;
                        toolWindow.getContentManager().setSelectedContent((Content)it);
                    }
                }
            }
        });
        this.isToolWindowListenersInit = true;
        JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project).getContentManager().addContentManagerListener(new ContentManagerListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterConsoleService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.$project);
                if (toolWindow.getContentManager().getContentCount() == 0) {
                    toolWindow.remove();
                    JupyterConsoleService.access$setToolWindowListenersInit$p(this.this$0, false);
                }
            }
        });
    }

    private final void createContent(Project project, JupyterConsoleView consoleView) {
        if (!this.isToolWindowListenersInit) {
            this.addToolWindowListeners(project);
        }
        Content content = consoleView.showPanel();
        ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        toolWindow.getContentManager().addContent(content);
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new JupyterConsoleContentManagerListener(consoleView));
        if (!toolWindow.isActive()) {
            toolWindow.show();
        }
        toolWindow.getContentManager().setSelectedContent(content);
    }

    private final JupyterConsoleView createConsoleView(Project project, String title, BackedNotebookVirtualFile notebookFile) {
        this.lastNotebookVirtualFile = notebookFile;
        JupyterConsoleView newConsoleView = new JupyterConsoleView(project, title, notebookFile);
        this.consoles.put(notebookFile, newConsoleView);
        this.addServerStateListener(project, notebookFile);
        MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect();
        connection2.subscribe(JupyterRestartKernelListener.Companion.getTOPIC(), arg_0 -> JupyterConsoleService.createConsoleView$lambda$3(this, arg_0));
        newConsoleView.setBorder((Border)new SideBorder(JBColor.border(), 1));
        newConsoleView.addMessageFilter((Filter)new PythonTracebackFilter(project));
        JupyterConsoleView jupyterConsoleView = this.consoles.get(notebookFile);
        Intrinsics.checkNotNull((Object)((Object)jupyterConsoleView));
        return jupyterConsoleView;
    }

    private final void removeConsoleView(JupyterConsoleView consoleView) {
        if (consoleView == null) {
            return;
        }
        this.consoleFileToRealVirtualFile.remove(consoleView.getVirtualFile());
        this.consoles.remove(consoleView.getRealNotebookVirtualFile());
        BackedNotebookVirtualFile tempFile = consoleView.getTempNotebookVirtualFile();
        TypeIntrinsics.asMutableMap(this.realVirtualFiles).remove(tempFile);
        TypeIntrinsics.asMutableMap(this.consoleEditors).remove(tempFile);
        Disposer.dispose((Disposable)((Disposable)consoleView));
    }

    private final void addServerStateListener(Project project, BackedNotebookVirtualFile file) {
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = JupyterRuntimeService.Companion.getInstance(project).getRuntime(file.getFile());
        if (jupyterNotebookRuntimeSettings == null) {
            return;
        }
        JupyterNotebookRuntimeSettings settings = jupyterNotebookRuntimeSettings;
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings2 = settings;
        if (!(jupyterNotebookRuntimeSettings2 instanceof JupyterNotebookOfflineSettings) && !(jupyterNotebookRuntimeSettings2 instanceof JupyterNotebookSessionSettings)) {
            if (jupyterNotebookRuntimeSettings2 instanceof ManagedJupyterServerNotebookSessionSettings) {
                ((ManagedJupyterServerNotebookSessionSettings)settings).getJupyterServerExecution().addStateListener(arg_0 -> JupyterConsoleService.addServerStateListener$lambda$5(this, file, arg_0));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void dispose() {
        this.consoles.clear();
        this.consoleEditors.clear();
        this.consoleFileToRealVirtualFile.clear();
        this.realVirtualFiles.clear();
    }

    private static final void showAndFocusConsoleView$lambda$0(JupyterConsoleView $consoleView, ToolWindow $toolWindow, JupyterConsoleService this$0) {
        Content content = $consoleView.getContent();
        $toolWindow.getContentManager().setSelectedContent(content);
        this$0.requestFocus($consoleView);
    }

    private static final void createConsoleView$lambda$3(JupyterConsoleService this$0, BackedNotebookVirtualFile nf) {
        Intrinsics.checkNotNullParameter((Object)nf, (String)"nf");
        this$0.removeConsoleViewContent(nf);
    }

    private static final void addServerStateListener$lambda$5$lambda$4(JupyterConsoleService this$0, JupyterConsoleView $consoleView) {
        this$0.removeConsoleViewContent($consoleView);
    }

    private static final void addServerStateListener$lambda$5(JupyterConsoleService this$0, BackedNotebookVirtualFile $file, JupyterServerState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!(newState instanceof JupyterServerFinished) && !(newState instanceof JupyterServerStopped)) {
            return;
        }
        JupyterConsoleView jupyterConsoleView = this$0.consoles.get($file);
        if (jupyterConsoleView == null) {
            return;
        }
        JupyterConsoleView consoleView = jupyterConsoleView;
        ApplicationManager.getApplication().invokeLater(() -> JupyterConsoleService.addServerStateListener$lambda$5$lambda$4(this$0, consoleView), ModalityState.defaultModalityState());
    }

    public static final /* synthetic */ Map access$getConsoles$p(JupyterConsoleService $this) {
        return $this.consoles;
    }

    public static final /* synthetic */ void access$setToolWindowListenersInit$p(JupyterConsoleService $this, boolean bl) {
        $this.isToolWindowListenersInit = bl;
    }

    public static final /* synthetic */ void access$handleConsoleRename(JupyterConsoleService $this, NotebookFileRenamedEvent event) {
        $this.handleConsoleRename(event);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$Companion;", "", "<init>", "()V", "TEMP_FILE_NAME_PREFIX", "", "TEMP_FILE_NAME_EXTENSION", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$JupyterConsoleContentManagerListener;", "Lcom/intellij/ui/content/ContentManagerListener;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "contentRemoved", "", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "intellij.jupyter.py"})
    private final class JupyterConsoleContentManagerListener
    implements ContentManagerListener {
        @NotNull
        private final JupyterConsoleView consoleView;

        public JupyterConsoleContentManagerListener(JupyterConsoleView consoleView) {
            Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
            this.consoleView = consoleView;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getContent().getDisplayName().equals(this.consoleView.getTitle())) {
                JupyterConsoleService.this.removeConsoleView(this.consoleView);
            }
        }
    }
}

