/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.GenerateMainFunctionCallsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetector;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetectorKt;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/GenerateMainFunctionWrappers;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.wasm"})
public final class GenerateMainFunctionWrappers
implements ModuleLoweringPass {
    @NotNull
    private final WasmBackendContext backendContext;

    public GenerateMainFunctionWrappers(@NotNull WasmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        this.backendContext = backendContext;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        IrSimpleFunction irSimpleFunction = new JsMainFunctionDetector(this.backendContext).getMainFunctionOrNull(irModule);
        if (irSimpleFunction == null) {
            return;
        }
        IrSimpleFunction mainFunction = irSimpleFunction;
        IrValueParameter irValueParameter = CollectionsKt.firstOrNull(mainFunction.getParameters());
        boolean generateArgv = irValueParameter != null ? JsMainFunctionDetectorKt.isStringArrayParameter(irValueParameter) : false;
        boolean generateContinuation = JsMainFunctionDetectorKt.isLoweredSuspendFunction(mainFunction, this.backendContext);
        if (!generateArgv && !generateContinuation) {
            this.backendContext.getFileContext(IrUtilsKt.getFile(mainFunction)).setMainFunctionWrapper(mainFunction);
            return;
        }
        IrSimpleFunction wrapper = this.backendContext.getIrFactory().getStageController().restrictTo(mainFunction, () -> GenerateMainFunctionWrappers.lower$lambda$0(mainFunction, this, generateArgv, generateContinuation));
        this.backendContext.getFileContext(IrUtilsKt.getFile(mainFunction)).setMainFunctionWrapper(wrapper);
    }

    private static final IrSimpleFunction lower$lambda$0(IrSimpleFunction $mainFunction, GenerateMainFunctionWrappers this$0, boolean $generateArgv, boolean $generateContinuation) {
        return GenerateMainFunctionCallsKt.access$createMainFunctionWrapper($mainFunction, this$0.backendContext, $generateArgv, $generateContinuation);
    }
}

