/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.declarativedsl.analysis.AnalysisScopeView;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.LocalValueAssignment;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.gradle.internal.declarativedsl.language.LocalValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\nH\u0016R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/AnalysisScope;", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisScopeView;", "previousScopeView", "receiver", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$ReceiverOrigin;", "syntacticEnclosure", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "(Lorg/gradle/internal/declarativedsl/analysis/AnalysisScopeView;Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$ReceiverOrigin;Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;)V", "ownLocals", "", "", "Lorg/gradle/internal/declarativedsl/analysis/LocalValueAssignment;", "getOwnLocals", "()Ljava/util/Map;", "ownLocalsByName", "", "getReceiver", "()Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$ReceiverOrigin;", "getSyntacticEnclosure", "()Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "declareLocal", "", "localValue", "Lorg/gradle/internal/declarativedsl/language/LocalValue;", "assignedObjectOrigin", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "reportError", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "findLocal", "name", "declarative-dsl-core"})
public final class AnalysisScope
implements AnalysisScopeView {
    @Nullable
    private final AnalysisScopeView previousScopeView;
    @NotNull
    private final ObjectOrigin.ReceiverOrigin receiver;
    @NotNull
    private final LanguageTreeElement syntacticEnclosure;
    @NotNull
    private final Map<String, LocalValueAssignment> ownLocalsByName;

    public AnalysisScope(@Nullable AnalysisScopeView previousScopeView, @NotNull ObjectOrigin.ReceiverOrigin receiver, @NotNull LanguageTreeElement syntacticEnclosure) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)syntacticEnclosure, (String)"syntacticEnclosure");
        this.previousScopeView = previousScopeView;
        this.receiver = receiver;
        this.syntacticEnclosure = syntacticEnclosure;
        this.ownLocalsByName = new LinkedHashMap();
    }

    @Override
    @NotNull
    public ObjectOrigin.ReceiverOrigin getReceiver() {
        return this.receiver;
    }

    @Override
    @NotNull
    public LanguageTreeElement getSyntacticEnclosure() {
        return this.syntacticEnclosure;
    }

    @Override
    @NotNull
    public Map<String, LocalValueAssignment> getOwnLocals() {
        return this.ownLocalsByName;
    }

    @Override
    @Nullable
    public LocalValueAssignment findLocal(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LocalValueAssignment localValueAssignment = this.ownLocalsByName.get(name);
        if (localValueAssignment == null) {
            AnalysisScopeView analysisScopeView = this.previousScopeView;
            localValueAssignment = analysisScopeView != null ? analysisScopeView.findLocal(name) : null;
        }
        return localValueAssignment;
    }

    public final void declareLocal(@NotNull LocalValue localValue2, @NotNull ObjectOrigin assignedObjectOrigin, @NotNull ErrorCollector reportError) {
        Intrinsics.checkNotNullParameter((Object)localValue2, (String)"localValue");
        Intrinsics.checkNotNullParameter((Object)assignedObjectOrigin, (String)"assignedObjectOrigin");
        Intrinsics.checkNotNullParameter((Object)reportError, (String)"reportError");
        String name = localValue2.getName();
        if (this.ownLocalsByName.containsKey(name)) {
            reportError.collect(new ResolutionError(localValue2, new ErrorReason.DuplicateLocalValue(name)));
        }
        this.ownLocalsByName.put(name, new LocalValueAssignment(localValue2, assignedObjectOrigin));
    }
}

