/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public abstract class AbstractComponentGraphResolveState<T extends ComponentGraphResolveMetadata>
implements ComponentGraphResolveState,
ComponentArtifactResolveState {
    private final long instanceId;
    private final T graphMetadata;
    private final AttributeDesugaring attributeDesugaring;

    public AbstractComponentGraphResolveState(long instanceId, T graphMetadata, AttributeDesugaring attributeDesugaring) {
        this.instanceId = instanceId;
        this.graphMetadata = graphMetadata;
        this.attributeDesugaring = attributeDesugaring;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.graphMetadata.getId();
    }

    public T getMetadata() {
        return this.graphMetadata;
    }

    @Override
    public boolean isAdHoc() {
        return false;
    }

    protected AttributeDesugaring getAttributeDesugaring() {
        return this.attributeDesugaring;
    }

    @Override
    @Nullable
    public ComponentGraphResolveState maybeAsLenientPlatform(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return null;
    }

    @Override
    public ComponentArtifactResolveState prepareForArtifactResolution() {
        return this;
    }

    @Override
    public void resolveArtifactsWithType(ArtifactResolver artifactResolver, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        artifactResolver.resolveArtifactsWithType(this.getArtifactMetadata(), artifactType, result);
    }

    protected ImmutableCapabilities capabilitiesFor(ImmutableCapabilities capabilities) {
        if (capabilities.asSet().isEmpty()) {
            return ImmutableCapabilities.of((Capability)DefaultImmutableCapability.defaultCapabilityForComponent(this.getMetadata().getModuleVersionId()));
        }
        return capabilities;
    }

    protected static abstract class AbstractVariantGraphResolveState
    implements VariantGraphResolveState {
        private final Lazy<ResolvedVariantResult> publicView = Lazy.locking().of(() -> this.createVariantResult(null));
        private final AbstractComponentGraphResolveState<?> component;

        public AbstractVariantGraphResolveState(AbstractComponentGraphResolveState<?> component) {
            this.component = component;
        }

        @Override
        public boolean isAdHoc() {
            return this.component.isAdHoc();
        }

        @Override
        public ResolvedVariantResult getVariantResult(@Nullable ResolvedVariantResult externalVariant) {
            if (externalVariant != null) {
                return this.createVariantResult(externalVariant);
            }
            return (ResolvedVariantResult)this.publicView.get();
        }

        private DefaultResolvedVariantResult createVariantResult(@Nullable ResolvedVariantResult externalVariant) {
            VariantGraphResolveMetadata metadata = this.getMetadata();
            return new DefaultResolvedVariantResult(this.component.getId(), Describables.of((Object)metadata.getName()), (AttributeContainer)((AbstractComponentGraphResolveState)this.component).attributeDesugaring.desugar(metadata.getAttributes()), this.component.capabilitiesFor(metadata.getCapabilities()), externalVariant);
        }
    }
}

