/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Named;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.ComponentWithCoordinates;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.provider.MergeProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.DependencyCoordinateResolverFactory;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.metadata.ComponentData;
import org.gradle.api.publish.internal.metadata.InvalidPublicationChecker;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;

public class ModuleMetadataSpecBuilder {
    private final PublicationInternal<?> publication;
    private final ModuleVersionIdentifier publicationCoordinates;
    private final Provider<SoftwareComponentInternal> component;
    private final Collection<? extends PublicationInternal<?>> publications;
    private final Map<SoftwareComponent, ComponentData> componentCoordinates = new HashMap<SoftwareComponent, ComponentData>();
    private final DependencyCoordinateResolverFactory dependencyCoordinateResolverFactory;
    private final InvalidPublicationChecker checker;

    public ModuleMetadataSpecBuilder(PublicationInternal<?> publication, Collection<? extends PublicationInternal<?>> publications, InvalidPublicationChecker checker, DependencyCoordinateResolverFactory dependencyCoordinateResolverFactory) {
        this.component = publication.getComponent();
        this.publicationCoordinates = publication.getCoordinates();
        this.publication = publication;
        this.publications = publications;
        this.checker = checker;
        this.dependencyCoordinateResolverFactory = dependencyCoordinateResolverFactory;
        this.collectCoordinates(this.componentCoordinates);
    }

    public Provider<ModuleMetadataSpec> build() {
        return this.variants().map(variants -> new ModuleMetadataSpec(this.identity(), (List<ModuleMetadataSpec.Variant>)variants, this.publication.isPublishBuildId()));
    }

    private ModuleMetadataSpec.Identity identity() {
        HashMap<SoftwareComponent, SoftwareComponent> owners = new HashMap<SoftwareComponent, SoftwareComponent>();
        ModuleMetadataSpecBuilder.collectOwners(this.publications, owners);
        SoftwareComponent owner = (SoftwareComponent)owners.get(this.component.get());
        ComponentData ownerData = owner == null ? null : this.componentCoordinates.get(owner);
        ComponentData componentData = new ComponentData(this.publication.getCoordinates(), this.publication.getAttributes());
        return ownerData != null ? this.identityFor(ownerData, ModuleMetadataSpecBuilder.relativeUrlTo(componentData.coordinates, ownerData.coordinates)) : this.identityFor(componentData, null);
    }

    private ModuleMetadataSpec.Identity identityFor(ComponentData componentData, String relativeUrl) {
        return new ModuleMetadataSpec.Identity(componentData.coordinates, this.attributesFor((AttributeContainer)componentData.attributes), relativeUrl);
    }

    private Provider<List<ModuleMetadataSpec.Variant>> variants() {
        ArrayList<Object> variants = new ArrayList<Object>();
        SoftwareComponentInternal softwareComponent = (SoftwareComponentInternal)this.component.get();
        VersionMappingStrategyInternal versionMappingStrategy = this.publication.getVersionMappingStrategy();
        this.checker.checkComponent((SoftwareComponent)softwareComponent);
        for (SoftwareComponentVariant variant : softwareComponent.getUsages()) {
            this.checkVariant(variant);
            variants.add(this.dependencyCoordinateResolverFactory.createCoordinateResolvers(variant, versionMappingStrategy).map(resolvers -> new ModuleMetadataSpec.LocalVariant(variant.getName(), this.attributesFor(variant.getAttributes()), this.capabilitiesFor(variant.getCapabilities()), this.dependenciesOf(variant, resolvers.getComponentResolver()), this.dependencyConstraintsFor(variant, resolvers.getComponentResolver()), this.artifactsOf(variant))));
        }
        if (softwareComponent instanceof ComponentWithVariants) {
            for (SoftwareComponent childComponent : ((ComponentWithVariants)softwareComponent).getVariants()) {
                this.checker.checkComponent(childComponent);
                ModuleVersionIdentifier childCoordinates = this.coordinatesOf(childComponent);
                assert (childCoordinates != null);
                if (!(childComponent instanceof SoftwareComponentInternal)) continue;
                for (SoftwareComponentVariant variant : ((SoftwareComponentInternal)childComponent).getUsages()) {
                    this.checkVariant(variant);
                    variants.add(Providers.of((Object)new ModuleMetadataSpec.RemoteVariant(variant.getName(), this.attributesFor(variant.getAttributes()), this.availableAt(this.publicationCoordinates, childCoordinates), this.capabilitiesFor(variant.getCapabilities()))));
                }
            }
        }
        return new MergeProvider(variants);
    }

    private List<ModuleMetadataSpec.Artifact> artifactsOf(SoftwareComponentVariant variant) {
        if (variant.getArtifacts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Artifact> artifacts = new ArrayList<ModuleMetadataSpec.Artifact>();
        for (PublishArtifact artifact : variant.getArtifacts()) {
            ModuleMetadataSpec.Artifact metadataArtifact = this.artifactFor(artifact);
            if (metadataArtifact == null) continue;
            artifacts.add(metadataArtifact);
        }
        return artifacts;
    }

    @Nullable
    private ModuleMetadataSpec.Artifact artifactFor(PublishArtifact artifact) {
        if (this.shouldNotBePublished(artifact)) {
            return null;
        }
        PublicationInternal.PublishedFile publishedFile = this.publication.getPublishedFile(artifact);
        return new ModuleMetadataSpec.Artifact(publishedFile.getName(), publishedFile.getUri(), artifact.getFile());
    }

    private boolean shouldNotBePublished(PublishArtifact artifact) {
        return !PublishArtifactInternal.shouldBePublished((PublishArtifact)artifact);
    }

    private ModuleMetadataSpec.AvailableAt availableAt(ModuleVersionIdentifier coordinates, ModuleVersionIdentifier targetCoordinates) {
        if (coordinates.getModule().equals(targetCoordinates.getModule())) {
            throw new InvalidUserCodeException("Cannot have a remote variant with coordinates '" + targetCoordinates.getModule() + "' that are the same as the module itself.");
        }
        return new ModuleMetadataSpec.AvailableAt(ModuleMetadataSpecBuilder.relativeUrlTo(coordinates, targetCoordinates), targetCoordinates);
    }

    private ModuleMetadataSpec.Dependency dependencyFor(ModuleDependency dependency, Set<ExcludeRule> additionalExcludes, ComponentDependencyResolver dependencyResolver, DependencyArtifact dependencyArtifact, String variant) {
        return new ModuleMetadataSpec.Dependency(this.dependencyCoordinatesFor(dependency, dependencyResolver), this.excludedRulesFor(dependency, additionalExcludes), this.dependencyAttributesFor(variant, dependency.getGroup(), dependency.getName(), dependency.getAttributes()), this.capabilitiesFor(dependency.getRequestedCapabilities()), dependency.isEndorsingStrictVersions(), StringUtils.isNotEmpty((String)dependency.getReason()) ? dependency.getReason() : null, dependencyArtifact != null ? this.artifactSelectorFor(dependencyArtifact) : null);
    }

    private ModuleMetadataSpec.DependencyConstraint dependencyConstraintFor(DependencyConstraint dependencyConstraint, ComponentDependencyResolver dependencyResolver, String variant) {
        return new ModuleMetadataSpec.DependencyConstraint(this.dependencyConstraintCoordinatesFor(dependencyConstraint, dependencyResolver), this.dependencyAttributesFor(variant, dependencyConstraint.getGroup(), dependencyConstraint.getName(), dependencyConstraint.getAttributes()), StringUtils.isNotEmpty((String)dependencyConstraint.getReason()) ? dependencyConstraint.getReason() : null);
    }

    private ModuleMetadataSpec.DependencyCoordinates dependencyCoordinatesFor(ModuleDependency dependency, ComponentDependencyResolver resolver) {
        if (dependency instanceof ProjectDependency) {
            ResolvedCoordinates identifier = resolver.resolveComponentCoordinates((ProjectDependency)dependency);
            return this.projectDependencyCoordinatesFor(identifier);
        }
        if (dependency instanceof ExternalDependency) {
            ResolvedCoordinates identifier = resolver.resolveComponentCoordinates((ExternalDependency)dependency);
            if (identifier == null) {
                identifier = ResolvedCoordinates.create(dependency.getGroup(), dependency.getName(), null);
            }
            return this.moduleDependencyCoordinatesFor(identifier, ((ExternalDependency)dependency).getVersionConstraint());
        }
        throw new UnsupportedOperationException("Unsupported dependency type: " + dependency.getClass().getName());
    }

    private ModuleMetadataSpec.DependencyCoordinates dependencyConstraintCoordinatesFor(DependencyConstraint dependencyConstraint, ComponentDependencyResolver resolver) {
        if (dependencyConstraint instanceof DefaultProjectDependencyConstraint) {
            ResolvedCoordinates identifier = resolver.resolveComponentCoordinates((DefaultProjectDependencyConstraint)dependencyConstraint);
            return this.projectDependencyCoordinatesFor(identifier);
        }
        ResolvedCoordinates identifier = resolver.resolveComponentCoordinates(dependencyConstraint);
        if (identifier == null) {
            identifier = ResolvedCoordinates.create(dependencyConstraint.getGroup(), dependencyConstraint.getName(), null);
        }
        return this.moduleDependencyCoordinatesFor(identifier, dependencyConstraint.getVersionConstraint());
    }

    private ModuleMetadataSpec.DependencyCoordinates moduleDependencyCoordinatesFor(ResolvedCoordinates identifier, VersionConstraint dependencyConstraint) {
        ImmutableVersionConstraint constraint = DefaultImmutableVersionConstraint.of((VersionConstraint)dependencyConstraint);
        ModuleMetadataSpec.Version version = this.versionFor(constraint, identifier.getVersion());
        return new ModuleMetadataSpec.DependencyCoordinates(identifier.getGroup(), identifier.getName(), version);
    }

    private ModuleMetadataSpec.DependencyCoordinates projectDependencyCoordinatesFor(ResolvedCoordinates identifier) {
        ImmutableVersionConstraint constraint = DefaultImmutableVersionConstraint.of((String)identifier.getVersion());
        ModuleMetadataSpec.Version version = this.versionFor(constraint, identifier.getVersion());
        return new ModuleMetadataSpec.DependencyCoordinates(identifier.getGroup(), identifier.getName(), version);
    }

    private ModuleMetadataSpec.ArtifactSelector artifactSelectorFor(DependencyArtifact dependencyArtifact) {
        return new ModuleMetadataSpec.ArtifactSelector(dependencyArtifact.getName(), dependencyArtifact.getType(), dependencyArtifact.getExtension() == null ? dependencyArtifact.getType() : dependencyArtifact.getExtension(), Strings.isNullOrEmpty((String)dependencyArtifact.getClassifier()) ? null : dependencyArtifact.getClassifier());
    }

    private List<ModuleMetadataSpec.Capability> capabilitiesFor(Collection<? extends Capability> capabilities) {
        if (capabilities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Capability> metadataCapabilities = new ArrayList<ModuleMetadataSpec.Capability>();
        for (Capability capability : capabilities) {
            metadataCapabilities.add(new ModuleMetadataSpec.Capability(capability.getGroup(), capability.getName(), StringUtils.isNotEmpty((String)capability.getVersion()) ? capability.getVersion() : null));
        }
        return metadataCapabilities;
    }

    private List<ModuleMetadataSpec.Attribute> attributesFor(AttributeContainer attributes) {
        if (attributes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Attribute> metadataAttributes = new ArrayList<ModuleMetadataSpec.Attribute>();
        for (Attribute<?> attribute : this.sorted(attributes).values()) {
            String name = attribute.getName();
            Object value = attributes.getAttribute(attribute);
            Object effectiveValue = this.attributeValueFor(value);
            if (effectiveValue == null) {
                throw new IllegalArgumentException(String.format("Cannot write attribute %s with unsupported value %s of type %s.", name, value, value.getClass().getName()));
            }
            metadataAttributes.add(new ModuleMetadataSpec.Attribute(name, effectiveValue));
        }
        return metadataAttributes;
    }

    private List<ModuleMetadataSpec.Attribute> dependencyAttributesFor(String variant, String group, String name, AttributeContainer attributes) {
        this.checker.validateAttributes(variant, group, name, attributes);
        return this.attributesFor(attributes);
    }

    private Object attributeValueFor(Object value) {
        if (value instanceof Boolean || value instanceof Integer || value instanceof String) {
            return value;
        }
        if (value instanceof Named) {
            return ((Named)value).getName();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return null;
    }

    private List<ModuleMetadataSpec.Dependency> dependenciesOf(SoftwareComponentVariant variant, ComponentDependencyResolver dependencyResolver) {
        if (variant.getDependencies().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Dependency> dependencies = new ArrayList<ModuleMetadataSpec.Dependency>();
        Set additionalExcludes = variant.getGlobalExcludes();
        for (ModuleDependency moduleDependency : variant.getDependencies()) {
            if (moduleDependency.getArtifacts().isEmpty()) {
                dependencies.add(this.dependencyFor(moduleDependency, additionalExcludes, dependencyResolver, null, variant.getName()));
                continue;
            }
            for (DependencyArtifact dependencyArtifact : moduleDependency.getArtifacts()) {
                dependencies.add(this.dependencyFor(moduleDependency, additionalExcludes, dependencyResolver, dependencyArtifact, variant.getName()));
            }
        }
        return dependencies;
    }

    private List<ModuleMetadataSpec.DependencyConstraint> dependencyConstraintsFor(SoftwareComponentVariant variant, ComponentDependencyResolver dependencyResolver) {
        if (variant.getDependencyConstraints().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.DependencyConstraint> dependencyConstraints = new ArrayList<ModuleMetadataSpec.DependencyConstraint>();
        for (DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
            dependencyConstraints.add(this.dependencyConstraintFor(dependencyConstraint, dependencyResolver, variant.getName()));
        }
        return dependencyConstraints;
    }

    @Nullable
    private ModuleMetadataSpec.Version versionFor(ImmutableVersionConstraint versionConstraint, @Nullable String resolvedVersion) {
        String preferred;
        String version;
        boolean isStrict;
        this.checker.sawDependencyOrConstraint();
        if (resolvedVersion == null && this.isEmpty(versionConstraint)) {
            return null;
        }
        this.checker.sawVersion();
        boolean bl = isStrict = !versionConstraint.getStrictVersion().isEmpty();
        if (resolvedVersion != null) {
            version = resolvedVersion;
            preferred = null;
        } else {
            version = isStrict ? versionConstraint.getStrictVersion() : (!versionConstraint.getRequiredVersion().isEmpty() ? versionConstraint.getRequiredVersion() : null);
            preferred = !versionConstraint.getPreferredVersion().isEmpty() ? versionConstraint.getPreferredVersion() : null;
        }
        return new ModuleMetadataSpec.Version(version, isStrict ? version : null, preferred, versionConstraint.getRejectedVersions());
    }

    private static void collectOwners(Collection<? extends PublicationInternal<?>> publications, Map<SoftwareComponent, SoftwareComponent> owners) {
        for (PublicationInternal<?> publication : publications) {
            SoftwareComponent component = (SoftwareComponent)publication.getComponent().getOrNull();
            if (!(component instanceof ComponentWithVariants)) continue;
            ComponentWithVariants componentWithVariants = (ComponentWithVariants)component;
            for (SoftwareComponent child : componentWithVariants.getVariants()) {
                owners.put(child, component);
            }
        }
    }

    private void collectCoordinates(Map<SoftwareComponent, ComponentData> coordinates) {
        for (PublicationInternal<?> publication : this.publications) {
            SoftwareComponentInternal component = (SoftwareComponentInternal)publication.getComponent().getOrNull();
            if (component == null) continue;
            coordinates.put((SoftwareComponent)component, new ComponentData(publication.getCoordinates(), publication.getAttributes()));
        }
    }

    private void checkVariant(SoftwareComponentVariant variant) {
        this.checker.registerVariant(variant.getName(), variant.getAttributes(), variant.getCapabilities());
    }

    private Set<ExcludeRule> excludedRulesFor(ModuleDependency moduleDependency, Set<ExcludeRule> additionalExcludes) {
        return moduleDependency.isTransitive() ? Sets.union(additionalExcludes, (Set)moduleDependency.getExcludeRules()) : Collections.singleton(new DefaultExcludeRule(null, null));
    }

    private Map<String, Attribute<?>> sorted(AttributeContainer attributes) {
        TreeMap sortedAttributes = new TreeMap();
        for (Attribute attribute : attributes.keySet()) {
            sortedAttributes.put(attribute.getName(), attribute);
        }
        return sortedAttributes;
    }

    private ModuleVersionIdentifier coordinatesOf(SoftwareComponent childComponent) {
        if (childComponent instanceof ComponentWithCoordinates) {
            return ((ComponentWithCoordinates)childComponent).getCoordinates();
        }
        ComponentData componentData = this.componentCoordinates.get(childComponent);
        if (componentData != null) {
            return componentData.coordinates;
        }
        return null;
    }

    private boolean isEmpty(ImmutableVersionConstraint versionConstraint) {
        return DefaultImmutableVersionConstraint.of().equals(versionConstraint);
    }

    public static String relativeUrlTo(ModuleVersionIdentifier from, ModuleVersionIdentifier to) {
        StringBuilder path = new StringBuilder();
        path.append("../../");
        path.append(to.getName());
        path.append("/");
        path.append(to.getVersion());
        path.append("/");
        path.append(to.getName());
        path.append("-");
        path.append(to.getVersion());
        path.append(".module");
        return path.toString();
    }
}

