/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NetworkRequestHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.FreeColServerHolder;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Element;

public abstract class InputHandler
extends FreeColServerHolder
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(InputHandler.class.getName());
    private final Map<String, NetworkRequestHandler> _handlerMap = Collections.synchronizedMap(new HashMap());

    public InputHandler(FreeColServer freeColServer) {
        super(freeColServer);
        this.register("logout", (connection, element) -> this.logout(connection, element));
        this.register("disconnect", new DisconnectHandler());
        this.register("chat", (connection, element) -> new ChatMessage(this.getGame(), element).handle(freeColServer, connection));
    }

    protected final void register(String name, NetworkRequestHandler handler) {
        this._handlerMap.put(name, handler);
    }

    protected final boolean unregister(String name, NetworkRequestHandler handler) {
        return this._handlerMap.remove(name) == handler;
    }

    @Override
    public final Element handle(Connection connection, Element element) {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        NetworkRequestHandler handler = this._handlerMap.get(tagName);
        if (handler != null) {
            try {
                logger.log(Level.FINEST, "Handling " + tagName);
                return handler.handle(connection, element);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Handler failed", e);
                this.sendReconnectSafely(connection);
            }
        } else {
            logger.warning("No handler installed for " + tagName);
        }
        return null;
    }

    private void sendReconnectSafely(Connection connection) {
        try {
            connection.send(DOMMessage.createMessage("reconnect", new String[0]));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send reconnect message!", e);
        }
    }

    protected Element createErrorReply(String message) {
        return DOMMessage.createMessage("error", "message", message);
    }

    protected abstract Element logout(Connection var1, Element var2);

    private class DisconnectHandler
    implements NetworkRequestHandler {
        private DisconnectHandler() {
        }

        @Override
        public Element handle(Connection connection, Element disconnectElement) {
            ServerPlayer player = InputHandler.this.getFreeColServer().getPlayer(connection);
            this.logDisconnect(connection, player);
            if (player != null && player.isConnected()) {
                InputHandler.this.logout(connection, null);
            }
            connection.reallyClose();
            Server server = InputHandler.this.getFreeColServer().getServer();
            if (server != null) {
                server.removeConnection(connection);
            }
            return null;
        }

        private void logDisconnect(Connection connection, ServerPlayer player) {
            logger.info("Disconnection by: " + connection + (player != null ? " (" + player.getName() + ") " : ""));
        }
    }
}

