/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MemoryUsageMonitorEntry
extends MonitorEntry {
    static final String MEMORY_USAGE_MONITOR_OC = "ds-memory-usage-monitor-entry";
    private static final String ATTR_LONGEST_PAUSE_TIME = "max-detected-pause-time-millis";
    private static final String ATTR_NON_HEAP_USED = "non-heap-memory-bytes-used";
    private static final String ATTR_TOTAL_CONSUMER_MEMORY = "total-bytes-used-by-memory-consumers";
    private static final String ATTR_TOTAL_CONSUMER_MEMORY_AS_PCT_OF_COMMITTED = "memory-consumers-total-as-percent-of-committed-tenured-memory";
    private static final String ATTR_TOTAL_CONSUMER_MEMORY_AS_PCT_OF_MAX = "memory-consumers-total-as-percent-of-maximum-tenured-memory";
    private static final String ATTR_PREFIX_DETECTED_PAUSE = "detected-pauses-over-";
    private static final String ATTR_SUFFIX_TOTAL_COLLECTION_COUNT = "-total-collection-count";
    private static final String ATTR_SUFFIX_TOTAL_COLLECTION_DURATION = "-total-collection-duration";
    private static final String ATTR_SUFFIX_AVERAGE_COLLECTION_DURATION = "-average-collection-duration";
    private static final String ATTR_SUFFIX_RECENT_COLLECTION_DURATION = "-recent-collection-duration";
    private static final String ATTR_SUFFIX_CURRENT_BYTES_USED = "-current-bytes-used";
    private static final String ATTR_SUFFIX_BYTES_USED_AFTER_LAST_COLLECTION = "-bytes-used-after-last-collection";
    private static final String PROPERTY_DETECTED_PAUSE_COUNTS = "detected-pause-counts";
    private static final String ATTR_MAX_RESERVABLE_MEMORY_MB = "maxReservableMemoryMB";
    private static final String ATTR_CURRENT_RESERVED_MEMORY_MB = "currentReservedMemoryMB";
    private static final String ATTR_USED_MEMORY_MB = "usedReservedMemoryMB";
    private static final String ATTR_FREE_MEMORY_MB = "freeReservedMemoryMB";
    private static final String ATTR_RESERVED_MEMORY_PERCENT_FULL = "reservedMemoryPercentFull";
    private static final long serialVersionUID = 1924052253885937441L;
    private final List<String> garbageCollectors;
    private final List<String> memoryPools;
    private final Long currentReservedMemoryMB;
    private final Long freeReservedMemoryMB;
    private final Long maxDetectedPauseTime = this.getLong("max-detected-pause-time-millis");
    private final Long maxReservableMemoryMB;
    private final Long nonHeapMemoryUsed = this.getLong("non-heap-memory-bytes-used");
    private final Long percentOfCommittedTenuredMemory;
    private final Long percentOfMaxTenuredMemory;
    private final Long reservedMemoryPercentFull;
    private final Long totalBytesHeldByConsumers = this.getLong("total-bytes-used-by-memory-consumers");
    private final Long usedReservedMemoryMB;
    private final Map<Long, Long> detectedPauses;
    private final Map<String, Long> bytesUsedAfterLastCollectionPerMP;
    private final Map<String, Long> currentBytesUsedPerMP;
    private final Map<String, Long> averageCollectionDurationPerGC;
    private final Map<String, Long> recentCollectionDurationPerGC;
    private final Map<String, Long> totalCollectionCountPerGC;
    private final Map<String, Long> totalCollectionDurationPerGC;

    public MemoryUsageMonitorEntry(Entry entry) {
        super(entry);
        this.percentOfCommittedTenuredMemory = this.getLong(ATTR_TOTAL_CONSUMER_MEMORY_AS_PCT_OF_COMMITTED);
        this.percentOfMaxTenuredMemory = this.getLong(ATTR_TOTAL_CONSUMER_MEMORY_AS_PCT_OF_MAX);
        this.maxReservableMemoryMB = this.getLong(ATTR_MAX_RESERVABLE_MEMORY_MB);
        this.currentReservedMemoryMB = this.getLong(ATTR_CURRENT_RESERVED_MEMORY_MB);
        this.usedReservedMemoryMB = this.getLong(ATTR_USED_MEMORY_MB);
        this.freeReservedMemoryMB = this.getLong(ATTR_FREE_MEMORY_MB);
        this.reservedMemoryPercentFull = this.getLong(ATTR_RESERVED_MEMORY_PERCENT_FULL);
        TreeMap<Long, Long> pauses = new TreeMap<Long, Long>();
        TreeSet<String> mpNames = new TreeSet<String>();
        TreeSet<String> gcNames = new TreeSet<String>();
        TreeMap<String, Long> averageDurations = new TreeMap<String, Long>();
        TreeMap<String, Long> currentBytesUsed = new TreeMap<String, Long>();
        TreeMap<String, Long> lastBytesUsed = new TreeMap<String, Long>();
        TreeMap<String, Long> recentDurations = new TreeMap<String, Long>();
        TreeMap<String, Long> totalCounts = new TreeMap<String, Long>();
        TreeMap<String, Long> totalDurations = new TreeMap<String, Long>();
        for (Attribute a : entry.getAttributes()) {
            String mpName;
            String gcName;
            int pos;
            String name = a.getName();
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.startsWith(ATTR_PREFIX_DETECTED_PAUSE)) {
                Long l = this.getLong(name);
                String timeStr = lowerName.substring(ATTR_PREFIX_DETECTED_PAUSE.length());
                if (timeStr.endsWith("ms")) {
                    try {
                        long millis = Long.parseLong(timeStr.substring(0, timeStr.length() - 2));
                        pauses.put(millis, l);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                } else if (timeStr.endsWith("s")) {
                    try {
                        long millis = 1000L * Long.parseLong(timeStr.substring(0, timeStr.length() - 1));
                        pauses.put(millis, l);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
            if ((pos = lowerName.indexOf(ATTR_SUFFIX_AVERAGE_COLLECTION_DURATION)) > 0) {
                gcName = name.substring(0, pos);
                gcNames.add(gcName);
                Long l = this.getLong(name);
                if (l == null) continue;
                averageDurations.put(StaticUtils.toLowerCase(gcName), l);
                continue;
            }
            pos = lowerName.indexOf(ATTR_SUFFIX_BYTES_USED_AFTER_LAST_COLLECTION);
            if (pos > 0) {
                mpName = name.substring(0, pos);
                mpNames.add(mpName);
                Long l = this.getLong(name);
                if (l == null) continue;
                lastBytesUsed.put(StaticUtils.toLowerCase(mpName), l);
                continue;
            }
            pos = lowerName.indexOf(ATTR_SUFFIX_CURRENT_BYTES_USED);
            if (pos > 0) {
                mpName = name.substring(0, pos);
                mpNames.add(mpName);
                Long l = this.getLong(name);
                if (l == null) continue;
                currentBytesUsed.put(StaticUtils.toLowerCase(mpName), l);
                continue;
            }
            pos = lowerName.indexOf(ATTR_SUFFIX_RECENT_COLLECTION_DURATION);
            if (pos > 0) {
                gcName = name.substring(0, pos);
                gcNames.add(gcName);
                Long l = this.getLong(name);
                if (l == null) continue;
                recentDurations.put(StaticUtils.toLowerCase(gcName), l);
                continue;
            }
            pos = lowerName.indexOf(ATTR_SUFFIX_TOTAL_COLLECTION_COUNT);
            if (pos > 0 && !lowerName.startsWith("mem-pool-")) {
                gcName = name.substring(0, pos);
                gcNames.add(gcName);
                Long l = this.getLong(name);
                if (l == null) continue;
                totalCounts.put(StaticUtils.toLowerCase(gcName), l);
                continue;
            }
            pos = lowerName.indexOf(ATTR_SUFFIX_TOTAL_COLLECTION_DURATION);
            if (pos <= 0) continue;
            gcName = name.substring(0, pos);
            gcNames.add(gcName);
            Long l = this.getLong(name);
            if (l == null) continue;
            totalDurations.put(StaticUtils.toLowerCase(gcName), l);
        }
        this.garbageCollectors = Collections.unmodifiableList(new ArrayList(gcNames));
        this.memoryPools = Collections.unmodifiableList(new ArrayList(mpNames));
        this.totalCollectionCountPerGC = Collections.unmodifiableMap(totalCounts);
        this.totalCollectionDurationPerGC = Collections.unmodifiableMap(totalDurations);
        this.averageCollectionDurationPerGC = Collections.unmodifiableMap(averageDurations);
        this.recentCollectionDurationPerGC = Collections.unmodifiableMap(recentDurations);
        this.bytesUsedAfterLastCollectionPerMP = Collections.unmodifiableMap(lastBytesUsed);
        this.currentBytesUsedPerMP = Collections.unmodifiableMap(currentBytesUsed);
        this.detectedPauses = Collections.unmodifiableMap(pauses);
    }

    public Long getMaxReservableMemoryMB() {
        return this.maxReservableMemoryMB;
    }

    public Long getCurrentReservedMemoryMB() {
        return this.currentReservedMemoryMB;
    }

    public Long getUsedReservedMemoryMB() {
        return this.usedReservedMemoryMB;
    }

    public Long getFreeReservedMemoryMB() {
        return this.freeReservedMemoryMB;
    }

    public Long getReservedMemoryPercentFull() {
        return this.reservedMemoryPercentFull;
    }

    public List<String> getGarbageCollectorNames() {
        return this.garbageCollectors;
    }

    public List<String> getMemoryPoolNames() {
        return this.memoryPools;
    }

    public Map<String, Long> getTotalCollectionCounts() {
        return this.totalCollectionCountPerGC;
    }

    public Long getTotalCollectionCount(String collectorName) {
        return this.totalCollectionCountPerGC.get(StaticUtils.toLowerCase(collectorName));
    }

    public Map<String, Long> getTotalCollectionDurations() {
        return this.totalCollectionDurationPerGC;
    }

    public Long getTotalCollectionDuration(String collectorName) {
        return this.totalCollectionDurationPerGC.get(StaticUtils.toLowerCase(collectorName));
    }

    public Map<String, Long> getAverageCollectionDurations() {
        return this.averageCollectionDurationPerGC;
    }

    public Long getAverageCollectionDuration(String collectorName) {
        return this.averageCollectionDurationPerGC.get(StaticUtils.toLowerCase(collectorName));
    }

    public Map<String, Long> getRecentCollectionDurations() {
        return this.recentCollectionDurationPerGC;
    }

    public Long getRecentCollectionDuration(String collectorName) {
        return this.recentCollectionDurationPerGC.get(StaticUtils.toLowerCase(collectorName));
    }

    public Map<String, Long> getCurrentBytesUsed() {
        return this.currentBytesUsedPerMP;
    }

    public Long getCurrentBytesUsed(String poolName) {
        return this.currentBytesUsedPerMP.get(StaticUtils.toLowerCase(poolName));
    }

    public Map<String, Long> getBytesUsedAfterLastCollection() {
        return this.bytesUsedAfterLastCollectionPerMP;
    }

    public Long getBytesUsedAfterLastCollection(String poolName) {
        return this.bytesUsedAfterLastCollectionPerMP.get(StaticUtils.toLowerCase(poolName));
    }

    public Long getNonHeapMemoryBytesUsed() {
        return this.nonHeapMemoryUsed;
    }

    public Long getTotalBytesUsedByMemoryConsumers() {
        return this.totalBytesHeldByConsumers;
    }

    public Long getPercentageOfMaximumTenuredMemoryUsedByMemoryConsumers() {
        return this.percentOfMaxTenuredMemory;
    }

    public Long getPercentageOfCommittedTenuredMemoryUsedByMemoryConsumers() {
        return this.percentOfCommittedTenuredMemory;
    }

    public Map<Long, Long> getDetectedPauseCounts() {
        return this.detectedPauses;
    }

    public Long getMaxDetectedPauseTimeMillis() {
        return this.maxDetectedPauseTime;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_MEMORY_USAGE_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_MEMORY_USAGE_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(50);
        if (this.maxReservableMemoryMB != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_RESERVABLE_MEMORY_MB, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_MAX_MEM.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_MAX_MEM.get(), this.maxReservableMemoryMB);
        }
        if (this.currentReservedMemoryMB != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_RESERVED_MEMORY_MB, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_CURRENT_MEM.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_CURRENT_MEM.get(), this.currentReservedMemoryMB);
        }
        if (this.usedReservedMemoryMB != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_USED_MEMORY_MB, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_USED_MEM.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_USED_MEM.get(), this.usedReservedMemoryMB);
        }
        if (this.freeReservedMemoryMB != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_FREE_MEMORY_MB, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_FREE_MEM.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_FREE_MEM.get(), this.freeReservedMemoryMB);
        }
        if (this.reservedMemoryPercentFull != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_RESERVED_MEMORY_PERCENT_FULL, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_RESERVED_PCT.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_RESERVED_PCT.get(), this.reservedMemoryPercentFull);
        }
        if (!this.garbageCollectors.isEmpty()) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "gcNames", MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_GC_NAMES.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_GC_NAMES.get(), this.garbageCollectors);
        }
        if (!this.totalCollectionCountPerGC.isEmpty()) {
            for (String name : this.totalCollectionCountPerGC.keySet()) {
                MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "totalCollectionCount-" + name, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_TOTAL_COLLECTION_COUNT.get(name), MonitorMessages.INFO_MEMORY_USAGE_DESC_TOTAL_COLLECTION_COUNT.get(name), this.totalCollectionCountPerGC.get(name));
            }
        }
        if (!this.totalCollectionDurationPerGC.isEmpty()) {
            for (String name : this.totalCollectionDurationPerGC.keySet()) {
                MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "totalCollectionDuration-" + name, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_TOTAL_COLLECTION_DURATION.get(name), MonitorMessages.INFO_MEMORY_USAGE_DESC_TOTAL_COLLECTION_DURATION.get(name), this.totalCollectionDurationPerGC.get(name));
            }
        }
        if (!this.averageCollectionDurationPerGC.isEmpty()) {
            for (String name : this.averageCollectionDurationPerGC.keySet()) {
                MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "averageCollectionDuration-" + name, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_AVERAGE_COLLECTION_DURATION.get(name), MonitorMessages.INFO_MEMORY_USAGE_DESC_AVERAGE_COLLECTION_DURATION.get(name), this.averageCollectionDurationPerGC.get(name));
            }
        }
        if (!this.recentCollectionDurationPerGC.isEmpty()) {
            for (String name : this.recentCollectionDurationPerGC.keySet()) {
                MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "recentCollectionDuration-" + name, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_RECENT_COLLECTION_DURATION.get(name), MonitorMessages.INFO_MEMORY_USAGE_DESC_RECENT_COLLECTION_DURATION.get(name), this.recentCollectionDurationPerGC.get(name));
            }
        }
        if (!this.memoryPools.isEmpty()) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "memoryPools", MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_MEMORY_POOLS.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_MEMORY_POOLS.get(), this.memoryPools);
        }
        if (!this.currentBytesUsedPerMP.isEmpty()) {
            for (String name : this.currentBytesUsedPerMP.keySet()) {
                MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "currentBytesUsed-" + name, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_CURRENT_BYTES_USED.get(name), MonitorMessages.INFO_MEMORY_USAGE_DESC_CURRENT_BYTES_USED.get(name), this.currentBytesUsedPerMP.get(name));
            }
        }
        if (!this.bytesUsedAfterLastCollectionPerMP.isEmpty()) {
            for (String name : this.bytesUsedAfterLastCollectionPerMP.keySet()) {
                MemoryUsageMonitorEntry.addMonitorAttribute(attrs, "bytesUsedAfterLastCollection-" + name, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_BYTES_USED_AFTER_COLLECTION.get(name), MonitorMessages.INFO_MEMORY_USAGE_DESC_BYTES_USED_AFTER_COLLECTION.get(name), this.bytesUsedAfterLastCollectionPerMP.get(name));
            }
        }
        if (this.nonHeapMemoryUsed != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_NON_HEAP_USED, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_NON_HEAP_MEMORY.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_NON_HEAP_MEMORY.get(), this.nonHeapMemoryUsed);
        }
        if (this.totalBytesHeldByConsumers != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_CONSUMER_MEMORY, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_TOTAL_CONSUMER_MEMORY.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_TOTAL_CONSUMER_MEMORY.get(), this.totalBytesHeldByConsumers);
        }
        if (this.percentOfMaxTenuredMemory != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_CONSUMER_MEMORY_AS_PCT_OF_MAX, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_CONSUMERS_AS_PCT_OF_MAX.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_CONSUMERS_AS_PCT_OF_MAX.get(), this.percentOfMaxTenuredMemory);
        }
        if (this.percentOfCommittedTenuredMemory != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_CONSUMER_MEMORY_AS_PCT_OF_COMMITTED, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_CONSUMERS_AS_PCT_OF_COMMITTED.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_CONSUMERS_AS_PCT_OF_COMMITTED.get(), this.percentOfCommittedTenuredMemory);
        }
        if (!this.detectedPauses.isEmpty()) {
            ArrayList<String> values = new ArrayList<String>(this.detectedPauses.size());
            for (Map.Entry<Long, Long> e : this.detectedPauses.entrySet()) {
                values.add(e.getKey() + "ms=" + e.getValue());
            }
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, PROPERTY_DETECTED_PAUSE_COUNTS, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_DETECTED_PAUSES.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_DETECTED_PAUSES.get(), values);
        }
        if (this.maxDetectedPauseTime != null) {
            MemoryUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_LONGEST_PAUSE_TIME, MonitorMessages.INFO_MEMORY_USAGE_DISPNAME_MAX_PAUSE_TIME.get(), MonitorMessages.INFO_MEMORY_USAGE_DESC_MAX_PAUSE_TIME.get(), this.maxDetectedPauseTime);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

