/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.MlFilterWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ModelPlotConfigWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.ScheduledEventsWriter;
import org.elasticsearch.xpack.ml.process.writer.AbstractControlMsgWriter;
import org.elasticsearch.xpack.ml.process.writer.LengthEncodedWriter;

public class AutodetectControlMsgWriter
extends AbstractControlMsgWriter {
    private static final String FLUSH_MESSAGE_CODE = "f";
    private static final String FORECAST_MESSAGE_CODE = "p";
    private static final String INTERIM_MESSAGE_CODE = "i";
    public static final String RESET_BUCKETS_MESSAGE_CODE = "r";
    private static final String ADVANCE_TIME_MESSAGE_CODE = "t";
    private static final String SKIP_TIME_MESSAGE_CODE = "s";
    public static final String UPDATE_MESSAGE_CODE = "u";
    public static final String BACKGROUND_PERSIST_MESSAGE_CODE = "w";
    private static AtomicLong ms_FlushNumber = new AtomicLong(1L);

    public AutodetectControlMsgWriter(LengthEncodedWriter lengthEncodedWriter, int numberOfFields) {
        super(lengthEncodedWriter, numberOfFields);
    }

    public static AutodetectControlMsgWriter create(OutputStream os, int numberOfFields) {
        return new AutodetectControlMsgWriter(new LengthEncodedWriter(os), numberOfFields);
    }

    public void writeFlushControlMessage(FlushJobParams params) throws IOException {
        if (params.shouldSkipTime()) {
            this.writeMessage(SKIP_TIME_MESSAGE_CODE + params.getSkipTime());
        }
        if (params.shouldAdvanceTime()) {
            this.writeMessage(ADVANCE_TIME_MESSAGE_CODE + params.getAdvanceTime());
        }
        if (params.shouldCalculateInterim()) {
            this.writeControlCodeFollowedByTimeRange(INTERIM_MESSAGE_CODE, params.getStart(), params.getEnd());
        }
    }

    public String writeFlushMessage() throws IOException {
        String flushId = Long.toString(ms_FlushNumber.getAndIncrement());
        this.writeMessage(FLUSH_MESSAGE_CODE + flushId);
        this.fillCommandBuffer();
        this.lengthEncodedWriter.flush();
        return flushId;
    }

    public void writeForecastMessage(ForecastParams params) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.field("forecast_id", params.getForecastId());
        builder.field("create_time", params.getCreateTime());
        if (params.getDuration() != 0L) {
            builder.field("duration", params.getDuration());
        }
        if (params.getExpiresIn() != -1L) {
            builder.field("expires_in", params.getExpiresIn());
        }
        if (params.getTmpStorage() != null) {
            builder.field("tmp_storage", params.getTmpStorage());
        }
        builder.endObject();
        this.writeMessage(FORECAST_MESSAGE_CODE + Strings.toString((XContentBuilder)builder));
        this.fillCommandBuffer();
        this.lengthEncodedWriter.flush();
    }

    public void writeResetBucketsMessage(DataLoadParams params) throws IOException {
        this.writeControlCodeFollowedByTimeRange(RESET_BUCKETS_MESSAGE_CODE, params.getStart(), params.getEnd());
    }

    private void writeControlCodeFollowedByTimeRange(String code, String start, String end) throws IOException {
        StringBuilder message = new StringBuilder(code);
        if (!start.isEmpty()) {
            message.append(start);
            message.append(' ');
            message.append(end);
        }
        this.writeMessage(message.toString());
    }

    public void writeUpdateModelPlotMessage(ModelPlotConfig modelPlotConfig) throws IOException {
        StringWriter configWriter = new StringWriter();
        configWriter.append(UPDATE_MESSAGE_CODE).append("[modelPlotConfig]\n");
        new ModelPlotConfigWriter(modelPlotConfig, configWriter).write();
        this.writeMessage(configWriter.toString());
    }

    public void writeUpdateDetectorRulesMessage(int detectorIndex, List<DetectionRule> rules) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPDATE_MESSAGE_CODE).append("[detectorRules]\n");
        stringBuilder.append("detectorIndex=").append(Integer.toString(detectorIndex)).append("\n");
        stringBuilder.append("rulesJson=");
        try (XContentBuilder builder = JsonXContent.contentBuilder();){
            builder.startArray();
            for (DetectionRule rule : rules) {
                rule.toXContent(builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endArray();
            stringBuilder.append(Strings.toString((XContentBuilder)builder));
        }
        this.writeMessage(stringBuilder.toString());
    }

    public void writeUpdateFiltersMessage(List<MlFilter> filters) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPDATE_MESSAGE_CODE).append("[filters]\n");
        new MlFilterWriter(filters, stringBuilder).write();
        this.writeMessage(stringBuilder.toString());
    }

    public void writeUpdateScheduledEventsMessage(List<ScheduledEvent> events, TimeValue bucketSpan) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPDATE_MESSAGE_CODE).append("[scheduledEvents]\n");
        if (events.isEmpty()) {
            stringBuilder.append("clear = true\n");
        } else {
            new ScheduledEventsWriter(events, bucketSpan, stringBuilder).write();
        }
        this.writeMessage(stringBuilder.toString());
    }

    public void writeStartBackgroundPersistMessage() throws IOException {
        this.writeMessage(BACKGROUND_PERSIST_MESSAGE_CODE);
        this.fillCommandBuffer();
        this.lengthEncodedWriter.flush();
    }
}

