/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.CancelSpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class CancelSpotInstanceRequests
extends BaseCmd {
    public CancelSpotInstanceRequests(String[] args) {
        super("ec2csir", "ec2-cancel-spot-instance-requests");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[REQUESTID [REQUESTID ...]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Cancels one or more spot instance requests. The REQUESTID parameters are");
        System.out.println("     the IDs of the spot instance requests to cancel.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("REQUESTID");
        String[] requestIds = this.getNonOptions();
        RequestResultPair rsp = jec2.cancelSpotInstanceRequests(requestIds);
        for (CancelSpotInstanceRequestDescription desc : (List)rsp.getResponse()) {
            out.output(System.out, desc);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new CancelSpotInstanceRequests(args).invoke();
    }
}

