/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.structured.statement;

import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifier;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.scope.LValueScopeDiscoverer;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.output.Dumper;

public class StructuredIter
extends AbstractStructuredBlockStatement {
    private final BlockIdentifier block;
    private LValue iterator;
    private Expression list;
    private boolean creator;

    public StructuredIter(BlockIdentifier block, LValue iterator, Expression list, Op04StructuredStatement body) {
        super(body);
        this.block = block;
        this.iterator = iterator;
        this.list = list;
        this.creator = false;
        JavaTypeInstance itertype = iterator.getInferredJavaType().getJavaTypeInstance();
        if (!itertype.isUsableType()) {
            // empty if block
        }
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        this.iterator.collectTypeUsages(collector);
        this.list.collectTypeUsages(collector);
        super.collectTypeUsages(collector);
    }

    @Override
    public Dumper dump(Dumper dumper) {
        if (this.block.hasForeignReferences()) {
            dumper.print(this.block.getName() + " : ");
        }
        dumper.print("for (");
        if (this.iterator.isFinal()) {
            dumper.print("final ");
        }
        LValue.Creation.dump(dumper, this.iterator).print(" ");
        dumper.dump(this.iterator).print(" : ").dump(this.list).print(") ");
        this.getBody().dump(dumper);
        return dumper;
    }

    @Override
    public boolean isScopeBlock() {
        return true;
    }

    @Override
    public void linearizeInto(List<StructuredStatement> out) {
        out.add(this);
        this.getBody().linearizeStatementsInto(out);
    }

    @Override
    public BlockIdentifier getBreakableBlockOrNull() {
        return this.block;
    }

    @Override
    public boolean supportsContinueBreak() {
        return true;
    }

    @Override
    public boolean supportsBreak() {
        return true;
    }

    @Override
    public void traceLocalVariableScope(LValueScopeDiscoverer scopeDiscoverer) {
        scopeDiscoverer.enterBlock(this);
        this.list.collectUsedLValues(scopeDiscoverer);
        this.iterator.collectLValueAssignments(null, this.getContainer(), scopeDiscoverer);
        this.getBody().traceLocalVariableScope(scopeDiscoverer);
        scopeDiscoverer.leaveBlock(this);
    }

    @Override
    public void markCreator(LValue scopedEntity) {
        this.creator = true;
    }

    @Override
    public boolean alwaysDefines(LValue scopedEntity) {
        if (scopedEntity == null) {
            return false;
        }
        return scopedEntity.equals(this.iterator);
    }

    @Override
    public boolean canDefine(LValue scopedEntity) {
        if (scopedEntity == null) {
            return false;
        }
        return scopedEntity.equals(this.iterator);
    }

    @Override
    public List<LValue> findCreatedHere() {
        if (!(this.iterator instanceof LocalVariable)) {
            return null;
        }
        return ListFactory.newList(this.iterator);
    }

    @Override
    public void rewriteExpressions(ExpressionRewriter expressionRewriter) {
        this.iterator = expressionRewriter.rewriteExpression(this.iterator, null, (StatementContainer)this.getContainer(), null);
        this.list = expressionRewriter.rewriteExpression(this.list, null, (StatementContainer)this.getContainer(), null);
    }
}

