/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.cli.osgi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.apollo.broker.Broker;
import org.apache.activemq.apollo.cli.commands.Create;
import org.apache.activemq.apollo.dto.BrokerDTO;
import org.apache.activemq.apollo.dto.XmlCodec;
import org.apache.activemq.apollo.util.FileSupport$;
import org.apache.activemq.apollo.util.Log;
import org.apache.activemq.apollo.util.Service;
import org.apache.activemq.apollo.util.ServiceControl$;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.hawtdispatch.package$;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrokerService$
implements Log,
ScalaObject {
    public static final BrokerService$ MODULE$;
    private BundleContext context;
    private BrokerDTO config;
    private ConfigurationAdmin configAdmin;
    private Broker broker;
    private final Logger log;

    static {
        new BrokerService$();
    }

    public Logger log() {
        return this.log;
    }

    public void org$apache$activemq$apollo$util$Log$_setter_$log_$eq(Logger logger) {
        this.log = logger;
    }

    public void error(Function0<String> m, Seq<Object> args) {
        Log.class.error((Log)this, m, args);
    }

    public void error(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.error((Log)this, (Throwable)e, m, args);
    }

    public void error(Throwable e) {
        Log.class.error((Log)this, (Throwable)e);
    }

    public void warn(Function0<String> m, Seq<Object> args) {
        Log.class.warn((Log)this, m, args);
    }

    public void warn(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.warn((Log)this, (Throwable)e, m, args);
    }

    public void warn(Throwable e) {
        Log.class.warn((Log)this, (Throwable)e);
    }

    public void info(Function0<String> m, Seq<Object> args) {
        Log.class.info((Log)this, m, args);
    }

    public void info(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.info((Log)this, (Throwable)e, m, args);
    }

    public void info(Throwable e) {
        Log.class.info((Log)this, (Throwable)e);
    }

    public void debug(Function0<String> m, Seq<Object> args) {
        Log.class.debug((Log)this, m, args);
    }

    public void debug(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.debug((Log)this, (Throwable)e, m, args);
    }

    public void debug(Throwable e) {
        Log.class.debug((Log)this, (Throwable)e);
    }

    public void trace(Function0<String> m, Seq<Object> args) {
        Log.class.trace((Log)this, m, args);
    }

    public void trace(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.trace((Log)this, (Throwable)e, m, args);
    }

    public void trace(Throwable e) {
        Log.class.trace((Log)this, (Throwable)e);
    }

    public BundleContext context() {
        return this.context;
    }

    public void context_$eq(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public BrokerDTO config() {
        return this.config;
    }

    public void config_$eq(BrokerDTO brokerDTO) {
        this.config = brokerDTO;
    }

    public ConfigurationAdmin configAdmin() {
        return this.configAdmin;
    }

    public void configAdmin_$eq(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    public Broker broker() {
        return this.broker;
    }

    public void broker_$eq(Broker broker) {
        this.broker = broker;
    }

    public void start() {
        NonLocalReturnControl nonLocalReturnControl2;
        block6: {
            Object object = new Object();
            try {
                BrokerService$ brokerService$ = this;
                synchronized (brokerService$) {
                    this.liftedTree1$1(object);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block6;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)nonLocalReturnControl2.value();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void stop() {
        BrokerService$ brokerService$ = this;
        synchronized (brokerService$) {
            BoxedUnit boxedUnit;
            this.info((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Stopping Apollo";
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            if (this.broker() == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                ServiceControl$.MODULE$.stop((Service)this.broker(), "Apollo shutdown");
                this.info((Function0)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Apollo stopped";
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                this.broker_$eq(null);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void liftedTree1$1(Object object) {
        try {
            BrokerDTO brokerDTO;
            BoxedUnit boxedUnit;
            if (this.broker() != null) {
                this.error((Function0)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Apollo has allready been started.";
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                throw new NonLocalReturnControl(object, (Object)BoxedUnit.UNIT);
            }
            this.info((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Starting Apollo.";
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            Configuration configuration = this.configAdmin().getConfiguration("org.apache.activemq.apollo");
            ObjectRef cmProps$1 = new ObjectRef((Object)configuration.getProperties());
            File karaf_data = new File(System.getProperty("karaf.data", "."));
            ObjectRef basedir$1 = new ObjectRef((Object)new File(karaf_data, "apollo"));
            if ((Dictionary)cmProps$1.elem != null) {
                basedir$1.elem = (File)Option$.MODULE$.apply((Object)((String)((Dictionary)cmProps$1.elem).get("apollo.base"))).map((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final File apply(String string) {
                        return new File(string);
                    }
                }).getOrElse((Function0)new Serializable(basedir$1){
                    public static final long serialVersionUID;
                    private final ObjectRef basedir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final File apply() {
                        return (File)this.basedir$1.elem;
                    }
                    {
                        this.basedir$1 = objectRef;
                    }
                });
            }
            if (((File)basedir$1.elem).exists()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.info((Function0)new Serializable(basedir$1){
                    public static final long serialVersionUID;
                    private final ObjectRef basedir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Initializing apollo instance directory: ").append((Object)((File)this.basedir$1.elem)).toString();
                    }
                    {
                        this.basedir$1 = objectRef;
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                Create create = new Create();
                create.directory_$eq((File)basedir$1.elem);
                create.create_log_config_$eq(false);
                create.create_login_config_$eq(false);
                create.broker_security_config_$eq("<!-- used to secure the web admin interface -->\n  <authentication domain=\"karaf\">\n    <user_principal_kind>org.apache.karaf.jaas.modules.UserPrincipal</user_principal_kind>\n    <acl_principal_kind>org.apache.karaf.jaas.modules.RolePrincipal</acl_principal_kind>\n  </authentication>\n\n  <acl>\n    <admin allow=\"admin\"/>\n    <config allow=\"admin\"/>\n  </acl>\n  ");
                create.host_security_config_$eq("<!-- Uncomment to disable security for the virtual host -->\n    <!-- <authentication enabled=\"false\"/> -->\n    <acl>\n      <admin allow=\"admin\"/>\n      <config allow=\"admin\"/>\n    </acl>\n    ");
                create.execute(new CommandSession(){

                    public Nothing$ put(String name, Object value) {
                        throw new UnsupportedOperationException();
                    }

                    public InputStream getKeyboard() {
                        throw new UnsupportedOperationException();
                    }

                    public Object get(String name) {
                        throw new UnsupportedOperationException();
                    }

                    public CharSequence format(Object target, int level) {
                        throw new UnsupportedOperationException();
                    }

                    public Object execute(CharSequence commandline) {
                        throw new UnsupportedOperationException();
                    }

                    public Object convert(Class<?> type, Object instance) {
                        throw new UnsupportedOperationException();
                    }

                    public PrintStream getConsole() {
                        return new PrintStream(new ByteArrayOutputStream());
                    }

                    public void close() {
                    }
                });
                boxedUnit = null;
            }
            if (this.config() == null) {
                File apollo_xml$1 = FileSupport$.MODULE$.to_rich_file(FileSupport$.MODULE$.to_rich_file((File)basedir$1.elem).$div("etc")).$div("apollo.xml");
                if (!apollo_xml$1.exists()) {
                    this.error((Function0)new Serializable(apollo_xml$1){
                        public static final long serialVersionUID;
                        private final File apollo_xml$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Apollo configuration file'%s' does not exist.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.apollo_xml$1}));
                        }
                        {
                            this.apollo_xml$1 = file;
                        }
                    }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    throw new NonLocalReturnControl(object, (Object)BoxedUnit.UNIT);
                }
                this.info((Function0)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Loading configuration file '%s'.";
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apollo_xml$1}));
                Properties props$1 = new Properties();
                props$1.putAll((Map<?, ?>)System.getProperties());
                if ((Dictionary)cmProps$1.elem != null) {
                    JavaConversions$.MODULE$.dictionaryAsScalaMap((Dictionary)cmProps$1.elem).keySet().foreach((Function1)new Serializable(cmProps$1, props$1){
                        public static final long serialVersionUID;
                        private final ObjectRef cmProps$1;
                        private final Properties props$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Object apply(Object key) {
                            return this.props$1.put((String)key, (String)((Dictionary)this.cmProps$1.elem).get(key));
                        }
                        {
                            this.cmProps$1 = objectRef;
                            this.props$1 = properties;
                        }
                    });
                }
                props$1.put("apollo.base", ((File)basedir$1.elem).getCanonicalPath());
                brokerDTO = (BrokerDTO)XmlCodec.decode(BrokerDTO.class, (InputStream)new FileInputStream(apollo_xml$1), (Properties)props$1);
            } else {
                brokerDTO = this.config();
            }
            BrokerDTO dto = brokerDTO;
            this.debug((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Starting broker";
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.broker_$eq(new Broker());
            this.broker().update(dto, package$.MODULE$.NOOP());
            this.broker().tmp_$eq(FileSupport$.MODULE$.to_rich_file((File)basedir$1.elem).$div("tmp"));
            this.broker().tmp().mkdirs();
            this.broker().start(package$.MODULE$.$up((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    BrokerService$.MODULE$.info((Function0)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Apollo started";
                        }
                    }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println();
            throwable.printStackTrace();
            this.stop();
            this.error(throwable);
        }
    }

    private BrokerService$() {
        MODULE$ = this;
        Log.class.$init$((Log)this);
    }
}

