/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.uniformsplit.BlockHeader;
import org.apache.lucene.codecs.uniformsplit.BlockLine;
import org.apache.lucene.codecs.uniformsplit.DeltaBaseTermStateSerializer;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.codecs.uniformsplit.sharedterms.FieldMetadataTermState;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;

public class STBlockLine
extends BlockLine {
    protected final List<FieldMetadataTermState> termStates;

    public STBlockLine(TermBytes termBytes, List<FieldMetadataTermState> termStates) {
        super(termBytes, null);
        assert (!termStates.isEmpty());
        this.termStates = new ArrayList<FieldMetadataTermState>(termStates);
    }

    public void collectFields(Collection<FieldMetadata> collector) {
        for (FieldMetadataTermState fieldTermState : this.termStates) {
            collector.add(fieldTermState.fieldMetadata);
        }
    }

    public static class Serializer
    extends BlockLine.Serializer {
        public void writeLineTermStates(DataOutput termStatesOutput, STBlockLine line, DeltaBaseTermStateSerializer encoder) throws IOException {
            FieldMetadataTermState fieldMetadataTermState;
            int i;
            int size = line.termStates.size();
            assert (size > 0) : "not valid block line with :" + size + " lines.";
            if (size == 1) {
                int fieldID = line.termStates.get((int)0).fieldMetadata.getFieldInfo().number;
                termStatesOutput.writeZInt(-fieldID);
                FieldMetadataTermState fieldMetadataTermState2 = line.termStates.get(0);
                encoder.writeTermState(termStatesOutput, fieldMetadataTermState2.fieldMetadata.getFieldInfo(), fieldMetadataTermState2.state);
                return;
            }
            termStatesOutput.writeZInt(size);
            for (i = 0; i < size; ++i) {
                fieldMetadataTermState = line.termStates.get(i);
                termStatesOutput.writeVInt(fieldMetadataTermState.fieldMetadata.getFieldInfo().number);
            }
            for (i = 0; i < size; ++i) {
                fieldMetadataTermState = line.termStates.get(i);
                encoder.writeTermState(termStatesOutput, fieldMetadataTermState.fieldMetadata.getFieldInfo(), fieldMetadataTermState.state);
            }
        }

        public BlockTermState readTermStateForField(int fieldId, DataInput termStatesInput, DeltaBaseTermStateSerializer termStateSerializer, BlockHeader blockHeader, FieldInfos fieldInfos, BlockTermState reuse) throws IOException {
            assert (fieldId >= 0);
            int numFields = termStatesInput.readZInt();
            if (numFields <= 0) {
                int readFieldId = -numFields;
                if (fieldId == readFieldId) {
                    return termStateSerializer.readTermState(blockHeader.getBaseDocsFP(), blockHeader.getBasePositionsFP(), blockHeader.getBasePayloadsFP(), termStatesInput, fieldInfos.fieldInfo(readFieldId), reuse);
                }
                return null;
            }
            boolean isFieldInList = false;
            int[] readFieldIds = new int[numFields];
            for (int i = 0; i < numFields; ++i) {
                int readFieldId = termStatesInput.readVInt();
                if (!isFieldInList && readFieldId > fieldId) {
                    return null;
                }
                isFieldInList |= readFieldId == fieldId;
                readFieldIds[i] = readFieldId;
            }
            if (isFieldInList) {
                for (int readFieldId : readFieldIds) {
                    BlockTermState termState = termStateSerializer.readTermState(blockHeader.getBaseDocsFP(), blockHeader.getBasePositionsFP(), blockHeader.getBasePayloadsFP(), termStatesInput, fieldInfos.fieldInfo(readFieldId), reuse);
                    if (fieldId != readFieldId) continue;
                    return termState;
                }
            }
            return null;
        }

        public void readFieldTermStatesMap(DataInput termStatesInput, DeltaBaseTermStateSerializer termStateSerializer, BlockHeader blockHeader, FieldInfos fieldInfos, Map<String, BlockTermState> fieldTermStatesMap) throws IOException {
            fieldTermStatesMap.clear();
            int numFields = termStatesInput.readZInt();
            if (numFields <= 0) {
                int fieldId = -numFields;
                fieldTermStatesMap.put(fieldInfos.fieldInfo((int)fieldId).name, termStateSerializer.readTermState(blockHeader.getBaseDocsFP(), blockHeader.getBasePositionsFP(), blockHeader.getBasePayloadsFP(), termStatesInput, fieldInfos.fieldInfo(fieldId), null));
                return;
            }
            for (int fieldId : this.readFieldIds(termStatesInput, numFields)) {
                fieldTermStatesMap.put(fieldInfos.fieldInfo((int)fieldId).name, termStateSerializer.readTermState(blockHeader.getBaseDocsFP(), blockHeader.getBasePositionsFP(), blockHeader.getBasePayloadsFP(), termStatesInput, fieldInfos.fieldInfo(fieldId), null));
            }
        }

        public int[] readFieldIds(DataInput termStatesInput, int numFields) throws IOException {
            int[] fieldIds = new int[numFields];
            for (int i = 0; i < numFields; ++i) {
                fieldIds[i] = termStatesInput.readVInt();
            }
            return fieldIds;
        }
    }
}

