/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

class FilteredProjectDependencyGraph
implements ProjectDependencyGraph {
    private final ProjectDependencyGraph projectDependencyGraph;
    private final Map<MavenProject, ?> whiteList;
    private final List<MavenProject> sortedProjects;
    private final Map<Key, List<MavenProject>> cache = new ConcurrentHashMap<Key, List<MavenProject>>();

    FilteredProjectDependencyGraph(ProjectDependencyGraph projectDependencyGraph, Collection<? extends MavenProject> whiteList) {
        this.projectDependencyGraph = Objects.requireNonNull(projectDependencyGraph, "projectDependencyGraph cannot be null");
        this.whiteList = new IdentityHashMap();
        for (MavenProject mavenProject : whiteList) {
            this.whiteList.put(mavenProject, null);
        }
        this.sortedProjects = projectDependencyGraph.getSortedProjects().stream().filter(this.whiteList::containsKey).collect(Collectors.toList());
    }

    @Override
    public List<MavenProject> getAllProjects() {
        return this.projectDependencyGraph.getAllProjects();
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sortedProjects);
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        Key key = new Key(project, transitive, false);
        List<MavenProject> list = this.cache.get(key);
        if (list == null) {
            list = this.applyFilter(this.projectDependencyGraph.getDownstreamProjects(project, transitive), transitive, false);
            this.cache.put(key, list);
        }
        return list;
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        Key key = new Key(project, transitive, true);
        List<MavenProject> list = this.cache.get(key);
        if (list == null) {
            list = this.applyFilter(this.projectDependencyGraph.getUpstreamProjects(project, transitive), transitive, true);
            this.cache.put(key, list);
        }
        return list;
    }

    private List<MavenProject> applyFilter(Collection<? extends MavenProject> projects, boolean transitive, boolean upstream) {
        ArrayList<MavenProject> filtered = new ArrayList<MavenProject>(projects.size());
        for (MavenProject mavenProject : projects) {
            if (this.whiteList.containsKey(mavenProject)) {
                filtered.add(mavenProject);
                continue;
            }
            if (transitive) continue;
            filtered.addAll(upstream ? this.getUpstreamProjects(mavenProject, false) : this.getDownstreamProjects(mavenProject, false));
        }
        return filtered;
    }

    public String toString() {
        return this.getSortedProjects().toString();
    }

    private static class Key {
        private final MavenProject project;
        private final boolean transitive;
        private final boolean upstream;

        private Key(MavenProject project, boolean transitive, boolean upstream) {
            this.project = project;
            this.transitive = transitive;
            this.upstream = upstream;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.project, key.project) && this.transitive == key.transitive && this.upstream == key.upstream;
        }

        public int hashCode() {
            return Objects.hash(this.project, this.transitive, this.upstream);
        }
    }
}

