/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.conf.view;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.SSTableIndex;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.plan.Expression;

public interface TermTree {
    public Set<SSTableIndex> search(Expression var1);

    public int intervalCount();

    public static abstract class Builder {
        protected final OnDiskIndexBuilder.Mode mode;
        protected final AbstractType<?> comparator;
        protected ByteBuffer min;
        protected ByteBuffer max;

        protected Builder(OnDiskIndexBuilder.Mode mode, AbstractType<?> comparator) {
            this.mode = mode;
            this.comparator = comparator;
        }

        public final void add(SSTableIndex index) {
            this.addIndex(index);
            this.min = this.min == null || this.comparator.compare(this.min, index.minTerm()) > 0 ? index.minTerm() : this.min;
            this.max = this.max == null || this.comparator.compare(this.max, index.maxTerm()) < 0 ? index.maxTerm() : this.max;
        }

        protected abstract void addIndex(SSTableIndex var1);

        public abstract TermTree build();
    }
}

