/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class TypeCast
implements Term.Raw {
    private final CQL3Type.Raw type;
    private final Term.Raw term;

    public TypeCast(CQL3Type.Raw type, Term.Raw term) {
        this.type = type;
        this.term = term;
    }

    @Override
    public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
        if (!this.term.testAssignment(keyspace, this.castedSpecOf(keyspace, receiver)).isAssignable()) {
            throw new InvalidRequestException(String.format("Cannot cast value %s to type %s", this.term, this.type));
        }
        if (!this.testAssignment(keyspace, receiver).isAssignable()) {
            throw new InvalidRequestException(String.format("Cannot assign value %s to %s of type %s", this, receiver.name, receiver.type.asCQL3Type()));
        }
        return this.term.prepare(keyspace, receiver);
    }

    private ColumnSpecification castedSpecOf(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
        return new ColumnSpecification(receiver.ksName, receiver.cfName, new ColumnIdentifier(this.toString(), true), this.type.prepare(keyspace).getType());
    }

    @Override
    public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        AbstractType<?> castedType = this.type.prepare(keyspace).getType();
        if (receiver.type.equals(castedType)) {
            return AssignmentTestable.TestResult.EXACT_MATCH;
        }
        if (receiver.type.isValueCompatibleWith(castedType)) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
    }

    public String toString() {
        return "(" + this.type + ")" + this.term;
    }
}

