/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.omegat.core.Core;
import org.omegat.core.data.PluginInformation;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.preferences.view.PluginsPreferencesController;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class PluginInstaller {
    private static final String PLUGIN_NAME = "Plugin-Name";
    private static final String PLUGIN_VERSION = "Plugin-Version";
    private static final String PLUGIN_TYPE = "OmegaT-Plugin";

    private PluginInstaller() {
    }

    public static boolean install(File pluginFile) {
        PluginInformation info;
        Path pluginJarFile;
        try {
            Path tmporaryDir = Files.createTempDirectory("omegat", new FileAttribute[0]);
            pluginJarFile = PluginInstaller.unpackPlugin(pluginFile, tmporaryDir);
            pluginJarFile.toFile().deleteOnExit();
            tmporaryDir.toFile().deleteOnExit();
        }
        catch (IOException ex) {
            Log.logErrorRB("PREFS_PLUGINS_INSTALLATION_FAILED", ex.getLocalizedMessage());
            return false;
        }
        try {
            info = (PluginInformation)PluginInstaller.parsePluginJarFileManifest(pluginJarFile.toFile()).stream().findFirst().orElseThrow(() -> new IOException(OStrings.getString("PREFS_PLUGINS_UNKNOWN_ARCHIVE")));
        }
        catch (IOException e) {
            Log.logErrorRB("PREFS_PLUGINS_INSTALLATION_FAILED", e.getLocalizedMessage());
            Core.getMainWindow().displayWarningRB("PREFS_PLUGINS_INSTALLATION_FAILED", e.getLocalizedMessage(), new Object[0]);
            return false;
        }
        String pluginName = info.getName();
        String version = info.getVersion();
        PluginInformation currentInfo = PluginInstaller.getInstalledPlugins().getOrDefault(info.getClassName(), null);
        String message = currentInfo != null ? StringUtil.format(OStrings.getString("PREFS_PLUGINS_CONFIRM_UPGRADE"), pluginName, currentInfo.getVersion(), version) : StringUtil.format(OStrings.getString("PREFS_PLUGINS_CONFIRM_INSTALL"), pluginName, version);
        if (0 == JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), message, OStrings.getString("PREFS_PLUGINS_TITLE_CONFIRM_INSTALLATION"), 2, 0)) {
            if (PluginInstaller.doInstall(currentInfo, pluginJarFile.toFile())) {
                return true;
            }
            JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("PREFS_PLUGINS_INSTALLATION_FAILED"), OStrings.getString("PREFS_PLUGINS_TITLE_CONFIRM_INSTALLATION"), 0, 0);
        }
        return false;
    }

    private static boolean doInstall(PluginInformation currentInfo, File file) {
        try {
            if (currentInfo != null) {
                URL url = currentInfo.getUrl();
                File jarFile = new File(url.getPath().substring(5, url.getPath().indexOf("!")));
                if (jarFile.getName().equals(file.getName())) {
                    File bakFile = new File(jarFile.getPath() + ".bak");
                    FileUtils.moveFile((File)jarFile, (File)bakFile);
                    FileUtils.forceDeleteOnExit((File)bakFile);
                } else {
                    FileUtils.forceDeleteOnExit((File)jarFile);
                }
            }
            File homePluginsDir = new File(StaticUtils.getConfigDir(), "plugins");
            FileUtils.copyFileToDirectory((File)file, (File)homePluginsDir, (boolean)true);
            return true;
        }
        catch (IOException ex) {
            Log.logErrorRB("PREFS_PLUGINS_INSTALLATION_FAILED", new Object[0]);
            Log.log(ex);
            return false;
        }
    }

    static Path unpackPlugin(File sourceFile, Path targetPath) throws IOException {
        Path target;
        if (sourceFile.getName().endsWith(".jar")) {
            target = targetPath.resolve(sourceFile.getName());
            FileUtils.copyFile((File)sourceFile, (File)target.toFile());
        } else if (sourceFile.getName().endsWith(".zip")) {
            try (InputStream inputStream = Files.newInputStream(sourceFile.toPath(), new OpenOption[0]);){
                Predicate<String> expected = f -> f.endsWith(".jar");
                List<String> extracted = StaticUtils.extractFromZip(inputStream, targetPath.toFile(), expected);
                if (extracted.size() == 0) {
                    throw new FileNotFoundException("Could not extract a jar file from zip");
                }
                target = targetPath.resolve(extracted.get(0));
            }
        } else {
            throw new IOException("Unknown archive type: " + sourceFile.getName());
        }
        FileUtils.forceDeleteOnExit((File)target.toFile());
        return target;
    }

    static Set<PluginInformation> parsePluginJarFileManifest(File pluginJarFile) throws IOException {
        HashSet<PluginInformation> pluginInfo = new HashSet<PluginInformation>();
        URL[] urls = new URL[]{pluginJarFile.toURI().toURL()};
        try (URLClassLoader pluginsClassLoader = new URLClassLoader(urls, PluginsPreferencesController.class.getClassLoader());){
            Enumeration<URL> mlist = pluginsClassLoader.getResources("META-INF/MANIFEST.MF");
            while (mlist.hasMoreElements()) {
                URL mu = mlist.nextElement();
                pluginInfo.addAll(PluginInstaller.parsePluginJarFileManifest(mu));
            }
        }
        return pluginInfo;
    }

    static Set<PluginInformation> parsePluginJarFileManifest(URL manifestUrl) throws IOException {
        HashSet<PluginInformation> pluginInfo = new HashSet<PluginInformation>();
        try (InputStream in = manifestUrl.openStream();){
            Manifest m = new Manifest(in);
            Attributes mainAttrs = m.getMainAttributes();
            String pluginClasses = m.getMainAttributes().getValue("OmegaT-Plugins");
            if (pluginClasses != null) {
                for (String clazz : pluginClasses.split("\\s+")) {
                    if (clazz.trim().isEmpty()) continue;
                    pluginInfo.add(PluginInformation.Builder.fromManifest(clazz, m, manifestUrl, PluginInformation.Status.NEW));
                }
            } else if (m.getMainAttributes().getValue(PLUGIN_TYPE) != null) {
                Map<String, Attributes> entries = m.getEntries();
                for (Map.Entry<String, Attributes> e : entries.entrySet()) {
                    String key = e.getKey();
                    Attributes attrs = e.getValue();
                    String sType = attrs.getValue(PLUGIN_TYPE);
                    if (sType == null) continue;
                    pluginInfo.add(PluginInformation.Builder.fromManifest(key, m, manifestUrl, PluginInformation.Status.NEW));
                }
            }
        }
        return pluginInfo;
    }

    private static Map<String, PluginInformation> getInstalledPlugins() {
        TreeMap<String, PluginInformation> installedPlugins = new TreeMap<String, PluginInformation>();
        PluginUtils.getPluginInformations().stream().sorted(Comparator.comparing(PluginInformation::getClassName)).filter(info -> !installedPlugins.containsKey(info.getClassName())).forEach(info -> installedPlugins.put(info.getClassName(), (PluginInformation)info));
        return installedPlugins;
    }
}

