/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.stardict;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.trie4j.MapTrie;
import org.trie4j.patricia.MapPatriciaTrie;
import tokyo.northside.stardict.DictionaryData;
import tokyo.northside.stardict.IndexEntry;

final class DictionaryDataBuilder<T> {
    private final MapTrie<Object> mapPatriciaTrie = new MapPatriciaTrie();
    private final List<IndexEntry> indexList;

    DictionaryDataBuilder(Map<String, Integer> synonymKeys) {
        this.indexList = new ArrayList<IndexEntry>(synonymKeys.size());
    }

    public DictionaryData<T> build() {
        return new DictionaryData(this.mapPatriciaTrie);
    }

    public void add(String key, IndexEntry entry) {
        if (key != null && !key.isEmpty()) {
            this.addEntry(key, entry);
        }
        this.indexList.add(entry);
    }

    public void addSynonym(String key, String word, int index) {
        IndexEntry val = this.indexList.get(index);
        this.addEntry(key, new IndexEntry(word, val.getStart(), val.getLen(), val.getType()));
    }

    private void addEntry(String key, IndexEntry entry) {
        Object[] stored = this.mapPatriciaTrie.get(key);
        if (stored == null) {
            this.mapPatriciaTrie.insert(key, (Object)entry);
        } else {
            stored = stored instanceof Object[] ? this.extendArray(stored, entry) : new Object[]{stored, entry};
            this.mapPatriciaTrie.put(key, (Object)stored);
        }
    }

    Object[] extendArray(Object[] array, Object value) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }
}

