/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.mpp.BackgroundPattern;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.GanttBarDateFormat;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GenericView;
import net.sf.mpxj.mpp.GridLines;
import net.sf.mpxj.mpp.Interval;
import net.sf.mpxj.mpp.LineStyle;
import net.sf.mpxj.mpp.LinkStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.NonWorkingTimeStyle;
import net.sf.mpxj.mpp.ProgressLineDay;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.TableFontStyle;
import net.sf.mpxj.mpp.TimescaleTier;
import net.sf.mpxj.mpp.Var2Data;

public abstract class GanttChartView
extends GenericView {
    protected GridLines m_sheetRowsGridLines;
    protected GridLines m_sheetColumnsGridLines;
    protected GridLines m_titleVerticalGridLines;
    protected GridLines m_titleHorizontalGridLines;
    protected GridLines m_middleTierColumnGridLines;
    protected GridLines m_bottomTierColumnGridLines;
    protected GridLines m_ganttRowsGridLines;
    protected GridLines m_barRowsGridLines;
    protected GridLines m_currentDateGridLines;
    protected GridLines m_pageBreakGridLines;
    protected GridLines m_projectStartGridLines;
    protected GridLines m_projectFinishGridLines;
    protected GridLines m_statusDateGridLines;
    protected GridLines m_topTierColumnGridLines;
    protected int m_ganttBarHeight;
    protected TimescaleTier m_timescaleTopTier;
    protected TimescaleTier m_timescaleMiddleTier;
    protected TimescaleTier m_timescaleBottomTier;
    protected boolean m_timescaleScaleSeparator;
    protected int m_timescaleSize;
    protected int m_timescaleShowTiers;
    protected String m_nonWorkingDaysCalendarName;
    protected Color m_nonWorkingColor;
    protected ChartPattern m_nonWorkingPattern;
    protected NonWorkingTimeStyle m_nonWorkingStyle;
    protected boolean m_showDrawings;
    protected boolean m_roundBarsToWholeDays;
    protected boolean m_showBarSplits;
    protected boolean m_alwaysRollupGanttBars;
    protected boolean m_hideRollupBarsWhenSummaryExpanded;
    protected GanttBarDateFormat m_barDateFormat;
    protected LinkStyle m_linkStyle;
    protected GanttBarStyle[] m_barStyles;
    protected GanttBarStyleException[] m_barStyleExceptions;
    private int m_tableWidth;
    private String m_defaultFilterName;
    private String m_groupName;
    private boolean m_highlightFilter;
    private boolean m_showInMenu;
    protected FontStyle m_highlightedTasksFontStyle;
    protected FontStyle m_rowAndColumnFontStyle;
    protected FontStyle m_nonCriticalTasksFontStyle;
    protected FontStyle m_criticalTasksFontStyle;
    protected FontStyle m_summaryTasksFontStyle;
    protected FontStyle m_milestoneTasksFontStyle;
    protected FontStyle m_topTimescaleFontStyle;
    protected FontStyle m_middleTimescaleFontStyle;
    protected FontStyle m_bottomTimescaleFontStyle;
    protected FontStyle m_barTextLeftFontStyle;
    protected FontStyle m_barTextRightFontStyle;
    protected FontStyle m_barTextTopFontStyle;
    protected FontStyle m_barTextBottomFontStyle;
    protected FontStyle m_barTextInsideFontStyle;
    protected FontStyle m_markedTasksFontStyle;
    protected FontStyle m_projectSummaryTasksFontStyle;
    protected FontStyle m_externalTasksFontStyle;
    protected TableFontStyle[] m_tableFontStyles;
    protected boolean m_progressLinesEnabled;
    protected boolean m_progressLinesAtCurrentDate;
    protected boolean m_progressLinesAtRecurringIntervals;
    protected Interval m_progressLinesInterval;
    protected int m_progressLinesIntervalDailyDayNumber;
    protected boolean m_progressLinesIntervalDailyWorkday;
    protected boolean[] m_progressLinesIntervalWeeklyDay = new boolean[8];
    protected int m_progressLinesIntervalWeekleyWeekNumber;
    protected boolean m_progressLinesIntervalMonthlyDay;
    protected int m_progressLinesIntervalMonthlyDayDayNumber;
    protected int m_progressLinesIntervalMonthlyDayMonthNumber;
    protected ProgressLineDay m_progressLinesIntervalMonthlyFirstLastDay;
    protected boolean m_progressLinesIntervalMonthlyFirstLast;
    protected int m_progressLinesIntervalMonthlyFirstLastMonthNumber;
    protected boolean m_progressLinesBeginAtProjectStart;
    protected Date m_progressLinesBeginAtDate;
    protected boolean m_progressLinesDisplaySelected;
    protected Date[] m_progressLinesDisplaySelectedDates;
    protected boolean m_progressLinesActualPlan;
    protected int m_progressLinesDisplayType;
    protected boolean m_progressLinesShowDate;
    protected int m_progressLinesDateFormat;
    protected FontStyle m_progressLinesFontStyle;
    protected Color m_progressLinesCurrentLineColor;
    protected LineStyle m_progressLinesCurrentLineStyle;
    protected Color m_progressLinesCurrentProgressPointColor;
    protected int m_progressLinesCurrentProgressPointShape;
    protected Color m_progressLinesOtherLineColor;
    protected LineStyle m_progressLinesOtherLineStyle;
    protected Color m_progressLinesOtherProgressPointColor;
    protected int m_progressLinesOtherProgressPointShape;
    protected List<Filter> m_autoFilters = new LinkedList<Filter>();
    protected Map<FieldType, Filter> m_autoFiltersByType = new HashMap<FieldType, Filter>();
    private FilterContainer m_filters;
    protected static final Integer VIEW_PROPERTIES = 574619656;
    protected static final Integer TIMESCALE_PROPERTIES = 574619678;
    private static final Integer TABLE_PROPERTIES = 574619655;
    private static final Integer FILTER_NAME = 574619659;
    private static final Integer GROUP_NAME = 574619672;
    private static final Integer COLUMN_PROPERTIES = 574619660;
    private static final Integer PROGRESS_LINE_PROPERTIES = 574619671;
    private static final Integer AUTO_FILTER_PROPERTIES = 574619669;

    protected abstract void processDefaultBarStyles(Props var1);

    protected abstract void processExceptionBarStyles(Props var1);

    protected abstract void processAutoFilters(byte[] var1);

    protected abstract void processViewProperties(Map<Integer, FontBase> var1, Props var2);

    protected abstract void processTableFontStyles(Map<Integer, FontBase> var1, byte[] var2);

    protected abstract void processProgressLines(Map<Integer, FontBase> var1, byte[] var2);

    GanttChartView(ProjectFile projectFile, byte[] byArray, byte[] byArray2, Var2Data var2Data, Map<Integer, FontBase> map) throws IOException {
        super(projectFile, byArray2, var2Data);
        this.m_filters = projectFile.getFilters();
        this.m_showInMenu = (byArray[8] & 8) != 0;
        byte[] byArray3 = var2Data.getByteArray(this.m_id, this.getPropertiesID());
        if (byArray3 != null) {
            byte[] byArray4;
            byte[] byArray5;
            byte[] byArray6;
            byte[] byArray7;
            Props9 props9 = new Props9(new ByteArrayInputStream(byArray3));
            byte[] byArray8 = props9.getByteArray(TABLE_PROPERTIES);
            if (byArray8 != null) {
                this.m_tableWidth = MPPUtility.getShort(byArray8, 35);
                boolean bl = this.m_highlightFilter = byArray8[7] != 0;
            }
            if ((byArray7 = props9.getByteArray(FILTER_NAME)) != null) {
                this.m_defaultFilterName = MPPUtility.getUnicodeString(byArray7, 0);
            }
            if ((byArray6 = props9.getByteArray(GROUP_NAME)) != null) {
                this.m_groupName = MPPUtility.getUnicodeString(byArray6, 0);
            }
            this.processViewProperties(map, props9);
            this.processDefaultBarStyles(props9);
            this.processExceptionBarStyles(props9);
            byte[] byArray9 = props9.getByteArray(COLUMN_PROPERTIES);
            if (byArray9 != null) {
                this.processTableFontStyles(map, byArray9);
            }
            if ((byArray5 = props9.getByteArray(PROGRESS_LINE_PROPERTIES)) != null) {
                this.processProgressLines(map, byArray5);
            }
            if ((byArray4 = props9.getByteArray(AUTO_FILTER_PROPERTIES)) != null) {
                this.processAutoFilters(byArray4);
            }
        }
    }

    public GridLines getSheetColumnsGridLines() {
        return this.m_sheetColumnsGridLines;
    }

    public GridLines getSheetRowsGridLines() {
        return this.m_sheetRowsGridLines;
    }

    public GridLines getStatusDateGridLines() {
        return this.m_statusDateGridLines;
    }

    public GridLines getTitleHorizontalGridLines() {
        return this.m_titleHorizontalGridLines;
    }

    public GridLines getTitleVerticalGridLines() {
        return this.m_titleVerticalGridLines;
    }

    public GridLines getBarRowsGridLines() {
        return this.m_barRowsGridLines;
    }

    public GridLines getCurrentDateGridLines() {
        return this.m_currentDateGridLines;
    }

    public GridLines getGanttRowsGridLines() {
        return this.m_ganttRowsGridLines;
    }

    public GridLines getTopTierColumnGridLines() {
        return this.m_topTierColumnGridLines;
    }

    public GridLines getMiddleTierColumnGridLines() {
        return this.m_middleTierColumnGridLines;
    }

    public GridLines getBottomTierColumnGridLines() {
        return this.m_bottomTierColumnGridLines;
    }

    public String getNonWorkingDaysCalendarName() {
        return this.m_nonWorkingDaysCalendarName;
    }

    public GridLines getPageBreakGridLines() {
        return this.m_pageBreakGridLines;
    }

    public GridLines getProjectFinishGridLines() {
        return this.m_projectFinishGridLines;
    }

    public GridLines getProjectStartGridLines() {
        return this.m_projectStartGridLines;
    }

    public int getGanttBarHeight() {
        return this.m_ganttBarHeight;
    }

    public boolean getTimescaleScaleSeparator() {
        return this.m_timescaleScaleSeparator;
    }

    public TimescaleTier getTimescaleTopTier() {
        return this.m_timescaleTopTier;
    }

    public TimescaleTier getTimescaleMiddleTier() {
        return this.m_timescaleMiddleTier;
    }

    public TimescaleTier getTimescaleBottomTier() {
        return this.m_timescaleBottomTier;
    }

    public int getTimescaleSize() {
        return this.m_timescaleSize;
    }

    public int getTimescaleShowTiers() {
        return this.m_timescaleShowTiers;
    }

    public Color getNonWorkingColor() {
        return this.m_nonWorkingColor;
    }

    public ChartPattern getNonWorkingPattern() {
        return this.m_nonWorkingPattern;
    }

    public NonWorkingTimeStyle getNonWorkingStyle() {
        return this.m_nonWorkingStyle;
    }

    public boolean getAlwaysRollupGanttBars() {
        return this.m_alwaysRollupGanttBars;
    }

    public GanttBarDateFormat getBarDateFormat() {
        return this.m_barDateFormat;
    }

    public boolean getHideRollupBarsWhenSummaryExpanded() {
        return this.m_hideRollupBarsWhenSummaryExpanded;
    }

    public LinkStyle getLinkStyle() {
        return this.m_linkStyle;
    }

    public boolean getRoundBarsToWholeDays() {
        return this.m_roundBarsToWholeDays;
    }

    public boolean getShowBarSplits() {
        return this.m_showBarSplits;
    }

    public boolean getShowDrawings() {
        return this.m_showDrawings;
    }

    public GanttBarStyleException[] getBarStyleExceptions() {
        return this.m_barStyleExceptions;
    }

    public GanttBarStyle[] getBarStyles() {
        return this.m_barStyles;
    }

    public int getTableWidth() {
        return this.m_tableWidth;
    }

    public String getDefaultFilterName() {
        return this.m_defaultFilterName;
    }

    public Filter getDefaultFilter() {
        return this.m_filters.getFilterByName(this.m_defaultFilterName);
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public boolean getHighlightFilter() {
        return this.m_highlightFilter;
    }

    public boolean getShowInMenu() {
        return this.m_showInMenu;
    }

    public FontStyle getBarTextBottomFontStyle() {
        return this.m_barTextBottomFontStyle;
    }

    public FontStyle getBarTextInsideFontStyle() {
        return this.m_barTextInsideFontStyle;
    }

    public FontStyle getBarTextLeftFontStyle() {
        return this.m_barTextLeftFontStyle;
    }

    public FontStyle getBarTextRightFontStyle() {
        return this.m_barTextRightFontStyle;
    }

    public FontStyle getBarTextTopFontStyle() {
        return this.m_barTextTopFontStyle;
    }

    public FontStyle getCriticalTasksFontStyle() {
        return this.m_criticalTasksFontStyle;
    }

    public FontStyle getExternalTasksFontStyle() {
        return this.m_externalTasksFontStyle;
    }

    public FontStyle getHighlightedTasksFontStyle() {
        return this.m_highlightedTasksFontStyle;
    }

    public FontStyle getTopTimescaleFontStyle() {
        return this.m_topTimescaleFontStyle;
    }

    public FontStyle getMiddleTimescaleFontStyle() {
        return this.m_middleTimescaleFontStyle;
    }

    public FontStyle getMarkedTasksFontStyle() {
        return this.m_markedTasksFontStyle;
    }

    public FontStyle getMilestoneTasksFontStyle() {
        return this.m_milestoneTasksFontStyle;
    }

    public FontStyle getBottomTimescaleFontStyle() {
        return this.m_bottomTimescaleFontStyle;
    }

    public FontStyle getNonCriticalTasksFontStyle() {
        return this.m_nonCriticalTasksFontStyle;
    }

    public FontStyle getProjectSummaryTasksFontStyle() {
        return this.m_projectSummaryTasksFontStyle;
    }

    public FontStyle getRowAndColumnFontStyle() {
        return this.m_rowAndColumnFontStyle;
    }

    public FontStyle getSummaryTasksFontStyle() {
        return this.m_summaryTasksFontStyle;
    }

    public TableFontStyle[] getTableFontStyles() {
        return this.m_tableFontStyles;
    }

    public boolean getProgressLinesActualPlan() {
        return this.m_progressLinesActualPlan;
    }

    public boolean getProgressLinesAtCurrentDate() {
        return this.m_progressLinesAtCurrentDate;
    }

    public boolean getProgressLinesAtRecurringIntervals() {
        return this.m_progressLinesAtRecurringIntervals;
    }

    public Date getProgressLinesBeginAtDate() {
        return this.m_progressLinesBeginAtDate;
    }

    public boolean getProgressLinesBeginAtProjectStart() {
        return this.m_progressLinesBeginAtProjectStart;
    }

    public Color getProgressLinesCurrentLineColor() {
        return this.m_progressLinesCurrentLineColor;
    }

    public LineStyle getProgressLinesCurrentLineStyle() {
        return this.m_progressLinesCurrentLineStyle;
    }

    public Color getProgressLinesCurrentProgressPointColor() {
        return this.m_progressLinesCurrentProgressPointColor;
    }

    public int getProgressLinesCurrentProgressPointShape() {
        return this.m_progressLinesCurrentProgressPointShape;
    }

    public int getProgressLinesIntervalDailyDayNumber() {
        return this.m_progressLinesIntervalDailyDayNumber;
    }

    public boolean isProgressLinesIntervalDailyWorkday() {
        return this.m_progressLinesIntervalDailyWorkday;
    }

    public int getProgressLinesDateFormat() {
        return this.m_progressLinesDateFormat;
    }

    public boolean getProgressLinesDisplaySelected() {
        return this.m_progressLinesDisplaySelected;
    }

    public Date[] getProgressLinesDisplaySelectedDates() {
        return this.m_progressLinesDisplaySelectedDates;
    }

    public int getProgressLinesDisplayType() {
        return this.m_progressLinesDisplayType;
    }

    public boolean getProgressLinesEnabled() {
        return this.m_progressLinesEnabled;
    }

    public FontStyle getProgressLinesFontStyle() {
        return this.m_progressLinesFontStyle;
    }

    public Interval getProgressLinesInterval() {
        return this.m_progressLinesInterval;
    }

    public ProgressLineDay getProgressLinesIntervalMonthlyFirstLastDay() {
        return this.m_progressLinesIntervalMonthlyFirstLastDay;
    }

    public int getProgressLinesIntervalMonthlyFirstLastMonthNumber() {
        return this.m_progressLinesIntervalMonthlyFirstLastMonthNumber;
    }

    public int getProgressLinesIntervalMonthlyDayDayNumber() {
        return this.m_progressLinesIntervalMonthlyDayDayNumber;
    }

    public boolean getProgressLinesIntervalMonthlyDay() {
        return this.m_progressLinesIntervalMonthlyDay;
    }

    public int getProgressLinesIntervalMonthlyDayMonthNumber() {
        return this.m_progressLinesIntervalMonthlyDayMonthNumber;
    }

    public boolean getProgressLinesIntervalMonthlyFirstLast() {
        return this.m_progressLinesIntervalMonthlyFirstLast;
    }

    public Color getProgressLinesOtherLineColor() {
        return this.m_progressLinesOtherLineColor;
    }

    public LineStyle getProgressLinesOtherLineStyle() {
        return this.m_progressLinesOtherLineStyle;
    }

    public Color getProgressLinesOtherProgressPointColor() {
        return this.m_progressLinesOtherProgressPointColor;
    }

    public int getProgressLinesOtherProgressPointShape() {
        return this.m_progressLinesOtherProgressPointShape;
    }

    public boolean getProgressLinesShowDate() {
        return this.m_progressLinesShowDate;
    }

    public int getProgressLinesIntervalWeekleyWeekNumber() {
        return this.m_progressLinesIntervalWeekleyWeekNumber;
    }

    public boolean[] getProgressLinesIntervalWeeklyDay() {
        return this.m_progressLinesIntervalWeeklyDay;
    }

    protected int mapGanttBarHeight(int n) {
        switch (n) {
            case 0: {
                n = 6;
                break;
            }
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 10;
                break;
            }
            case 3: {
                n = 12;
                break;
            }
            case 4: {
                n = 14;
                break;
            }
            case 5: {
                n = 18;
                break;
            }
            case 6: {
                n = 24;
            }
        }
        return n;
    }

    protected FontStyle getFontStyle(byte[] byArray, int n, Map<Integer, FontBase> map) {
        Integer n2 = MPPUtility.getByte(byArray, n);
        FontBase fontBase = map.get(n2);
        int n3 = MPPUtility.getByte(byArray, n + 1);
        ColorType colorType = ColorType.getInstance(MPPUtility.getByte(byArray, n + 2));
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 4) != 0;
        FontStyle fontStyle = new FontStyle(fontBase, bl2, bl, bl3, false, colorType.getColor(), null, BackgroundPattern.SOLID);
        return fontStyle;
    }

    protected TableFontStyle getColumnFontStyle(byte[] byArray, int n, Map<Integer, FontBase> map) {
        int n2 = MPPUtility.getInt(byArray, n);
        TaskField taskField = MPPTaskField.getInstance(MPPUtility.getShort(byArray, n + 4));
        Integer n3 = MPPUtility.getByte(byArray, n + 8);
        int n4 = MPPUtility.getByte(byArray, n + 9);
        ColorType colorType = ColorType.getInstance(MPPUtility.getByte(byArray, n + 10));
        int n5 = MPPUtility.getByte(byArray, n + 12);
        FontBase fontBase = map.get(n3);
        boolean bl = (n4 & 1) != 0;
        boolean bl2 = (n4 & 2) != 0;
        boolean bl3 = (n4 & 4) != 0;
        boolean bl4 = (n5 & 1) != 0;
        boolean bl5 = (n5 & 2) != 0;
        boolean bl6 = (n5 & 4) != 0;
        boolean bl7 = (n5 & 8) != 0;
        boolean bl8 = (n5 & 0x10) != 0;
        boolean bl9 = n2 == -1;
        boolean bl10 = n2 == -1;
        return new TableFontStyle(n2, taskField, fontBase, bl2, bl, bl3, false, colorType.getColor(), Color.BLACK, BackgroundPattern.TRANSPARENT, bl6, bl4, bl5, false, bl7, bl8, bl9, bl10);
    }

    public List<Filter> getAutoFilters() {
        return this.m_autoFilters;
    }

    public Filter getAutoFilterByType(FieldType fieldType) {
        return this.m_autoFiltersByType.get(fieldType);
    }

    @Override
    public String toString() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("[GanttChartView");
        printWriter.println("   " + super.toString());
        printWriter.println("   highlightedTasksFontStyle=" + this.m_highlightedTasksFontStyle);
        printWriter.println("   rowAndColumnFontStyle=" + this.m_rowAndColumnFontStyle);
        printWriter.println("   nonCriticalTasksFontStyle=" + this.m_nonCriticalTasksFontStyle);
        printWriter.println("   criticalTasksFontStyle=" + this.m_criticalTasksFontStyle);
        printWriter.println("   summaryTasksFontStyle=" + this.m_summaryTasksFontStyle);
        printWriter.println("   milestoneTasksFontStyle=" + this.m_milestoneTasksFontStyle);
        printWriter.println("   topTimescaleFontStyle=" + this.m_topTimescaleFontStyle);
        printWriter.println("   middleTimescaleFontStyle=" + this.m_middleTimescaleFontStyle);
        printWriter.println("   bottomTimescaleFontStyle=" + this.m_bottomTimescaleFontStyle);
        printWriter.println("   barTextLeftFontStyle=" + this.m_barTextLeftFontStyle);
        printWriter.println("   barTextRightFontStyle=" + this.m_barTextRightFontStyle);
        printWriter.println("   barTextTopFontStyle=" + this.m_barTextTopFontStyle);
        printWriter.println("   barTextBottomFontStyle=" + this.m_barTextBottomFontStyle);
        printWriter.println("   barTextInsideFontStyle=" + this.m_barTextInsideFontStyle);
        printWriter.println("   markedTasksFontStyle=" + this.m_markedTasksFontStyle);
        printWriter.println("   projectSummaryTasksFontStyle=" + this.m_projectSummaryTasksFontStyle);
        printWriter.println("   externalTasksFontStyle=" + this.m_externalTasksFontStyle);
        printWriter.println("   SheetRowsGridLines=" + this.m_sheetRowsGridLines);
        printWriter.println("   SheetColumnsGridLines=" + this.m_sheetColumnsGridLines);
        printWriter.println("   TitleVerticalGridLines=" + this.m_titleVerticalGridLines);
        printWriter.println("   TitleHorizontalGridLines=" + this.m_titleHorizontalGridLines);
        printWriter.println("   TopTierColumnGridLines=" + this.m_topTierColumnGridLines);
        printWriter.println("   MiddleTierColumnGridLines=" + this.m_middleTierColumnGridLines);
        printWriter.println("   BottomTierColumnGridLines=" + this.m_bottomTierColumnGridLines);
        printWriter.println("   GanttRowsGridLines=" + this.m_ganttRowsGridLines);
        printWriter.println("   BarRowsGridLines=" + this.m_barRowsGridLines);
        printWriter.println("   CurrentDateGridLines=" + this.m_currentDateGridLines);
        printWriter.println("   PageBreakGridLines=" + this.m_pageBreakGridLines);
        printWriter.println("   ProjectStartGridLines=" + this.m_projectStartGridLines);
        printWriter.println("   ProjectFinishGridLines=" + this.m_projectFinishGridLines);
        printWriter.println("   StatusDateGridLines=" + this.m_statusDateGridLines);
        printWriter.println("   GanttBarHeight=" + this.m_ganttBarHeight);
        printWriter.println("   TimescaleTopTier=" + this.m_timescaleTopTier);
        printWriter.println("   TimescaleMiddleTier=" + this.m_timescaleMiddleTier);
        printWriter.println("   TimescaleBottomTier=" + this.m_timescaleBottomTier);
        printWriter.println("   TimescaleSeparator=" + this.m_timescaleScaleSeparator);
        printWriter.println("   TimescaleSize=" + this.m_timescaleSize + "%");
        printWriter.println("   NonWorkingDaysCalendarName=" + this.m_nonWorkingDaysCalendarName);
        printWriter.println("   NonWorkingColor=" + this.m_nonWorkingColor);
        printWriter.println("   NonWorkingPattern=" + this.m_nonWorkingPattern);
        printWriter.println("   NonWorkingStyle=" + this.m_nonWorkingStyle);
        printWriter.println("   ShowDrawings=" + this.m_showDrawings);
        printWriter.println("   RoundBarsToWholeDays=" + this.m_roundBarsToWholeDays);
        printWriter.println("   ShowBarSplits=" + this.m_showBarSplits);
        printWriter.println("   AlwaysRollupGanttBars=" + this.m_alwaysRollupGanttBars);
        printWriter.println("   HideRollupBarsWhenSummaryExpanded=" + this.m_hideRollupBarsWhenSummaryExpanded);
        printWriter.println("   BarDateFormat=" + this.m_barDateFormat);
        printWriter.println("   LinkStyle=" + this.m_linkStyle);
        printWriter.println("   ProgressLinesEnabled=" + this.m_progressLinesEnabled);
        printWriter.println("   ProgressLinesAtCurrentDate=" + this.m_progressLinesAtCurrentDate);
        printWriter.println("   ProgressLinesAtRecurringIntervals=" + this.m_progressLinesAtRecurringIntervals);
        printWriter.println("   ProgressLinesInterval=" + this.m_progressLinesInterval);
        printWriter.println("   ProgressLinesDailyDayNumber=" + this.m_progressLinesIntervalDailyDayNumber);
        printWriter.println("   ProgressLinesDailyWorkday=" + this.m_progressLinesIntervalDailyWorkday);
        printWriter.print("   ProgressLinesWeeklyDay=[");
        for (n = 0; n < this.m_progressLinesIntervalWeeklyDay.length; ++n) {
            if (n != 0) {
                printWriter.print(",");
            }
            printWriter.print(this.m_progressLinesIntervalWeeklyDay[n]);
        }
        printWriter.println("]");
        printWriter.println("   ProgressLinesWeeklyWeekNumber=" + this.m_progressLinesIntervalWeekleyWeekNumber);
        printWriter.println("   ProgressLinesMonthlyDayOfMonth=" + this.m_progressLinesIntervalMonthlyDay);
        printWriter.println("   ProgressLinesMonthDayNumber=" + this.m_progressLinesIntervalMonthlyDayDayNumber);
        printWriter.println("   ProgressLinesMonthlyDay=" + this.m_progressLinesIntervalMonthlyFirstLastDay);
        printWriter.println("   ProgressLinesMonthlyFirst=" + this.m_progressLinesIntervalMonthlyFirstLast);
        printWriter.println("   ProgressLinesBeginAtProjectStart=" + this.m_progressLinesBeginAtProjectStart);
        printWriter.println("   ProgressLinesBeginAtDate=" + this.m_progressLinesBeginAtDate);
        printWriter.println("   ProgressLinesDisplaySelected=" + this.m_progressLinesDisplaySelected);
        printWriter.print("   ProgressLinesDisplaySelectedDates=[");
        if (this.m_progressLinesDisplaySelectedDates != null) {
            for (n = 0; n < this.m_progressLinesDisplaySelectedDates.length; ++n) {
                if (n != 0) {
                    printWriter.print(",");
                }
                printWriter.print(this.m_progressLinesDisplaySelectedDates[n]);
            }
        }
        printWriter.println("]");
        printWriter.println("   ProgressLinesActualPlan=" + this.m_progressLinesActualPlan);
        printWriter.println("   ProgressLinesDisplayType=" + this.m_progressLinesDisplayType);
        printWriter.println("   ProgressLinesShowDate=" + this.m_progressLinesShowDate);
        printWriter.println("   ProgressLinesDateFormat=" + this.m_progressLinesDateFormat);
        printWriter.println("   ProgressLinesFontStyle=" + this.m_progressLinesFontStyle);
        printWriter.println("   ProgressLinesCurrentLineColor=" + this.m_progressLinesCurrentLineColor);
        printWriter.println("   ProgressLinesCurrentLineStyle=" + this.m_progressLinesCurrentLineStyle);
        printWriter.println("   ProgressLinesCurrentProgressPointColor=" + this.m_progressLinesCurrentProgressPointColor);
        printWriter.println("   ProgressLinesCurrentProgressPointShape=" + this.m_progressLinesCurrentProgressPointShape);
        printWriter.println("   ProgressLinesOtherLineColor=" + this.m_progressLinesOtherLineColor);
        printWriter.println("   ProgressLinesOtherLineStyle=" + this.m_progressLinesOtherLineStyle);
        printWriter.println("   ProgressLinesOtherProgressPointColor=" + this.m_progressLinesOtherProgressPointColor);
        printWriter.println("   ProgressLinesOtherProgressPointShape=" + this.m_progressLinesOtherProgressPointShape);
        printWriter.println("   TableWidth=" + this.m_tableWidth);
        printWriter.println("   DefaultFilterName=" + this.m_defaultFilterName);
        printWriter.println("   GroupName=" + this.m_groupName);
        printWriter.println("   HighlightFilter=" + this.m_highlightFilter);
        printWriter.println("   ShowInMenu=" + this.m_showInMenu);
        if (this.m_tableFontStyles != null) {
            for (n = 0; n < this.m_tableFontStyles.length; ++n) {
                printWriter.println("   ColumnFontStyle=" + this.m_tableFontStyles[n]);
            }
        }
        if (this.m_barStyles != null) {
            for (n = 0; n < this.m_barStyles.length; ++n) {
                printWriter.println("   BarStyle=" + this.m_barStyles[n]);
            }
        }
        if (this.m_barStyleExceptions != null) {
            for (n = 0; n < this.m_barStyleExceptions.length; ++n) {
                printWriter.println("   BarStyleException=" + this.m_barStyleExceptions[n]);
            }
        }
        if (!this.m_autoFilters.isEmpty()) {
            for (Filter filter : this.m_autoFilters) {
                printWriter.println("   AutoFilter=" + filter);
            }
        }
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

