/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.undo;

import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.util.Environment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class UndoController
extends UndoManager
implements UndoableEditListener {
    protected transient UndoableEditSupport editSupport;
    protected Map nodeMapping = new HashMap();

    public UndoController() {
        this.editSupport = new UndoableEditSupport();
        this.editSupport.addUndoableEditListener(this);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        super.addEdit(undoableEdit);
    }

    public void clear() {
        super.discardAllEdits();
        this.nodeMapping.clear();
    }

    public UndoableEditSupport getEditSupport() {
        return this.editSupport;
    }

    @Override
    public void undo() {
        if (this.canUndo()) {
            Environment.setBatchMode(true);
            super.undo();
            Environment.setBatchMode(false);
        }
    }

    @Override
    public void redo() {
        if (this.canRedo()) {
            Environment.setBatchMode(true);
            super.redo();
            Environment.setBatchMode(false);
        }
    }

    @Override
    public boolean canUndo() {
        return super.canUndo();
    }

    @Override
    public boolean canRedo() {
        return super.canRedo();
    }

    public void store(Node node, NodeModel nodeModel) {
        HashMap<Object, Node> hashMap = (HashMap<Object, Node>)this.nodeMapping.get(nodeModel);
        if (hashMap == null) {
            hashMap = new HashMap<Object, Node>();
            this.nodeMapping.put(nodeModel, hashMap);
        }
        hashMap.put(node.getImpl(), node);
    }

    public Node retrieve(Object object, NodeModel nodeModel) {
        HashMap hashMap = (HashMap)this.nodeMapping.get(nodeModel);
        if (hashMap == null) {
            return null;
        }
        return (Node)hashMap.get(object);
    }

    public void beginUpdate() {
        if (this.editSupport != null) {
            this.editSupport.beginUpdate();
        }
    }

    public void endUpdate() {
        if (this.editSupport != null) {
            this.editSupport.endUpdate();
        }
    }

    public List<String> getEditNames() {
        if (this.edits == null) {
            return null;
        }
        int n = this.edits.size() >= 50 ? 50 : this.edits.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ListIterator listIterator = this.edits.listIterator(this.edits.size() - n);
        while (listIterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)listIterator.next();
            if (undoableEdit == null) continue;
            arrayList.add(undoableEdit.getPresentationName());
        }
        return arrayList;
    }

    public String getRedoName() {
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return null;
    }

    public String getUndoName() {
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return null;
    }
}

