/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.tools.quality.QualityToolConfigurableList;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolProjectConfiguration;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurationComboBox<C extends QualityToolConfiguration>
extends ComboboxWithBrowseButton {
    private final QualityToolConfigurationItem myDefaultConfigurationItem = new QualityToolConfigurationItem("DEFAULT_INTERPRETER", "By default project interpreter");
    protected final Project myProject;
    private ActionListener myButtonActionListener = null;
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

    public QualityToolConfigurationComboBox(@Nullable Project project) {
        super((JComboBox)new ComboBox());
        this.myProject = project;
        this.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof QualityToolConfigurationItem) {
                    ((QualityToolConfigurationItem)value).render((SimpleColoredComponent)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/php/tools/quality/QualityToolConfigurationComboBox$1", "customizeCellRenderer"));
            }
        });
        this.getComboBox().addActionListener(e -> this.fireChanged());
        this.setPreferredSize(new Dimension(200, this.getPreferredSize().height));
    }

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    private void fireChanged() {
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    @Nullable
    public String getSelectedItemId() {
        QualityToolConfigurationItem selectedItem = this.getSelectedItem();
        return selectedItem == null ? null : selectedItem.getId();
    }

    @Nullable
    public QualityToolConfigurationItem getSelectedItem() {
        return (QualityToolConfigurationItem)ObjectUtils.tryCast((Object)this.getComboBox().getSelectedItem(), QualityToolConfigurationItem.class);
    }

    public void reset(@NotNull Project project) {
        if (project == null) {
            QualityToolConfigurationComboBox.$$$reportNull$$$0(0);
        }
        this.reset(project, this.getSelectedItemId());
    }

    public void reset(@NotNull Project project, @Nullable String selectedItemId) {
        if (project == null) {
            QualityToolConfigurationComboBox.$$$reportNull$$$0(1);
        }
        List<C> configurations = this.getItems();
        Collections.sort(configurations);
        this.setModel(configurations, selectedItemId);
        if (this.myButtonActionListener != null) {
            this.getButton().removeActionListener(this.myButtonActionListener);
        }
        this.myButtonActionListener = this.createBrowserAction(project);
        this.getButton().addActionListener(this.myButtonActionListener);
        this.fireChanged();
    }

    @NotNull
    protected abstract ActionListener createBrowserAction(@NotNull Project var1);

    public void setModel(@NotNull List<C> items, @Nullable String selectedItemId) {
        if (items == null) {
            QualityToolConfigurationComboBox.$$$reportNull$$$0(2);
        }
        LinkedList<QualityToolConfigurationItem> myItems = new LinkedList<QualityToolConfigurationItem>();
        if (selectedItemId == null) {
            selectedItemId = this.getDefaultItem().getPresentableName(this.myProject);
        }
        QualityToolConfigurationItem selected = this.getSelectedItem(items, selectedItemId);
        myItems.addFirst(selected);
        if (selected != this.myDefaultConfigurationItem) {
            myItems.add(this.myDefaultConfigurationItem);
        }
        for (QualityToolConfiguration item : items) {
            if (item.getId().equals(selectedItemId)) continue;
            myItems.add(new QualityToolConfigurationItem(item.getId(), item.getPresentableName(this.myProject)));
        }
        this.getComboBox().setModel(new CollectionComboBoxModel(myItems, (Object)selected));
        this.getComboBox().setSelectedItem(selected);
    }

    @NotNull
    private QualityToolConfigurationItem getSelectedItem(@NotNull List<C> configurations, @Nullable String selectedId) {
        if (configurations == null) {
            QualityToolConfigurationComboBox.$$$reportNull$$$0(3);
        }
        if (QualityToolProjectConfiguration.isByDefaultInterpreter(selectedId)) {
            QualityToolConfigurationItem qualityToolConfigurationItem = this.myDefaultConfigurationItem;
            if (qualityToolConfigurationItem == null) {
                QualityToolConfigurationComboBox.$$$reportNull$$$0(4);
            }
            return qualityToolConfigurationItem;
        }
        if (selectedId != null) {
            for (QualityToolConfiguration configuration : configurations) {
                if (!selectedId.equals(configuration.getId())) continue;
                QualityToolConfigurationItem qualityToolConfigurationItem = new QualityToolConfigurationItem(configuration.getId(), configuration.getPresentableName(this.myProject));
                if (qualityToolConfigurationItem == null) {
                    QualityToolConfigurationComboBox.$$$reportNull$$$0(5);
                }
                return qualityToolConfigurationItem;
            }
        }
        C defaultItem = this.getDefaultItem();
        QualityToolConfigurationItem qualityToolConfigurationItem = new QualityToolConfigurationItem(defaultItem.getId(), defaultItem.getPresentableName(this.myProject));
        if (qualityToolConfigurationItem == null) {
            QualityToolConfigurationComboBox.$$$reportNull$$$0(6);
        }
        return qualityToolConfigurationItem;
    }

    protected void editConfigurableList(QualityToolConfigurableList configurableList, QualityToolConfigurationItem item) {
        if (PhpUiUtil.editConfigurable(this.myProject, (Configurable)configurableList)) {
            String oldSelectedId = item == null ? null : item.getId();
            String newSelectedId = QualityToolProjectConfiguration.isByDefaultInterpreter(oldSelectedId) ? oldSelectedId : configurableList.getLastSelectedItemId();
            this.reset(this.myProject, newSelectedId);
        } else {
            this.reset(this.myProject);
        }
    }

    @NotNull
    protected abstract List<C> getItems();

    protected abstract C getDefaultItem();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurationComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurationComboBox";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedItem";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class QualityToolConfigurationItem {
        private final String myId;
        private final String myName;
        private final SimpleTextAttributes myAttributes;

        protected QualityToolConfigurationItem(@NotNull String id, @NotNull String name, @NotNull SimpleTextAttributes attributes) {
            if (id == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(2);
            }
            this.myId = id;
            this.myName = name;
            this.myAttributes = attributes;
        }

        protected QualityToolConfigurationItem(@NotNull String id, @NotNull String name) {
            if (id == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(3);
            }
            if (name == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(4);
            }
            this(id, name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(6);
            }
            return string;
        }

        public void render(@NotNull SimpleColoredComponent wrapper) {
            if (wrapper == null) {
                QualityToolConfigurationItem.$$$reportNull$$$0(7);
            }
            wrapper.append(this.myName, this.myAttributes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurationComboBox$QualityToolConfigurationItem";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurationComboBox$QualityToolConfigurationItem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

