/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticHandler;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PhpMoveInstanceMethodHandler
implements RefactoringActionHandler {
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.instance.method.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        assert (element instanceof Method);
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(2);
        }
        Method method = (Method)elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        ArrayList suitableVariables = new ArrayList();
        String error = PhpMoveInstanceMethodHandler.getErrorAndCollectSuitableVariable(project, method, suitableVariables);
        if (error != null) {
            String makeStaticErrorMessage = PhpMakeStaticHandler.validateTarget(method);
            if (makeStaticErrorMessage != null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)makeStaticErrorMessage, (String)REFACTORING_NAME, null);
            }
            if (makeStaticErrorMessage == null && Messages.showYesNoDialog((Project)project, (String)(error + ". Would you like to make method '" + method.getName() + "' static and then move?"), (String)REFACTORING_NAME, (String)"Make Static", (String)"Cancel", (Icon)Messages.getErrorIcon()) == 0) {
                PhpMakeStaticHandler.invoke(method);
                return;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error, (String)REFACTORING_NAME, null);
            return;
        }
        new PhpMoveInstanceMethodDialog(method, suitableVariables).show();
    }

    public static String getErrorAndCollectSuitableVariable(@NotNull Project project, Method method, List<? super PhpNamedElement> suitableVariables) {
        if (project == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(3);
        }
        Ref error = new Ref();
        suitableVariables.addAll(PhpMoveInstanceMethodHandler.collectSuitableVariables(method));
        if (suitableVariables.isEmpty()) {
            error.set((Object)PhpBundle.message("refactoring.move.method.no.candidates.found", new Object[0]));
        }
        if (method instanceof PhpDocMethod) {
            return PhpBundle.message("refactoring.make.method.static.doc.method.is.not.supported", new Object[0]);
        }
        if (PhpRefactoringUtil.isConstructor(method)) {
            error.set((Object)PhpBundle.message("refactoring.move.method.cannot.move.constructor", new Object[0]));
        } else if (PhpLangUtil.isMagicMethod(method.getName())) {
            error.set((Object)PhpBundle.message("refactoring.move.method.cannot.move.magic.method", new Object[0]));
        }
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)method, (PhpIndex)PhpIndex.getInstance((Project)project), (member, subClass, baseClass) -> {
            error.set((Object)RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy"));
            return false;
        });
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (member, subClass, baseClass) -> {
            error.set((Object)RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy"));
            return false;
        });
        return (String)error.get();
    }

    private static boolean isSuitableType(Project project, PhpType type) {
        if (type.getTypes().size() != 1 && (type.getTypes().size() != 2 || type.filterNull().size() != 1)) {
            return false;
        }
        List stream = type.getTypes().stream().filter(e -> {
            if (PhpType.isNull((String)e) || PhpType.isMixedType((String)e) || PhpType.isCallableType((String)e)) {
                return false;
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (!PhpType.isPrimitiveType((String)e) && !PhpType.isObject((String)StringUtil.toLowerCase((String)e))) {
                Collection classesByFQN = PhpIndex.getInstance((Project)project).getClassesByFQN(e);
                if (classesByFQN.size() == 1) {
                    PhpClass phpClass = (PhpClass)classesByFQN.iterator().next();
                    VirtualFile virtualFile = phpClass.getContainingFile().getVirtualFile();
                    return index.isInContent(virtualFile);
                }
                return !classesByFQN.isEmpty();
            }
            return false;
        }).collect(Collectors.toList());
        return !stream.isEmpty();
    }

    private static List<PhpNamedElement> collectSuitableVariables(Method method) {
        List<Object> toReturn = new ArrayList<Parameter>(Arrays.asList(method.getParameters()));
        PhpClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            toReturn.addAll(containingClass.getFields().stream().filter(e -> !e.getModifier().isPrivate() || e.getContainingClass() == method.getContainingClass()).collect(Collectors.toList()));
        }
        toReturn = toReturn.stream().filter(e -> PhpMoveInstanceMethodHandler.isSuitableType(method.getProject(), e.getType())).collect(Collectors.toList());
        return toReturn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorAndCollectSuitableVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

